/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.pag;

import soot.ArrayType;
import soot.Body;
import soot.G;
import soot.RefLikeType;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.VoidType;
import soot.jimple.Stmt;
import soot.jimple.spark.builder.MethodNodeFactory;
import soot.jimple.spark.pag.AbstractPAG;
import soot.jimple.spark.pag.BDDMethodPAG;
import soot.jimple.spark.pag.BDDPAG;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.MethodPAG;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.ValNode;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.toolkits.pointer.representations.ReferenceVariable;
import soot.jimple.toolkits.pointer.util.NativeMethodDriver;
import soot.util.SingletonList;

public abstract class AbstractMethodPAG {
    SootMethod method;
    protected MethodNodeFactory nodeFactory;
    protected boolean hasBeenAdded = false;
    protected boolean hasBeenBuilt = false;

    public SootMethod getMethod() {
        return this.method;
    }

    public MethodNodeFactory nodeFactory() {
        return this.nodeFactory;
    }

    public abstract AbstractPAG pag();

    public static AbstractMethodPAG v(AbstractPAG pag, SootMethod m) {
        AbstractMethodPAG ret = (AbstractMethodPAG)G.v().MethodPAG_methodToPag.get(m);
        if (ret == null) {
            if (pag instanceof PAG) {
                ret = new MethodPAG((PAG)pag, m);
            } else if (pag instanceof BDDPAG) {
                ret = new BDDMethodPAG((BDDPAG)pag, m);
            }
            G.v().MethodPAG_methodToPag.put(m, ret);
        }
        return ret;
    }

    public void build() {
        if (this.hasBeenBuilt) {
            return;
        }
        this.hasBeenBuilt = true;
        if (this.method.isNative()) {
            if (this.pag().getOpts().simulate_natives()) {
                this.buildNative();
            }
        } else if (this.method.isConcrete() && !this.method.isPhantom()) {
            this.buildNormal();
        }
        this.addMiscEdges();
    }

    protected VarNode parameterize(LocalVarNode vn, Object varNodeParameter) {
        SootMethod m = vn.getMethod();
        if (m != this.method && m != null) {
            throw new RuntimeException("VarNode " + vn + " with method " + m + " parameterized in method " + this.method);
        }
        return this.pag().makeContextVarNode(vn, varNodeParameter);
    }

    protected FieldRefNode parameterize(FieldRefNode frn, Object varNodeParameter) {
        return this.pag().makeFieldRefNode((VarNode)this.parameterize(frn.getBase(), varNodeParameter), frn.getField());
    }

    public Node parameterize(Node n, Object varNodeParameter) {
        if (varNodeParameter == null) {
            return n;
        }
        if (n instanceof LocalVarNode) {
            return this.parameterize((LocalVarNode)n, varNodeParameter);
        }
        if (n instanceof FieldRefNode) {
            return this.parameterize((FieldRefNode)n, varNodeParameter);
        }
        return n;
    }

    public abstract void addToPAG(Object var1);

    public abstract void addInternalEdge(Node var1, Node var2);

    public abstract void addInEdge(Node var1, Node var2);

    public abstract void addOutEdge(Node var1, Node var2);

    protected void buildNormal() {
        Body b = this.method.retrieveActiveBody();
        for (Stmt s : b.getUnits()) {
            this.nodeFactory.handleStmt(s);
        }
    }

    protected void buildNative() {
        ValNode thisNode = null;
        ValNode retNode = null;
        if (!this.method.isStatic()) {
            thisNode = (ValNode)this.nodeFactory.caseThis();
        }
        if (this.method.getReturnType() instanceof RefLikeType) {
            retNode = (ValNode)this.nodeFactory.caseRet();
        }
        ReferenceVariable[] args = new ValNode[this.method.getParameterCount()];
        for (int i = 0; i < this.method.getParameterCount(); ++i) {
            if (!(this.method.getParameterType(i) instanceof RefLikeType)) continue;
            args[i] = (ValNode)this.nodeFactory.caseParm(i);
        }
        NativeMethodDriver.v().process(this.method, thisNode, retNode, args);
    }

    protected void addMiscEdges() {
        block5: {
            if (this.method.getSubSignature().equals(SootMethod.getSubSignature("main", new SingletonList(ArrayType.v(RefType.v("java.lang.String"), 1)), VoidType.v()))) {
                this.addInEdge(this.pag().nodeFactory().caseArgv(), this.nodeFactory.caseParm(0));
            }
            if (this.method.getSignature().equals("<java.lang.Thread: void <init>(java.lang.ThreadGroup,java.lang.String)>")) {
                this.addInEdge(this.pag().nodeFactory().caseMainThread(), this.nodeFactory.caseThis());
                this.addInEdge(this.pag().nodeFactory().caseMainThreadGroup(), this.nodeFactory.caseParm(0));
            }
            if (this.method.getSubSignature().equals("java.lang.Class loadClass(java.lang.String)")) {
                SootClass c = this.method.getDeclaringClass();
                while (!c.getName().equals("java.lang.ClassLoader")) {
                    if (c.hasSuperclass()) {
                        c = c.getSuperclass();
                        continue;
                    }
                    break block5;
                }
                this.addInEdge(this.pag().nodeFactory().caseDefaultClassLoader(), this.nodeFactory.caseThis());
                this.addInEdge(this.pag().nodeFactory().caseMainClassNameString(), this.nodeFactory.caseParm(0));
            }
        }
    }
}

