/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.internal;

import soot.AnySubType;
import soot.G;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.Type;
import soot.jimple.spark.internal.AbstractTypeManager;
import soot.jimple.spark.pag.AbstractPAG;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.Node;
import soot.util.BitVector;
import soot.util.LargeNumberedMap;
import soot.util.Numberer;

public final class TypeManager
extends AbstractTypeManager {
    private LargeNumberedMap typeMask = null;

    public TypeManager(AbstractPAG pag) {
        super(pag);
    }

    public final BitVector get(Type type) {
        AllocNode n;
        if (type == null) {
            return null;
        }
        while ((n = (AllocNode)this.allocNodeListener.next()) != null) {
            Numberer.NumbererIterator tIt = Scene.v().getTypeNumberer().iterator();
            while (tIt.hasNext()) {
                Type t = (Type)tIt.next();
                if (!(t instanceof RefLikeType) || t instanceof AnySubType || !this.castNeverFails(n.getType(), t)) continue;
                BitVector mask = (BitVector)this.typeMask.get(t);
                if (mask == null) {
                    mask = new BitVector();
                    this.typeMask.put(t, mask);
                    Numberer.NumbererIterator anIt = this.pag.getAllocNodeNumberer().iterator();
                    while (anIt.hasNext()) {
                        AllocNode an = (AllocNode)anIt.next();
                        if (!this.castNeverFails(an.getType(), t)) continue;
                        mask.set(an.getNumber());
                    }
                    continue;
                }
                mask.set(n.getNumber());
            }
        }
        BitVector ret = (BitVector)this.typeMask.get(type);
        if (ret == null && this.fh != null) {
            throw new RuntimeException("oops" + type);
        }
        return ret;
    }

    public final void clearTypeMask() {
        this.typeMask = null;
    }

    public final void makeTypeMask() {
        RefType.v("java.lang.Class");
        this.typeMask = new LargeNumberedMap(Scene.v().getTypeNumberer());
        if (this.fh == null) {
            return;
        }
        int numTypes = Scene.v().getTypeNumberer().size();
        if (this.pag.getOpts().verbose()) {
            G.v().out.println("Total types: " + numTypes);
        }
        Numberer allocNodes = this.pag.getAllocNodeNumberer();
        Numberer.NumbererIterator tIt = Scene.v().getTypeNumberer().iterator();
        while (tIt.hasNext()) {
            Type t = (Type)tIt.next();
            if (!(t instanceof RefLikeType) || t instanceof AnySubType) continue;
            BitVector mask = new BitVector(allocNodes.size());
            Numberer.NumbererIterator nIt = allocNodes.iterator();
            while (nIt.hasNext()) {
                Node n = (Node)nIt.next();
                if (!this.castNeverFails(n.getType(), t)) continue;
                mask.set(n.getNumber());
            }
            this.typeMask.put(t, mask);
        }
        this.allocNodeListener = this.pag.allocNodeListener();
    }
}

