/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.builder;

import java.util.Iterator;
import soot.G;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.spark.internal.SparkNativeHelper;
import soot.jimple.spark.pag.AbstractMethodPAG;
import soot.jimple.spark.pag.AbstractPAG;
import soot.jimple.spark.pag.BDDPAG;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.solver.OnFlyCallGraph;
import soot.jimple.toolkits.callgraph.CallGraphBuilder;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.jimple.toolkits.pointer.DumbPointerAnalysis;
import soot.jimple.toolkits.pointer.util.NativeHelper;
import soot.options.AbstractSparkOptions;
import soot.options.BDDSparkOptions;
import soot.options.SparkOptions;
import soot.util.queue.QueueReader;

public class ContextInsensitiveBuilder {
    private AbstractPAG pag;
    private CallGraphBuilder cgb;
    private OnFlyCallGraph ofcg;
    private ReachableMethods reachables;
    int classes = 0;
    int totalMethods = 0;
    int analyzedMethods = 0;
    int stmts = 0;

    public void preJimplify() {
        for (SootClass c : Scene.v().getClasses()) {
            Iterator mIt = c.methodIterator();
            while (mIt.hasNext()) {
                SootMethod m = (SootMethod)mIt.next();
                if (!m.isConcrete() || m.isNative() || m.isPhantom()) continue;
                m.retrieveActiveBody();
            }
        }
    }

    public AbstractPAG setup(AbstractSparkOptions opts) {
        if (opts instanceof SparkOptions) {
            this.pag = new PAG((SparkOptions)opts);
        } else if (opts instanceof BDDSparkOptions) {
            this.pag = new BDDPAG((BDDSparkOptions)opts);
        } else {
            throw new RuntimeException();
        }
        if (opts.simulate_natives()) {
            NativeHelper.register(new SparkNativeHelper(this.pag));
        }
        if (opts.on_fly_cg() && !opts.vta()) {
            this.ofcg = new OnFlyCallGraph((PAG)this.pag);
            this.pag.setOnFlyCallGraph(this.ofcg);
        } else {
            this.cgb = new CallGraphBuilder(DumbPointerAnalysis.v());
        }
        return this.pag;
    }

    public void build() {
        Edge e;
        QueueReader callEdges;
        if (this.ofcg != null) {
            callEdges = this.ofcg.callGraph().listener();
            this.ofcg.build();
            this.reachables = this.ofcg.reachableMethods();
            this.reachables.update();
        } else {
            callEdges = this.cgb.getCallGraph().listener();
            this.cgb.build();
            this.reachables = this.cgb.reachables();
        }
        for (SootClass c : Scene.v().getClasses()) {
            this.handleClass(c);
        }
        Object s = null;
        while ((e = (Edge)callEdges.next()) != null) {
            AbstractMethodPAG.v(this.pag, e.tgt()).addToPAG(null);
            this.pag.addCallTarget(e);
        }
        if (this.pag.getOpts().verbose()) {
            G.v().out.println("Total methods: " + this.totalMethods);
            G.v().out.println("Initially reachable methods: " + this.analyzedMethods);
            G.v().out.println("Classes with at least one reachable method: " + this.classes);
        }
    }

    protected void handleClass(SootClass c) {
        boolean incedClasses = false;
        Iterator methodsIt = c.methodIterator();
        while (methodsIt.hasNext()) {
            SootMethod m = (SootMethod)methodsIt.next();
            if (!m.isConcrete() && !m.isNative()) continue;
            ++this.totalMethods;
            if (!this.reachables.contains(m)) continue;
            AbstractMethodPAG mpag = AbstractMethodPAG.v(this.pag, m);
            mpag.build();
            mpag.addToPAG(null);
            ++this.analyzedMethods;
            if (incedClasses) continue;
            incedClasses = true;
            ++this.classes;
        }
    }
}

