/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.ThrowInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.StmtSwitch;
import soot.jimple.ThrowStmt;
import soot.jimple.internal.AbstractStmt;
import soot.tagkit.Tag;
import soot.util.Switch;

public class JThrowStmt
extends AbstractStmt
implements ThrowStmt {
    ValueBox opBox;

    public JThrowStmt(Value op) {
        this(Jimple.v().newImmediateBox(op));
    }

    protected JThrowStmt(ValueBox opBox) {
        this.opBox = opBox;
    }

    public Object clone() {
        return new JThrowStmt(Jimple.cloneIfNecessary(this.getOp()));
    }

    public ValueBox getOpBox() {
        return this.opBox;
    }

    public Value getOp() {
        return this.opBox.getValue();
    }

    public void setOp(Value op) {
        this.opBox.setValue(op);
    }

    public String toString() {
        return "throw " + this.opBox.getValue().toString();
    }

    public void toString(UnitPrinter up) {
        Jimple.v();
        up.literal("throw");
        up.literal(" ");
        this.opBox.toString(up);
    }

    public List getUseBoxes() {
        ArrayList<ValueBox> useBoxes = new ArrayList<ValueBox>();
        useBoxes.addAll(this.opBox.getValue().getUseBoxes());
        useBoxes.add(this.opBox);
        return useBoxes;
    }

    public void apply(Switch sw) {
        ((StmtSwitch)sw).caseThrowStmt(this);
    }

    public void convertToBaf(JimpleToBafContext context, List out) {
        ((ConvertToBaf)((Object)this.getOp())).convertToBaf(context, out);
        ThrowInst u = Baf.v().newThrowInst();
        out.add(u);
        JThrowStmt currentUnit = this;
        Iterator it = currentUnit.getTags().iterator();
        while (it.hasNext()) {
            u.addTag((Tag)it.next());
        }
    }

    public boolean fallsThrough() {
        return false;
    }

    public boolean branches() {
        return false;
    }
}

