/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.PlaceholderInst;
import soot.baf.TableSwitchInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.Stmt;
import soot.jimple.StmtSwitch;
import soot.jimple.TableSwitchStmt;
import soot.jimple.internal.AbstractStmt;
import soot.tagkit.Tag;
import soot.util.Switch;

public class JTableSwitchStmt
extends AbstractStmt
implements TableSwitchStmt {
    UnitBox defaultTargetBox;
    ValueBox keyBox;
    int lowIndex;
    int highIndex;
    UnitBox[] targetBoxes;
    List stmtBoxes;

    public Object clone() {
        return new JTableSwitchStmt(Jimple.v().newImmediateBox(Jimple.cloneIfNecessary(this.getKey())), this.lowIndex, this.highIndex, JTableSwitchStmt.getTargetBoxesArray(this.getTargets()), Jimple.v().newStmtBox(this.getDefaultTarget()));
    }

    private static UnitBox[] getTargetBoxesArray(List targets) {
        UnitBox[] targetBoxes = new UnitBox[targets.size()];
        for (int i = 0; i < targetBoxes.length; ++i) {
            targetBoxes[i] = Jimple.v().newStmtBox((Stmt)targets.get(i));
        }
        return targetBoxes;
    }

    public JTableSwitchStmt(Value key, int lowIndex, int highIndex, List targets, Unit defaultTarget) {
        this(Jimple.v().newImmediateBox(key), lowIndex, highIndex, JTableSwitchStmt.getTargetBoxesArray(targets), Jimple.v().newStmtBox(defaultTarget));
    }

    public JTableSwitchStmt(Value key, int lowIndex, int highIndex, List targets, UnitBox defaultTarget) {
        this(Jimple.v().newImmediateBox(key), lowIndex, highIndex, JTableSwitchStmt.unitBoxListToArray(targets), defaultTarget);
    }

    private static UnitBox[] unitBoxListToArray(List targets) {
        UnitBox[] targetBoxes = new UnitBox[targets.size()];
        for (int i = 0; i < targetBoxes.length; ++i) {
            targetBoxes[i] = (UnitBox)targets.get(i);
        }
        return targetBoxes;
    }

    protected JTableSwitchStmt(ValueBox keyBox, int lowIndex, int highIndex, UnitBox[] targetBoxes, UnitBox defaultTargetBox) {
        this.keyBox = keyBox;
        this.defaultTargetBox = defaultTargetBox;
        if (lowIndex > highIndex) {
            throw new RuntimeException("Error creating tableswitch: lowIndex(" + lowIndex + ") can't be greater than highIndex(" + highIndex + ").");
        }
        this.lowIndex = lowIndex;
        this.highIndex = highIndex;
        this.targetBoxes = targetBoxes;
        this.stmtBoxes = new ArrayList();
        for (int i = 0; i < targetBoxes.length; ++i) {
            this.stmtBoxes.add(targetBoxes[i]);
        }
        this.stmtBoxes.add(defaultTargetBox);
        this.stmtBoxes = Collections.unmodifiableList(this.stmtBoxes);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String endOfLine = " ";
        StringBuilder stringBuilder = new StringBuilder();
        Jimple.v();
        buffer.append(stringBuilder.append("tableswitch").append("(").append(this.keyBox.getValue().toString()).append(")").append(endOfLine).toString());
        buffer.append("{" + endOfLine);
        for (int i = this.lowIndex; i <= this.highIndex; ++i) {
            StringBuilder stringBuilder2 = new StringBuilder().append("    ");
            Jimple.v();
            StringBuilder stringBuilder3 = stringBuilder2.append("case").append(" ").append(i).append(": ");
            Jimple.v();
            buffer.append(stringBuilder3.append("goto").append(" ").append(this.getTarget(i - this.lowIndex)).append(";").append(endOfLine).toString());
        }
        StringBuilder stringBuilder4 = new StringBuilder().append("    ");
        Jimple.v();
        StringBuilder stringBuilder5 = stringBuilder4.append("default").append(": ");
        Jimple.v();
        buffer.append(stringBuilder5.append("goto").append(" ").append(this.getDefaultTarget()).append(";").append(endOfLine).toString());
        buffer.append("}");
        return buffer.toString();
    }

    public void toString(UnitPrinter up) {
        Jimple.v();
        up.literal("tableswitch");
        up.literal("(");
        this.keyBox.toString(up);
        up.literal(")");
        up.newline();
        up.literal("{");
        up.newline();
        for (int i = this.lowIndex; i <= this.highIndex; ++i) {
            up.literal("    ");
            Jimple.v();
            up.literal("case");
            up.literal(" ");
            up.literal(new Integer(i).toString());
            up.literal(": ");
            Jimple.v();
            up.literal("goto");
            up.literal(" ");
            this.targetBoxes[i - this.lowIndex].toString(up);
            up.literal(";");
            up.newline();
        }
        up.literal("    ");
        Jimple.v();
        up.literal("default");
        up.literal(": ");
        Jimple.v();
        up.literal("goto");
        up.literal(" ");
        this.defaultTargetBox.toString(up);
        up.literal(";");
        up.newline();
        up.literal("}");
    }

    public Unit getDefaultTarget() {
        return this.defaultTargetBox.getUnit();
    }

    public void setDefaultTarget(Unit defaultTarget) {
        this.defaultTargetBox.setUnit(defaultTarget);
    }

    public UnitBox getDefaultTargetBox() {
        return this.defaultTargetBox;
    }

    public Value getKey() {
        return this.keyBox.getValue();
    }

    public void setKey(Value key) {
        this.keyBox.setValue(key);
    }

    public ValueBox getKeyBox() {
        return this.keyBox;
    }

    public void setLowIndex(int lowIndex) {
        this.lowIndex = lowIndex;
    }

    public void setHighIndex(int highIndex) {
        this.highIndex = highIndex;
    }

    public int getLowIndex() {
        return this.lowIndex;
    }

    public int getHighIndex() {
        return this.highIndex;
    }

    public List getTargets() {
        ArrayList<Unit> targets = new ArrayList<Unit>();
        for (int i = 0; i < this.targetBoxes.length; ++i) {
            targets.add(this.targetBoxes[i].getUnit());
        }
        return targets;
    }

    public Unit getTarget(int index) {
        return this.targetBoxes[index].getUnit();
    }

    public void setTarget(int index, Unit target) {
        this.targetBoxes[index].setUnit(target);
    }

    public void setTargets(List targets) {
        for (int i = 0; i < targets.size(); ++i) {
            this.targetBoxes[i].setUnit((Stmt)targets.get(i));
        }
    }

    public UnitBox getTargetBox(int index) {
        return this.targetBoxes[index];
    }

    public List getUseBoxes() {
        ArrayList<ValueBox> list = new ArrayList<ValueBox>();
        list.addAll(this.keyBox.getValue().getUseBoxes());
        list.add(this.keyBox);
        return list;
    }

    public List getUnitBoxes() {
        return this.stmtBoxes;
    }

    public void apply(Switch sw) {
        ((StmtSwitch)sw).caseTableSwitchStmt(this);
    }

    public void convertToBaf(JimpleToBafContext context, List out) {
        ArrayList<PlaceholderInst> targetPlaceholders = new ArrayList<PlaceholderInst>();
        ((ConvertToBaf)((Object)this.getKey())).convertToBaf(context, out);
        for (int i = 0; i < this.targetBoxes.length; ++i) {
            targetPlaceholders.add(Baf.v().newPlaceholderInst(this.getTarget(i)));
        }
        TableSwitchInst u = Baf.v().newTableSwitchInst(Baf.v().newPlaceholderInst(this.getDefaultTarget()), this.lowIndex, this.highIndex, targetPlaceholders);
        out.add(u);
        JTableSwitchStmt currentUnit = this;
        Iterator it = currentUnit.getTags().iterator();
        while (it.hasNext()) {
            u.addTag((Tag)it.next());
        }
    }

    public boolean fallsThrough() {
        return false;
    }

    public boolean branches() {
        return true;
    }
}

