/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPrinter;
import soot.baf.Baf;
import soot.baf.GotoInst;
import soot.jimple.GotoStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.StmtSwitch;
import soot.jimple.internal.AbstractStmt;
import soot.tagkit.Tag;
import soot.util.Switch;

public class JGotoStmt
extends AbstractStmt
implements GotoStmt {
    UnitBox targetBox;
    List targetBoxes;

    public JGotoStmt(Unit target) {
        this(Jimple.v().newStmtBox(target));
    }

    public JGotoStmt(UnitBox box) {
        this.targetBox = box;
        this.targetBoxes = new ArrayList();
        this.targetBoxes.add(this.targetBox);
        this.targetBoxes = Collections.unmodifiableList(this.targetBoxes);
    }

    public Object clone() {
        return new JGotoStmt(this.getTarget());
    }

    public String toString() {
        Unit t = this.getTarget();
        String target = "(branch)";
        if (!t.branches()) {
            target = t.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        Jimple.v();
        return stringBuilder.append("goto").append(" [?= ").append(target).append("]").toString();
    }

    public void toString(UnitPrinter up) {
        Jimple.v();
        up.literal("goto");
        up.literal(" ");
        this.targetBox.toString(up);
    }

    public Unit getTarget() {
        return this.targetBox.getUnit();
    }

    public void setTarget(Unit target) {
        this.targetBox.setUnit(target);
    }

    public UnitBox getTargetBox() {
        return this.targetBox;
    }

    public List getUnitBoxes() {
        return this.targetBoxes;
    }

    public void apply(Switch sw) {
        ((StmtSwitch)sw).caseGotoStmt(this);
    }

    public void convertToBaf(JimpleToBafContext context, List out) {
        GotoInst u = Baf.v().newGotoInst(Baf.v().newPlaceholderInst(this.getTarget()));
        out.add(u);
        Iterator it = this.getTags().iterator();
        while (it.hasNext()) {
            u.addTag((Tag)it.next());
        }
    }

    public boolean fallsThrough() {
        return false;
    }

    public boolean branches() {
        return true;
    }
}

