/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.SootMethod;
import soot.Unit;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.StaticInvokeInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.ExprSwitch;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.internal.AbstractInvokeExpr;
import soot.tagkit.Tag;
import soot.util.Switch;

public abstract class AbstractStaticInvokeExpr
extends AbstractInvokeExpr
implements StaticInvokeExpr,
ConvertToBaf {
    AbstractStaticInvokeExpr(SootMethod method, List args) {
        this(method, new ValueBox[args.size()]);
        for (int i = 0; i < args.size(); ++i) {
            this.argBoxes[i] = Jimple.v().newImmediateBox((Value)args.get(i));
        }
    }

    public boolean equivTo(Object o) {
        if (o instanceof AbstractStaticInvokeExpr) {
            AbstractStaticInvokeExpr ie = (AbstractStaticInvokeExpr)o;
            if (!this.method.equals(ie.method) || this.argBoxes.length != ie.argBoxes.length) {
                return false;
            }
            for (int i = 0; i < this.argBoxes.length; ++i) {
                if (this.argBoxes[i].getValue().equivTo(ie.argBoxes[i].getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int equivHashCode() {
        return this.method.equivHashCode();
    }

    public abstract Object clone();

    protected AbstractStaticInvokeExpr(SootMethod method, ValueBox[] argBoxes) {
        this.method = method;
        this.argBoxes = argBoxes;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        StringBuilder stringBuilder = new StringBuilder();
        Jimple.v();
        buffer.append(stringBuilder.append("staticinvoke").append(" ").append(this.method.getSignature()).append("(").toString());
        for (int i = 0; i < this.argBoxes.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.argBoxes[i].getValue().toString());
        }
        buffer.append(")");
        return buffer.toString();
    }

    public void toString(UnitPrinter up) {
        Jimple.v();
        up.literal("staticinvoke");
        up.literal(" ");
        up.method(this.method);
        up.literal("(");
        for (int i = 0; i < this.argBoxes.length; ++i) {
            if (i != 0) {
                up.literal(", ");
            }
            this.argBoxes[i].toString(up);
        }
        up.literal(")");
    }

    public List getUseBoxes() {
        ArrayList<ValueBox> list = new ArrayList<ValueBox>();
        for (int i = 0; i < this.argBoxes.length; ++i) {
            list.addAll(this.argBoxes[i].getValue().getUseBoxes());
            list.add(this.argBoxes[i]);
        }
        return list;
    }

    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseStaticInvokeExpr(this);
    }

    public void convertToBaf(JimpleToBafContext context, List out) {
        for (int i = 0; i < this.argBoxes.length; ++i) {
            ((ConvertToBaf)((Object)this.argBoxes[i].getValue())).convertToBaf(context, out);
        }
        StaticInvokeInst u = Baf.v().newStaticInvokeInst(this.method);
        out.add(u);
        Unit currentUnit = context.getCurrentUnit();
        Iterator it = currentUnit.getTags().iterator();
        while (it.hasNext()) {
            u.addTag((Tag)it.next());
        }
    }
}

