/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.ArrayType;
import soot.Type;
import soot.Unit;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.NewMultiArrayInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.ExprSwitch;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.NewMultiArrayExpr;
import soot.tagkit.Tag;
import soot.util.Switch;

public abstract class AbstractNewMultiArrayExpr
implements NewMultiArrayExpr,
ConvertToBaf {
    ArrayType baseType;
    protected ValueBox[] sizeBoxes;

    public abstract Object clone();

    protected AbstractNewMultiArrayExpr(ArrayType type, ValueBox[] sizeBoxes) {
        this.baseType = type;
        this.sizeBoxes = sizeBoxes;
    }

    public boolean equivTo(Object o) {
        if (o instanceof AbstractNewMultiArrayExpr) {
            AbstractNewMultiArrayExpr ae = (AbstractNewMultiArrayExpr)o;
            if (!this.baseType.equals(ae.baseType) || this.sizeBoxes.length != ae.sizeBoxes.length) {
                return false;
            }
            for (int i = 0; i < this.sizeBoxes.length; ++i) {
                if (this.sizeBoxes[i] == ae.sizeBoxes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int equivHashCode() {
        return this.baseType.hashCode();
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        Type t = this.baseType.baseType;
        StringBuilder stringBuilder = new StringBuilder();
        Jimple.v();
        buffer.append(stringBuilder.append("newmultiarray").append(" (").append(t.toString()).append(")").toString());
        for (i = 0; i < this.sizeBoxes.length; ++i) {
            buffer.append("[" + this.sizeBoxes[i].getValue().toString() + "]");
        }
        for (i = 0; i < this.baseType.numDimensions - this.sizeBoxes.length; ++i) {
            buffer.append("[]");
        }
        return buffer.toString();
    }

    public void toString(UnitPrinter up) {
        int i;
        Type t = this.baseType.baseType;
        Jimple.v();
        up.literal("newmultiarray");
        up.literal(" (");
        up.type(t);
        up.literal(")");
        for (i = 0; i < this.sizeBoxes.length; ++i) {
            up.literal("[");
            this.sizeBoxes[i].toString(up);
            up.literal("]");
        }
        for (i = 0; i < this.baseType.numDimensions - this.sizeBoxes.length; ++i) {
            up.literal("[]");
        }
    }

    public ArrayType getBaseType() {
        return this.baseType;
    }

    public void setBaseType(ArrayType baseType) {
        this.baseType = baseType;
    }

    public ValueBox getSizeBox(int index) {
        return this.sizeBoxes[index];
    }

    public int getSizeCount() {
        return this.sizeBoxes.length;
    }

    public Value getSize(int index) {
        return this.sizeBoxes[index].getValue();
    }

    public List getSizes() {
        ArrayList<Value> toReturn = new ArrayList<Value>();
        for (int i = 0; i < this.sizeBoxes.length; ++i) {
            toReturn.add(this.sizeBoxes[i].getValue());
        }
        return toReturn;
    }

    public void setSize(int index, Value size) {
        this.sizeBoxes[index].setValue(size);
    }

    public List getUseBoxes() {
        ArrayList<ValueBox> list = new ArrayList<ValueBox>();
        for (int i = 0; i < this.sizeBoxes.length; ++i) {
            list.addAll(this.sizeBoxes[i].getValue().getUseBoxes());
            list.add(this.sizeBoxes[i]);
        }
        return list;
    }

    public Type getType() {
        return this.baseType;
    }

    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseNewMultiArrayExpr(this);
    }

    public void convertToBaf(JimpleToBafContext context, List out) {
        List sizes = this.getSizes();
        for (int i = 0; i < sizes.size(); ++i) {
            ((ConvertToBaf)sizes.get(i)).convertToBaf(context, out);
        }
        NewMultiArrayInst u = Baf.v().newNewMultiArrayInst(this.getBaseType(), sizes.size());
        out.add(u);
        Unit currentUnit = context.getCurrentUnit();
        Iterator it = currentUnit.getTags().iterator();
        while (it.hasNext()) {
            u.addTag((Tag)it.next());
        }
    }
}

