/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.List;
import soot.AbstractUnit;
import soot.Scene;
import soot.SootField;
import soot.Type;
import soot.UnitPrinter;
import soot.baf.Baf;
import soot.baf.StaticGetInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.FieldRef;
import soot.jimple.JimpleToBafContext;
import soot.jimple.RefSwitch;
import soot.tagkit.Tag;
import soot.util.Switch;

public class StaticFieldRef
implements FieldRef,
ConvertToBaf {
    SootField field;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.field = Scene.v().getField((String)in.readObject());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.field.getSignature());
    }

    protected StaticFieldRef(SootField field) {
        this.field = field;
    }

    public Object clone() {
        return new StaticFieldRef(this.field);
    }

    public String toString() {
        return this.field.getSignature();
    }

    public void toString(UnitPrinter up) {
        up.fieldRef(this.field);
    }

    public SootField getField() {
        return this.field;
    }

    public void setField(SootField field) {
        this.field = field;
    }

    public List getUseBoxes() {
        return AbstractUnit.emptyList;
    }

    public Type getType() {
        return this.field.getType();
    }

    public void apply(Switch sw) {
        ((RefSwitch)sw).caseStaticFieldRef(this);
    }

    public boolean equivTo(Object o) {
        if (o instanceof StaticFieldRef) {
            return ((StaticFieldRef)o).field.equals(this.field);
        }
        return false;
    }

    public int equivHashCode() {
        return this.field.equivHashCode();
    }

    public void convertToBaf(JimpleToBafContext context, List out) {
        StaticGetInst u = Baf.v().newStaticGetInst(this.field);
        out.add(u);
        Iterator it = context.getCurrentUnit().getTags().iterator();
        while (it.hasNext()) {
            u.addTag((Tag)it.next());
        }
    }
}

