/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import soot.Body;
import soot.Local;
import soot.PointsToAnalysis;
import soot.RefLikeType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;

public class ReachingTypeDumper {
    protected PointsToAnalysis pa;
    protected String output_dir;

    public ReachingTypeDumper(PointsToAnalysis pa, String output_dir) {
        this.pa = pa;
        this.output_dir = output_dir;
    }

    public void dump() {
        try {
            PrintWriter file = new PrintWriter(new FileOutputStream(new File(this.output_dir, "types")));
            Iterator it = Scene.v().getApplicationClasses().iterator();
            while (it.hasNext()) {
                this.handleClass(file, (SootClass)it.next());
            }
            it = Scene.v().getLibraryClasses().iterator();
            while (it.hasNext()) {
                this.handleClass(file, (SootClass)it.next());
            }
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump reaching types." + e);
        }
    }

    protected void handleClass(PrintWriter out, SootClass c) {
        Iterator mIt = c.methodIterator();
        while (mIt.hasNext()) {
            SootMethod m = (SootMethod)mIt.next();
            if (!m.isConcrete()) continue;
            Body b = m.retrieveActiveBody();
            TreeSet sortedLocals = new TreeSet(new StringComparator());
            sortedLocals.addAll(b.getLocals());
            for (Local l : sortedLocals) {
                out.println("V " + m + l);
                if (!(l.getType() instanceof RefLikeType)) continue;
                Set types = this.pa.reachingObjects(l).possibleTypes();
                TreeSet sortedTypes = new TreeSet(new StringComparator());
                sortedTypes.addAll(types);
                Iterator tIt = sortedTypes.iterator();
                while (tIt.hasNext()) {
                    out.println("T " + tIt.next());
                }
            }
        }
    }

    class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

