/*
 * Decompiled with CFR 0.152.
 */
package soot.javaToJimple;

import java.util.ArrayList;
import java.util.Iterator;
import soot.Body;
import soot.Local;
import soot.MethodSource;
import soot.PackManager;
import soot.RefType;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.VoidType;
import soot.jimple.AssignStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.ThisRef;

public class AnonClassInitMethodSource
implements MethodSource {
    private ArrayList finalLocals;
    private ArrayList fields;
    private Type outerClassType;

    public void setFinalLocals(ArrayList list) {
        this.finalLocals = list;
    }

    public void setFieldList(ArrayList list) {
        this.fields = list;
    }

    public Body getBody(SootMethod sootMethod, String phaseName) {
        JimpleBody body = Jimple.v().newBody(sootMethod);
        RefType type = sootMethod.getDeclaringClass().getType();
        Local thisLocal = Jimple.v().newLocal("this", type);
        body.getLocals().add(thisLocal);
        ThisRef thisRef = Jimple.v().newThisRef(type);
        IdentityStmt thisStmt = Jimple.v().newIdentityStmt(thisLocal, thisRef);
        body.getUnits().add(thisStmt);
        ArrayList<Local> invokeList = new ArrayList<Local>();
        ArrayList<Type> invokeTypeList = new ArrayList<Type>();
        Local outerLocal = null;
        int numParams = sootMethod.getParameterCount();
        int numFinals = 0;
        if (this.fields != null) {
            numFinals = this.fields.size();
        }
        int startFinals = numParams - numFinals;
        ArrayList<Local> paramsForFinals = new ArrayList<Local>();
        Iterator fIt = sootMethod.getParameterTypes().iterator();
        int counter = 0;
        while (fIt.hasNext()) {
            Type fType = (Type)fIt.next();
            Local local = Jimple.v().newLocal("r" + counter, fType);
            body.getLocals().add(local);
            ParameterRef paramRef = Jimple.v().newParameterRef(fType, counter);
            IdentityStmt stmt = Jimple.v().newIdentityStmt(local, paramRef);
            if (counter != 0 && counter < startFinals) {
                invokeTypeList.add(fType);
                invokeList.add(local);
            } else if (counter == 0) {
                outerLocal = local;
            } else {
                paramsForFinals.add(local);
            }
            body.getUnits().add(stmt);
            ++counter;
        }
        SootMethod callMethod = sootMethod.getDeclaringClass().getSuperclass().getMethod("<init>", invokeTypeList, VoidType.v());
        SpecialInvokeExpr invoke = Jimple.v().newSpecialInvokeExpr(thisLocal, callMethod, invokeList);
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(invoke);
        body.getUnits().add(invokeStmt);
        SootField field = sootMethod.getDeclaringClass().getField("this$0", this.outerClassType);
        InstanceFieldRef ref = Jimple.v().newInstanceFieldRef(thisLocal, field);
        AssignStmt assign = Jimple.v().newAssignStmt(ref, outerLocal);
        body.getUnits().add(assign);
        if (this.fields != null) {
            Iterator finalsIt = paramsForFinals.iterator();
            Iterator fieldsIt = this.fields.iterator();
            while (finalsIt.hasNext() && fieldsIt.hasNext()) {
                Local pLocal = (Local)finalsIt.next();
                SootField pField = (SootField)fieldsIt.next();
                InstanceFieldRef pRef = Jimple.v().newInstanceFieldRef(thisLocal, pField);
                AssignStmt pAssign = Jimple.v().newAssignStmt(pRef, pLocal);
                body.getUnits().add(pAssign);
            }
        }
        ReturnVoidStmt retStmt = Jimple.v().newReturnVoidStmt();
        body.getUnits().add(retStmt);
        PackManager.v().getPack("jj").apply(body);
        return body;
    }

    public Type outerClassType() {
        return this.outerClassType;
    }

    public void outerClassType(Type type) {
        this.outerClassType = type;
    }
}

