/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.misc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import soot.Body;
import soot.G;
import soot.PatchingChain;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.CallGraphBuilder;
import soot.jimple.toolkits.callgraph.Edge;
import soot.util.IterableSet;

public class ThrowFinder {
    private HashSet registeredMethods;
    private HashMap protectionSet;

    public ThrowFinder(Singletons.Global g) {
    }

    public static ThrowFinder v() {
        return G.v().ThrowFinder();
    }

    public void find() {
        CallGraph cg;
        G.v().out.print("Verifying exception handling.. ");
        this.registeredMethods = new HashSet();
        this.protectionSet = new HashMap();
        if (Scene.v().hasCallGraph()) {
            cg = Scene.v().getCallGraph();
        } else {
            new CallGraphBuilder().build();
            cg = Scene.v().getCallGraph();
            Scene.v().releaseCallGraph();
        }
        IterableSet worklist = new IterableSet();
        G.v().out.print("\b. ");
        G.v().out.flush();
        Iterator classIt = Scene.v().getApplicationClasses().iterator();
        while (classIt.hasNext()) {
            Iterator methodIt = ((SootClass)classIt.next()).methodIterator();
            while (methodIt.hasNext()) {
                SootMethod m = (SootMethod)methodIt.next();
                this.register_AreasOfProtection(m);
                worklist.add(m);
            }
        }
        HashMap<SootClass, IterableSet> subClassSet = new HashMap<SootClass, IterableSet>();
        HashMap<SootClass, IterableSet> superClassSet = new HashMap<SootClass, IterableSet>();
        HashSet applicationClasses = new HashSet();
        applicationClasses.addAll(Scene.v().getApplicationClasses());
        for (SootClass c : Scene.v().getApplicationClasses()) {
            IterableSet subClasses;
            IterableSet superClasses = (IterableSet)superClassSet.get(c);
            if (superClasses == null) {
                superClasses = new IterableSet();
                superClassSet.put(c, superClasses);
            }
            if ((subClasses = (IterableSet)subClassSet.get(c)) == null) {
                subClasses = new IterableSet();
                subClassSet.put(c, subClasses);
            }
            if (c.hasSuperclass()) {
                SootClass superClass = c.getSuperclass();
                IterableSet superClassSubClasses = (IterableSet)subClassSet.get(superClass);
                if (superClassSubClasses == null) {
                    superClassSubClasses = new IterableSet();
                    subClassSet.put(superClass, superClassSubClasses);
                }
                superClassSubClasses.add(c);
                superClasses.add(superClass);
            }
            for (SootClass interfaceClass : c.getInterfaces()) {
                IterableSet interfaceClassSubClasses = (IterableSet)subClassSet.get(interfaceClass);
                if (interfaceClassSubClasses == null) {
                    interfaceClassSubClasses = new IterableSet();
                    subClassSet.put(interfaceClass, interfaceClassSubClasses);
                }
                interfaceClassSubClasses.add(c);
                superClasses.add(interfaceClass);
            }
        }
        HashMap agreementMethodSet = new HashMap();
        for (SootMethod m : worklist) {
            if (!m.isAbstract() && !m.isNative()) {
                List exceptionList = m.getExceptions();
                IterableSet exceptionSet = new IterableSet(exceptionList);
                boolean changed = false;
                for (Unit u : m.retrieveActiveBody().getUnits()) {
                    SootClass c;
                    Type t;
                    HashSet handled = (HashSet)this.protectionSet.get(u);
                    if (!(u instanceof ThrowStmt) || !((t = ((ThrowStmt)u).getOp().getType()) instanceof RefType) || this.handled_Exception(handled, c = ((RefType)t).getSootClass()) || exceptionSet.contains(c)) continue;
                    exceptionSet.add(c);
                    changed = true;
                }
                Iterator it = cg.edgesOutOf(m);
                while (it.hasNext()) {
                    Edge e = (Edge)it.next();
                    Stmt callSite = e.srcStmt();
                    if (callSite == null) continue;
                    HashSet handled = (HashSet)this.protectionSet.get(callSite);
                    SootMethod target = e.tgt();
                    for (SootClass exception : target.getExceptions()) {
                        if (this.handled_Exception(handled, exception) || exceptionSet.contains(exception)) continue;
                        exceptionSet.add(exception);
                        changed = true;
                    }
                }
                if (changed) {
                    exceptionList.clear();
                    exceptionList.addAll(exceptionSet);
                }
            }
            this.find_OtherMethods(m, agreementMethodSet, subClassSet, applicationClasses);
            this.find_OtherMethods(m, agreementMethodSet, superClassSet, applicationClasses);
        }
        while (!worklist.isEmpty()) {
            SootMethod m;
            m = (SootMethod)worklist.getFirst();
            worklist.removeFirst();
            IterableSet agreementMethods = (IterableSet)agreementMethodSet.get(m);
            if (agreementMethods != null) {
                for (SootMethod otherMethod : agreementMethods) {
                    List otherExceptionsList = otherMethod.getExceptions();
                    IterableSet otherExceptionSet = new IterableSet(otherExceptionsList);
                    boolean changed = false;
                    for (SootClass exception : m.getExceptions()) {
                        if (otherExceptionSet.contains(exception)) continue;
                        otherExceptionSet.add(exception);
                        changed = true;
                    }
                    if (!changed) continue;
                    otherExceptionsList.clear();
                    otherExceptionsList.addAll(otherExceptionSet);
                    if (worklist.contains(otherMethod)) continue;
                    worklist.addLast(otherMethod);
                }
            }
            Iterator it = cg.edgesOutOf(m);
            while (it.hasNext()) {
                Edge e = (Edge)it.next();
                Stmt callingSite = e.srcStmt();
                if (callingSite == null) continue;
                SootMethod callingMethod = e.src();
                List exceptionList = callingMethod.getExceptions();
                IterableSet exceptionSet = new IterableSet(exceptionList);
                HashSet handled = (HashSet)this.protectionSet.get(callingSite);
                boolean changed = false;
                for (SootClass exception : m.getExceptions()) {
                    if (this.handled_Exception(handled, exception) || exceptionSet.contains(exception)) continue;
                    exceptionSet.add(exception);
                    changed = true;
                }
                if (!changed) continue;
                exceptionList.clear();
                exceptionList.addAll(exceptionSet);
                if (worklist.contains(callingMethod)) continue;
                worklist.addLast(callingMethod);
            }
        }
        G.v().out.println();
        G.v().out.flush();
    }

    private void find_OtherMethods(SootMethod startingMethod, HashMap methodMapping, HashMap classMapping, HashSet applicationClasses) {
        IterableSet worklist = (IterableSet)((IterableSet)classMapping.get(startingMethod.getDeclaringClass())).clone();
        HashSet<SootClass> touchSet = new HashSet<SootClass>();
        touchSet.addAll(worklist);
        String signature = startingMethod.getSubSignature();
        while (!worklist.isEmpty()) {
            SootClass currentClass = (SootClass)worklist.getFirst();
            worklist.removeFirst();
            if (!applicationClasses.contains(currentClass)) continue;
            if (currentClass.declaresMethod(signature)) {
                IterableSet otherMethods = (IterableSet)methodMapping.get(startingMethod);
                if (otherMethods == null) {
                    otherMethods = new IterableSet();
                    methodMapping.put(startingMethod, otherMethods);
                }
                otherMethods.add(currentClass.getMethod(signature));
                continue;
            }
            IterableSet otherClasses = (IterableSet)classMapping.get(currentClass);
            if (otherClasses == null) continue;
            for (SootClass otherClass : otherClasses) {
                if (touchSet.contains(otherClass)) continue;
                worklist.addLast(otherClass);
                touchSet.add(otherClass);
            }
        }
    }

    private void register_AreasOfProtection(SootMethod m) {
        if (this.registeredMethods.contains(m)) {
            return;
        }
        this.registeredMethods.add(m);
        if (!m.hasActiveBody()) {
            return;
        }
        Body b = m.getActiveBody();
        PatchingChain stmts = b.getUnits();
        for (Trap t : b.getTraps()) {
            SootClass exception = t.getException();
            Iterator sit = stmts.iterator(t.getBeginUnit(), stmts.getPredOf(t.getEndUnit()));
            while (sit.hasNext()) {
                Stmt s = (Stmt)sit.next();
                HashSet<SootClass> handled = null;
                handled = (HashSet<SootClass>)this.protectionSet.get(s);
                if (handled == null) {
                    handled = new HashSet<SootClass>();
                    this.protectionSet.put(s, handled);
                }
                if (handled.contains(exception)) continue;
                handled.add(exception);
            }
        }
    }

    private boolean handled_Exception(HashSet handledExceptions, SootClass c) {
        SootClass thrownException = c;
        if (this.is_HandledByRuntime(thrownException)) {
            return true;
        }
        if (handledExceptions == null) {
            return false;
        }
        while (!handledExceptions.contains(thrownException)) {
            if (!thrownException.hasSuperclass()) {
                return false;
            }
            thrownException = thrownException.getSuperclass();
        }
        return true;
    }

    private boolean is_HandledByRuntime(SootClass c) {
        SootClass thrownException = c;
        SootClass runtimeException = Scene.v().getSootClass("java.lang.RuntimeException");
        SootClass error = Scene.v().getSootClass("java.lang.Error");
        while (thrownException != runtimeException && thrownException != error) {
            if (!thrownException.hasSuperclass()) {
                return false;
            }
            thrownException = thrownException.getSuperclass();
        }
        return true;
    }
}

