/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.finders;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.G;
import soot.RefType;
import soot.Singletons;
import soot.Value;
import soot.dava.Dava;
import soot.dava.DavaBody;
import soot.dava.RetriggerAnalysisException;
import soot.dava.internal.SET.SETNode;
import soot.dava.internal.SET.SETSynchronizedBlockNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.internal.asg.AugmentedStmtGraph;
import soot.dava.toolkits.base.finders.ExceptionNode;
import soot.dava.toolkits.base.finders.FactFinder;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.GotoStmt;
import soot.jimple.MonitorStmt;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.toolkits.graph.StronglyConnectedComponents;
import soot.util.IterableSet;

public class SynchronizedBlockFinder
implements FactFinder {
    private HashMap as2ml;
    private IterableSet monitorLocalSet;
    private IterableSet monitorEnterSet;
    private Integer WHITE = new Integer(0);
    private Integer GRAY = new Integer(1);
    private Integer BLACK = new Integer(2);
    private int UNKNOWN = -100000;
    private Integer VARIABLE_INCR = new Integer(this.UNKNOWN);
    private String THROWABLE = "java.lang.Throwable";

    public SynchronizedBlockFinder(Singletons.Global g) {
    }

    public static SynchronizedBlockFinder v() {
        return G.v().SynchronizedBlockFinder();
    }

    public void find(DavaBody body, AugmentedStmtGraph asg, SETNode SET) throws RetriggerAnalysisException {
        Dava.v().log("SynchronizedBlockFinder::find()");
        this.as2ml = new HashMap();
        IterableSet synchronizedBlockFacts = body.get_SynchronizedBlockFacts();
        synchronizedBlockFacts.clear();
        this.set_MonitorLevels(asg);
        Map as2synchSet = this.build_SynchSets();
        IterableSet usedMonitors = new IterableSet();
        Iterator asgit = asg.iterator();
        block0: while (asgit.hasNext()) {
            IterableSet synchSet;
            AugmentedStmt as = (AugmentedStmt)asgit.next();
            if (!(as.get_Stmt() instanceof EnterMonitorStmt) || (synchSet = (IterableSet)as2synchSet.get(as)) == null) continue;
            IterableSet synchBody = this.get_BodyApproximation(as, synchSet);
            Value local = ((EnterMonitorStmt)as.get_Stmt()).getOp();
            Integer level = (Integer)((HashMap)this.as2ml.get(as)).get(local);
            for (ExceptionNode en : body.get_ExceptionFacts()) {
                if (!this.verify_CatchBody(en, synchBody, local)) continue;
                if (!SET.nest(new SETSynchronizedBlockNode(en, local))) continue block0;
                for (AugmentedStmt ssas : synchSet) {
                    Stmt sss = ssas.get_Stmt();
                    if (!(sss instanceof MonitorStmt) || ((MonitorStmt)sss).getOp() != local || !((Integer)((HashMap)this.as2ml.get(ssas)).get(local)).equals(level) || usedMonitors.contains(ssas)) continue;
                    usedMonitors.add(ssas);
                }
                synchronizedBlockFacts.add(en);
                continue block0;
            }
        }
        IterableSet monitorFacts = body.get_MonitorFacts();
        monitorFacts.clear();
        asgit = asg.iterator();
        while (asgit.hasNext()) {
            AugmentedStmt as = (AugmentedStmt)asgit.next();
            if (!(as.get_Stmt() instanceof MonitorStmt) || usedMonitors.contains(as)) continue;
            monitorFacts.add(as);
        }
    }

    private void find_VariableIncreasing(AugmentedStmtGraph asg, HashMap local2level_template, LinkedList viAugStmts, HashMap as2locals) {
        HashMap local2level;
        AugmentedStmt as;
        StronglyConnectedComponents scc = new StronglyConnectedComponents(asg);
        IterableSet viSeeds = new IterableSet();
        HashMap as2color = new HashMap();
        HashMap as2rml = new HashMap();
        Iterator asgit = asg.iterator();
        while (asgit.hasNext()) {
            as2rml.put(asgit.next(), local2level_template.clone());
        }
        for (List componentList : scc.getComponents()) {
            if (componentList.size() < 2) continue;
            IterableSet component = new IterableSet();
            component.addAll(componentList);
            Iterator cit = component.iterator();
            while (cit.hasNext()) {
                as2color.put(cit.next(), this.WHITE);
            }
            AugmentedStmt seedStmt = (AugmentedStmt)component.getFirst();
            this.DFS_Scc(seedStmt, component, as2rml, as2color, seedStmt, viSeeds);
        }
        IterableSet worklist = new IterableSet();
        worklist.addAll(viSeeds);
        while (!worklist.isEmpty()) {
            as = (AugmentedStmt)worklist.getFirst();
            worklist.removeFirst();
            local2level = (HashMap)as2rml.get(as);
            for (AugmentedStmt sas : as.csuccs) {
                HashMap slocal2level = (HashMap)as2rml.get(sas);
                for (Value local : this.monitorLocalSet) {
                    if (local2level.get(local) != this.VARIABLE_INCR || slocal2level.get(local) == this.VARIABLE_INCR) continue;
                    slocal2level.put(local, this.VARIABLE_INCR);
                    if (worklist.contains(sas)) continue;
                    worklist.addLast(sas);
                }
            }
        }
        asgit = asg.iterator();
        while (asgit.hasNext()) {
            as = (AugmentedStmt)asgit.next();
            local2level = (HashMap)as2rml.get(as);
            for (Value local : this.monitorLocalSet) {
                if (local2level.get(local) != this.VARIABLE_INCR) continue;
                if (viAugStmts.getLast() != as) {
                    viAugStmts.addLast(as);
                }
                LinkedList<Value> locals = null;
                locals = (LinkedList<Value>)as2locals.get(as);
                if (locals == null) {
                    locals = new LinkedList<Value>();
                    as2locals.put(as, locals);
                }
                locals.addLast(local);
            }
        }
    }

    private void DFS_Scc(AugmentedStmt as, IterableSet component, HashMap as2rml, HashMap as2color, AugmentedStmt seedStmt, IterableSet viSeeds) {
        as2color.put(as, this.GRAY);
        Stmt s = as.get_Stmt();
        HashMap local2level = (HashMap)as2rml.get(as);
        if (s instanceof MonitorStmt) {
            Value local = ((MonitorStmt)s).getOp();
            if (s instanceof EnterMonitorStmt) {
                local2level.put(local, new Integer((Integer)local2level.get(local) + 1));
            } else {
                local2level.put(local, new Integer((Integer)local2level.get(local) - 1));
            }
        }
        for (AugmentedStmt sas : as.csuccs) {
            if (!component.contains(sas)) continue;
            HashMap slocal2level = (HashMap)as2rml.get(sas);
            Integer scolor = (Integer)as2color.get(sas);
            if (scolor.equals(this.WHITE)) {
                for (Value local : this.monitorLocalSet) {
                    slocal2level.put(local, local2level.get(local));
                }
                this.DFS_Scc(sas, component, as2rml, as2color, seedStmt, viSeeds);
                continue;
            }
            for (Value local : this.monitorLocalSet) {
                if ((Integer)slocal2level.get(local) >= (Integer)local2level.get(local)) continue;
                slocal2level.put(local, this.VARIABLE_INCR);
                if (viSeeds.contains(sas)) continue;
                viSeeds.add(sas);
            }
        }
        as2color.put(as, this.BLACK);
    }

    private Map build_SynchSets() {
        HashMap<AugmentedStmt, IterableSet> as2synchSet = new HashMap<AugmentedStmt, IterableSet>();
        block0: for (AugmentedStmt headAs : this.monitorEnterSet) {
            Value local = ((EnterMonitorStmt)headAs.get_Stmt()).getOp();
            IterableSet synchSet = new IterableSet();
            int monitorLevel = (Integer)((HashMap)this.as2ml.get(headAs)).get(local);
            IterableSet worklist = new IterableSet();
            worklist.add(headAs);
            while (!worklist.isEmpty()) {
                AugmentedStmt as = (AugmentedStmt)worklist.getFirst();
                worklist.removeFirst();
                Stmt s = as.get_Stmt();
                if (s instanceof DefinitionStmt && ((DefinitionStmt)s).getLeftOp() == local) continue block0;
                synchSet.add(as);
                for (AugmentedStmt sas : as.csuccs) {
                    int sml = (Integer)((HashMap)this.as2ml.get(sas)).get(local);
                    if (!sas.get_Dominators().contains(headAs) || sml < monitorLevel || worklist.contains(sas) || synchSet.contains(sas)) continue;
                    worklist.addLast(sas);
                }
            }
            as2synchSet.put(headAs, synchSet);
        }
        return as2synchSet;
    }

    private void set_MonitorLevels(AugmentedStmtGraph asg) {
        this.monitorLocalSet = new IterableSet();
        this.monitorEnterSet = new IterableSet();
        Iterator asgit = asg.iterator();
        while (asgit.hasNext()) {
            AugmentedStmt as = (AugmentedStmt)asgit.next();
            Stmt s = as.get_Stmt();
            if (!(s instanceof MonitorStmt)) continue;
            Value local = ((MonitorStmt)s).getOp();
            if (!this.monitorLocalSet.contains(local)) {
                this.monitorLocalSet.add(local);
            }
            if (!(s instanceof EnterMonitorStmt)) continue;
            this.monitorEnterSet.add(as);
        }
        HashMap local2level_template = new HashMap();
        Iterator mlsit = this.monitorLocalSet.iterator();
        while (mlsit.hasNext()) {
            local2level_template.put(mlsit.next(), new Integer(0));
        }
        asgit = asg.iterator();
        while (asgit.hasNext()) {
            this.as2ml.put(asgit.next(), local2level_template.clone());
        }
        LinkedList viAugStmts = new LinkedList();
        HashMap incrAs2locals = new HashMap();
        this.find_VariableIncreasing(asg, local2level_template, viAugStmts, incrAs2locals);
        for (AugmentedStmt vias : viAugStmts) {
            HashMap local2level = (HashMap)this.as2ml.get(vias);
            Iterator lit = ((LinkedList)incrAs2locals.get(vias)).iterator();
            while (lit.hasNext()) {
                local2level.put(lit.next(), this.VARIABLE_INCR);
            }
        }
        IterableSet worklist = new IterableSet();
        worklist.addAll(this.monitorEnterSet);
        while (!worklist.isEmpty()) {
            AugmentedStmt as = (AugmentedStmt)worklist.getFirst();
            worklist.removeFirst();
            HashMap cur_local2level = (HashMap)this.as2ml.get(as);
            for (AugmentedStmt pas : as.cpreds) {
                Stmt s = as.get_Stmt();
                HashMap pred_local2level = (HashMap)this.as2ml.get(pas);
                for (Value local : this.monitorLocalSet) {
                    int curLevel;
                    MonitorStmt ems;
                    int predLevel = (Integer)pred_local2level.get(local);
                    Stmt ps = pas.get_Stmt();
                    if (predLevel == this.UNKNOWN) continue;
                    if (ps instanceof ExitMonitorStmt && (ems = (ExitMonitorStmt)ps).getOp() == local && predLevel > 0) {
                        --predLevel;
                    }
                    if (s instanceof EnterMonitorStmt && (ems = (EnterMonitorStmt)s).getOp() == local && predLevel >= 0) {
                        ++predLevel;
                    }
                    if (predLevel <= (curLevel = ((Integer)cur_local2level.get(local)).intValue())) continue;
                    cur_local2level.put(local, new Integer(predLevel));
                    for (Object so : as.csuccs) {
                        if (worklist.contains(so)) continue;
                        worklist.add(so);
                    }
                }
            }
        }
    }

    private boolean verify_CatchBody(ExceptionNode en, IterableSet synchBody, Value monitorVariable) {
        AugmentedStmt as2;
        if (!en.get_Body().equals(synchBody) || !en.get_Exception().getName().equals(this.THROWABLE) || en.get_CatchList().size() > 1) {
            return false;
        }
        IterableSet catchBody = en.get_CatchBody();
        AugmentedStmt entryPoint = null;
        block0: for (AugmentedStmt as2 : catchBody) {
            for (AugmentedStmt pas : as2.cpreds) {
                if (catchBody.contains(pas)) continue;
                entryPoint = as2;
                break block0;
            }
        }
        as2 = entryPoint;
        if (as2.bsuccs.size() != 1) {
            return false;
        }
        while (as2.get_Stmt() instanceof GotoStmt) {
            as2 = (AugmentedStmt)as2.bsuccs.get(0);
            if (as2.bsuccs.size() == 1 && (as2 == entryPoint || as2.cpreds.size() == 1)) continue;
            return false;
        }
        Stmt s = as2.get_Stmt();
        if (!(s instanceof DefinitionStmt)) {
            return false;
        }
        DefinitionStmt ds = (DefinitionStmt)s;
        Value asnFrom = ds.getRightOp();
        if (!(asnFrom instanceof CaughtExceptionRef) || !((RefType)((CaughtExceptionRef)asnFrom).getType()).getSootClass().getName().equals(this.THROWABLE)) {
            return false;
        }
        Value throwlocal = ds.getLeftOp();
        IterableSet esuccs = new IterableSet();
        esuccs.addAll(as2.csuccs);
        esuccs.removeAll(as2.bsuccs);
        as2 = (AugmentedStmt)as2.bsuccs.get(0);
        if (as2.bsuccs.size() != 1 || as2.cpreds.size() != 1 || !this.verify_ESuccs(as2, esuccs)) {
            return false;
        }
        s = as2.get_Stmt();
        if (!(s instanceof ExitMonitorStmt) || ((ExitMonitorStmt)s).getOp() != monitorVariable) {
            return false;
        }
        as2 = (AugmentedStmt)as2.bsuccs.get(0);
        if (as2.bsuccs.size() != 0 || as2.cpreds.size() != 1 || !this.verify_ESuccs(as2, esuccs)) {
            return false;
        }
        s = as2.get_Stmt();
        return s instanceof ThrowStmt && ((ThrowStmt)s).getOp() == throwlocal;
    }

    private boolean verify_ESuccs(AugmentedStmt as, IterableSet ref) {
        IterableSet esuccs = new IterableSet();
        esuccs.addAll(as.csuccs);
        esuccs.removeAll(as.bsuccs);
        return esuccs.equals(ref);
    }

    private IterableSet get_BodyApproximation(AugmentedStmt head, IterableSet synchSet) {
        IterableSet body = (IterableSet)synchSet.clone();
        Value local = ((EnterMonitorStmt)head.get_Stmt()).getOp();
        Integer level = (Integer)((HashMap)this.as2ml.get(head)).get(local);
        body.remove(head);
        Iterator bit = body.snapshotIterator();
        while (bit.hasNext()) {
            AugmentedStmt as = (AugmentedStmt)bit.next();
            Stmt s = as.get_Stmt();
            if (!(s instanceof ExitMonitorStmt) || ((ExitMonitorStmt)s).getOp() != local || !((Integer)((HashMap)this.as2ml.get(as)).get(local)).equals(level)) continue;
            for (AugmentedStmt sas : as.csuccs) {
                Stmt ss;
                if (!sas.get_Dominators().contains(head) || !((ss = sas.get_Stmt()) instanceof GotoStmt) && !(ss instanceof ThrowStmt) || body.contains(sas)) continue;
                body.add(sas);
            }
        }
        return body;
    }
}

