/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.finders;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import soot.dava.toolkits.base.finders.SwitchNode;
import soot.toolkits.graph.DirectedGraph;

class SwitchNodeGraph
implements DirectedGraph {
    private LinkedList body = new LinkedList();
    private LinkedList heads;
    private LinkedList tails;
    private HashMap binding;

    public SwitchNodeGraph(List body) {
        this.body.addAll(body);
        this.binding = new HashMap();
        this.heads = new LinkedList();
        this.tails = new LinkedList();
        for (SwitchNode sn : body) {
            this.binding.put(sn.get_AugStmt().bsuccs.get(0), sn);
            sn.reset();
        }
        Iterator it = body.iterator();
        while (it.hasNext()) {
            ((SwitchNode)it.next()).setup_Graph(this.binding);
        }
        for (SwitchNode sn : body) {
            if (sn.get_Preds().isEmpty()) {
                this.heads.add(sn);
            }
            if (!sn.get_Succs().isEmpty()) continue;
            this.tails.add(sn);
        }
    }

    public int size() {
        return this.body.size();
    }

    public List getHeads() {
        return this.heads;
    }

    public List getTails() {
        return this.tails;
    }

    public List getPredsOf(Object o) {
        return ((SwitchNode)o).get_Preds();
    }

    public List getSuccsOf(Object o) {
        return ((SwitchNode)o).get_Succs();
    }

    public Iterator iterator() {
        return this.body.iterator();
    }

    public List getBody() {
        return this.body;
    }
}

