/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.finders;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.G;
import soot.SootClass;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.internal.asg.AugmentedStmtGraph;
import soot.dava.toolkits.base.finders.ExceptionFinder;
import soot.util.IterableSet;

public class ExceptionNode {
    private IterableSet body;
    private IterableSet tryBody;
    private IterableSet catchBody;
    private boolean dirty;
    private LinkedList exitList;
    private LinkedList catchList;
    private SootClass exception;
    private HashMap catch2except;
    private AugmentedStmt handlerAugmentedStmt;

    public ExceptionNode(IterableSet tryBody, SootClass exception, AugmentedStmt handlerAugmentedStmt) {
        this.tryBody = tryBody;
        this.catchBody = null;
        this.exception = exception;
        this.handlerAugmentedStmt = handlerAugmentedStmt;
        this.body = new IterableSet();
        this.body.addAll(tryBody);
        this.dirty = true;
        this.exitList = null;
        this.catchList = null;
        this.catch2except = null;
    }

    public boolean add_TryStmts(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (this.add_TryStmt((AugmentedStmt)it.next())) continue;
            return false;
        }
        return true;
    }

    public boolean add_TryStmt(AugmentedStmt as) {
        if (this.body.contains(as) || this.tryBody.contains(as)) {
            return false;
        }
        this.body.add(as);
        this.tryBody.add(as);
        return true;
    }

    public void refresh_CatchBody(ExceptionFinder ef) {
        if (this.catchBody != null) {
            this.body.removeAll(this.catchBody);
        }
        this.catchBody = ef.get_CatchBody(this.handlerAugmentedStmt);
        this.body.addAll(this.catchBody);
    }

    public IterableSet get_Body() {
        return this.body;
    }

    public IterableSet get_TryBody() {
        return this.tryBody;
    }

    public IterableSet get_CatchBody() {
        return this.catchBody;
    }

    public boolean remove(AugmentedStmt as) {
        if (!this.body.contains(as)) {
            return false;
        }
        if (this.tryBody.contains(as)) {
            this.tryBody.remove(as);
        } else if (this.catchBody != null && this.catchBody.contains(as)) {
            this.catchBody.remove(as);
            this.dirty = true;
        } else {
            return false;
        }
        this.body.remove(as);
        return true;
    }

    public List get_CatchExits() {
        if (this.catchBody == null) {
            return null;
        }
        if (this.dirty) {
            this.exitList = new LinkedList();
            this.dirty = false;
            block0: for (AugmentedStmt as : this.catchBody) {
                Iterator sit = as.bsuccs.iterator();
                while (sit.hasNext()) {
                    if (this.catchBody.contains(sit.next())) continue;
                    this.exitList.add(as);
                    continue block0;
                }
            }
        }
        return this.exitList;
    }

    public void splitOff_ExceptionNode(IterableSet newTryBody, AugmentedStmtGraph asg, IterableSet enlist) {
        IterableSet oldTryBody = new IterableSet();
        oldTryBody.addAll(this.tryBody);
        IterableSet oldBody = new IterableSet();
        oldBody.addAll(this.body);
        Iterator it = newTryBody.iterator();
        while (it.hasNext()) {
            AugmentedStmt as = (AugmentedStmt)it.next();
            if (this.remove(as)) continue;
            StringBuffer b = new StringBuffer();
            it = newTryBody.iterator();
            while (it.hasNext()) {
                b.append("\n" + ((AugmentedStmt)it.next()).toString());
            }
            b.append("\n-");
            it = oldTryBody.iterator();
            while (it.hasNext()) {
                b.append("\n" + ((AugmentedStmt)it.next()).toString());
            }
            b.append("\n-");
            it = oldBody.iterator();
            while (it.hasNext()) {
                b.append("\n" + ((AugmentedStmt)it.next()).toString());
            }
            b.append("\n-");
            throw new RuntimeException("Tried to split off a new try body that isn't in the old one.\n" + as + "\n - " + b.toString());
        }
        asg.clone_Body(this.catchBody);
        AugmentedStmt oldCatchTarget = this.handlerAugmentedStmt;
        AugmentedStmt newCatchTarget = asg.get_CloneOf(this.handlerAugmentedStmt);
        for (AugmentedStmt as : newTryBody) {
            as.remove_CSucc(oldCatchTarget);
            oldCatchTarget.remove_CPred(as);
        }
        for (AugmentedStmt as : this.tryBody) {
            as.remove_CSucc(newCatchTarget);
            newCatchTarget.remove_CPred(as);
        }
        Iterator enlit = enlist.snapshotIterator();
        while (enlit.hasNext()) {
            ExceptionNode en = (ExceptionNode)enlit.next();
            if (this == en || !this.catchBody.isSupersetOf(en.get_Body())) continue;
            IterableSet clonedTryBody = new IterableSet();
            Iterator trit = en.get_TryBody().iterator();
            while (trit.hasNext()) {
                clonedTryBody.add(asg.get_CloneOf((AugmentedStmt)trit.next()));
            }
            enlist.addLast(new ExceptionNode(clonedTryBody, en.exception, asg.get_CloneOf(en.handlerAugmentedStmt)));
        }
        enlist.addLast(new ExceptionNode(newTryBody, this.exception, asg.get_CloneOf(this.handlerAugmentedStmt)));
        enlit = enlist.iterator();
        while (enlit.hasNext()) {
            ((ExceptionNode)enlit.next()).refresh_CatchBody(ExceptionFinder.v());
        }
        asg.find_Dominators();
    }

    public void add_CatchBody(ExceptionNode other) {
        if (other.get_CatchList() == null) {
            this.add_CatchBody(other.get_CatchBody(), other.get_Exception());
            return;
        }
        for (IterableSet c : other.get_CatchList()) {
            this.add_CatchBody(c, other.get_Exception(c));
        }
    }

    public void add_CatchBody(IterableSet newCatchBody, SootClass except) {
        if (this.catchList == null) {
            this.catchList = new LinkedList();
            this.catchList.addLast(this.catchBody);
            this.catch2except = new HashMap();
            this.catch2except.put(this.catchBody, this.exception);
        }
        this.body.addAll(newCatchBody);
        this.catchList.addLast(newCatchBody);
        this.catch2except.put(newCatchBody, except);
    }

    public List get_CatchList() {
        LinkedList<IterableSet> l = this.catchList;
        if (l == null) {
            l = new LinkedList<IterableSet>();
            l.add(this.catchBody);
        }
        return l;
    }

    public Map get_ExceptionMap() {
        HashMap<IterableSet, SootClass> m = this.catch2except;
        if (m == null) {
            m = new HashMap<IterableSet, SootClass>();
            m.put(this.catchBody, this.exception);
        }
        return m;
    }

    public SootClass get_Exception() {
        return this.exception;
    }

    public SootClass get_Exception(IterableSet catchBody) {
        if (this.catch2except == null) {
            return this.exception;
        }
        return (SootClass)this.catch2except.get(catchBody);
    }

    public void dump() {
        G.v().out.println("try {");
        Iterator tit = this.get_TryBody().iterator();
        while (tit.hasNext()) {
            G.v().out.println("\t" + tit.next());
        }
        G.v().out.println("}");
        for (IterableSet catchBody : this.get_CatchList()) {
            G.v().out.println("catch " + this.get_ExceptionMap().get(catchBody) + " {");
            Iterator cbit = catchBody.iterator();
            while (cbit.hasNext()) {
                G.v().out.println("\t" + cbit.next());
            }
            G.v().out.println("}");
        }
    }
}

