/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.finders;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import soot.G;
import soot.Local;
import soot.Singletons;
import soot.Value;
import soot.dava.Dava;
import soot.dava.DavaBody;
import soot.dava.RetriggerAnalysisException;
import soot.dava.internal.SET.SETCycleNode;
import soot.dava.internal.SET.SETDoWhileNode;
import soot.dava.internal.SET.SETNode;
import soot.dava.internal.SET.SETUnconditionalWhileNode;
import soot.dava.internal.SET.SETWhileNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.internal.asg.AugmentedStmtGraph;
import soot.dava.internal.javaRep.DIntConstant;
import soot.dava.toolkits.base.finders.ExceptionNode;
import soot.dava.toolkits.base.finders.FactFinder;
import soot.dava.toolkits.base.misc.ConditionFlipper;
import soot.grimp.internal.GAssignStmt;
import soot.grimp.internal.GTableSwitchStmt;
import soot.jimple.ConditionExpr;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.internal.JGotoStmt;
import soot.toolkits.graph.StronglyConnectedComponents;
import soot.util.IterableSet;

public class CycleFinder
implements FactFinder {
    public CycleFinder(Singletons.Global g) {
    }

    public static CycleFinder v() {
        return G.v().CycleFinder();
    }

    public void find(DavaBody body, AugmentedStmtGraph asg, SETNode SET) throws RetriggerAnalysisException {
        Dava.v().log("CycleFinder::find()");
        AugmentedStmtGraph wasg = (AugmentedStmtGraph)asg.clone();
        List component_list = this.build_component_list(wasg);
        while (!component_list.isEmpty()) {
            IterableSet node_list = new IterableSet();
            Iterator cit = component_list.iterator();
            while (cit.hasNext()) {
                node_list.clear();
                node_list.addAll((List)cit.next());
                IterableSet entry_points = this.get_EntryPoint(node_list);
                if (entry_points.size() > 1) {
                    LinkedList<AugmentedStmt> asgEntryPoints = new LinkedList<AugmentedStmt>();
                    Iterator it = entry_points.iterator();
                    while (it.hasNext()) {
                        asgEntryPoints.addLast(asg.get_AugStmt(((AugmentedStmt)it.next()).get_Stmt()));
                    }
                    IterableSet asgScc = new IterableSet();
                    it = node_list.iterator();
                    while (it.hasNext()) {
                        asgScc.addLast(asg.get_AugStmt(((AugmentedStmt)it.next()).get_Stmt()));
                    }
                    this.fix_MultiEntryPoint(body, asg, asgEntryPoints, asgScc);
                    throw new RetriggerAnalysisException();
                }
                AugmentedStmt entry_point = (AugmentedStmt)entry_points.getFirst();
                AugmentedStmt characterizing_stmt = this.find_CharacterizingStmt(entry_point, node_list, wasg);
                AugmentedStmt succ_stmt = null;
                if (characterizing_stmt != null) {
                    Iterator sit = characterizing_stmt.bsuccs.iterator();
                    while (sit.hasNext() && node_list.contains(succ_stmt = (AugmentedStmt)sit.next())) {
                    }
                }
                wasg.calculate_Reachability(succ_stmt, new HashSet(), entry_point);
                IterableSet cycle_body = this.get_CycleBody(entry_point, succ_stmt, asg, wasg);
                SETCycleNode newNode = null;
                if (characterizing_stmt != null) {
                    block5: for (ExceptionNode en : body.get_ExceptionFacts()) {
                        IterableSet tryBody = en.get_TryBody();
                        if (!tryBody.contains(asg.get_AugStmt(characterizing_stmt.get_Stmt()))) continue;
                        for (AugmentedStmt cbas : cycle_body) {
                            if (tryBody.contains(cbas)) continue;
                            characterizing_stmt = null;
                            break block5;
                        }
                    }
                }
                if (characterizing_stmt == null) {
                    wasg.remove_AugmentedStmt(entry_point);
                    newNode = new SETUnconditionalWhileNode(cycle_body);
                } else {
                    body.consume_Condition(asg.get_AugStmt(characterizing_stmt.get_Stmt()));
                    wasg.remove_AugmentedStmt(characterizing_stmt);
                    IfStmt condition = (IfStmt)characterizing_stmt.get_Stmt();
                    if (!cycle_body.contains(asg.get_AugStmt(condition.getTarget()))) {
                        condition.setCondition(ConditionFlipper.flip((ConditionExpr)condition.getCondition()));
                    }
                    newNode = characterizing_stmt == entry_point ? new SETWhileNode(asg.get_AugStmt(characterizing_stmt.get_Stmt()), cycle_body) : new SETDoWhileNode(asg.get_AugStmt(characterizing_stmt.get_Stmt()), asg.get_AugStmt(entry_point.get_Stmt()), cycle_body);
                }
                if (newNode == null) continue;
                SET.nest(newNode);
            }
            component_list = this.build_component_list(wasg);
        }
    }

    private IterableSet get_EntryPoint(IterableSet nodeList) {
        IterableSet entryPoints = new IterableSet();
        block0: for (AugmentedStmt as : nodeList) {
            for (Object po : as.cpreds) {
                if (nodeList.contains(po)) continue;
                entryPoints.add(as);
                continue block0;
            }
        }
        return entryPoints;
    }

    private List build_component_list(AugmentedStmtGraph asg) {
        LinkedList<List> c_list = new LinkedList<List>();
        StronglyConnectedComponents scc = new StronglyConnectedComponents(asg);
        for (List wcomp : scc.getComponents()) {
            if (wcomp.size() <= 1) continue;
            c_list.add(wcomp);
        }
        return c_list;
    }

    private AugmentedStmt find_CharacterizingStmt(AugmentedStmt entry_point, IterableSet sc_component, AugmentedStmtGraph asg) {
        if (entry_point.get_Stmt() instanceof IfStmt) {
            Iterator sit = entry_point.bsuccs.iterator();
            while (sit.hasNext()) {
                if (sc_component.contains(sit.next())) continue;
                return entry_point;
            }
        }
        IterableSet candidates = new IterableSet();
        HashMap<AugmentedStmt, AugmentedStmt> candSuccMap = new HashMap<AugmentedStmt, AugmentedStmt>();
        HashSet<AugmentedStmt> blockers = new HashSet<AugmentedStmt>();
        block1: for (AugmentedStmt pas : entry_point.bpreds) {
            if (pas.get_Stmt() instanceof GotoStmt && pas.bpreds.size() == 1) {
                pas = (AugmentedStmt)pas.bpreds.get(0);
            }
            if (!sc_component.contains(pas) || !(pas.get_Stmt() instanceof IfStmt)) continue;
            for (AugmentedStmt spas : pas.bsuccs) {
                if (sc_component.contains(spas)) continue;
                candidates.add(pas);
                candSuccMap.put(pas, spas);
                blockers.add(spas);
                continue block1;
            }
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return (AugmentedStmt)candidates.getFirst();
        }
        asg.calculate_Reachability((Collection)candidates, blockers, entry_point);
        IterableSet max_Reach_Set = null;
        int reachSize = 0;
        for (AugmentedStmt as : candidates) {
            int current_reach_size = ((AugmentedStmt)candSuccMap.get(as)).get_Reachers().intersection(candidates).size();
            if (current_reach_size > reachSize) {
                max_Reach_Set = new IterableSet();
                reachSize = current_reach_size;
            }
            if (current_reach_size != reachSize) continue;
            max_Reach_Set.add(as);
        }
        candidates = max_Reach_Set;
        if (candidates.size() == 1) {
            return (AugmentedStmt)candidates.getFirst();
        }
        HashSet<AugmentedStmt> touchSet = new HashSet<AugmentedStmt>();
        LinkedList<AugmentedStmt> worklist = new LinkedList<AugmentedStmt>();
        worklist.addLast(entry_point);
        touchSet.add(entry_point);
        while (!worklist.isEmpty()) {
            for (Object so : ((AugmentedStmt)worklist.removeFirst()).csuccs) {
                if (candidates.contains(so)) {
                    return (AugmentedStmt)so;
                }
                if (!sc_component.contains(so) || touchSet.contains(so)) continue;
                worklist.addLast((AugmentedStmt)so);
                touchSet.add((AugmentedStmt)so);
            }
        }
        throw new RuntimeException("Somehow didn't find a condition for a do-while loop!");
    }

    private IterableSet get_CycleBody(AugmentedStmt entry_point, AugmentedStmt boundary_stmt, AugmentedStmtGraph asg, AugmentedStmtGraph wasg) {
        IterableSet cycle_body = new IterableSet();
        LinkedList<AugmentedStmt> worklist = new LinkedList<AugmentedStmt>();
        AugmentedStmt asg_ep = asg.get_AugStmt(entry_point.get_Stmt());
        worklist.add(entry_point);
        cycle_body.add(asg_ep);
        while (!worklist.isEmpty()) {
            AugmentedStmt as = (AugmentedStmt)worklist.removeFirst();
            for (AugmentedStmt wsas : as.csuccs) {
                AugmentedStmt sas = asg.get_AugStmt(wsas.get_Stmt());
                if (cycle_body.contains(sas) || cycle_body.contains(sas) || !sas.get_Dominators().contains(asg_ep) || boundary_stmt != null && (wsas.get_Reachers().contains(boundary_stmt) || wsas == boundary_stmt)) continue;
                worklist.add(wsas);
                cycle_body.add(sas);
            }
        }
        return cycle_body;
    }

    private void fix_MultiEntryPoint(DavaBody body, AugmentedStmtGraph asg, LinkedList entry_points, IterableSet scc) {
        AugmentedStmt naturalEntryPoint = this.get_NaturalEntryPoint(entry_points, scc);
        Local controlLocal = body.get_ControlLocal();
        Stmt defaultTarget = naturalEntryPoint.get_Stmt();
        LinkedList targets = new LinkedList();
        GTableSwitchStmt tss = new GTableSwitchStmt((Value)controlLocal, 0, entry_points.size() - 2, targets, defaultTarget);
        AugmentedStmt dispatchStmt = new AugmentedStmt(tss);
        IterableSet predecessorSet = new IterableSet();
        IterableSet indirectionStmtSet = new IterableSet();
        IterableSet directionStmtSet = new IterableSet();
        int count = 0;
        for (AugmentedStmt entryPoint : entry_points) {
            JGotoStmt gotoStmt = new JGotoStmt(entryPoint.get_Stmt());
            AugmentedStmt indirectionStmt = new AugmentedStmt(gotoStmt);
            indirectionStmtSet.add(indirectionStmt);
            tss.setTarget(count++, gotoStmt);
            dispatchStmt.add_BSucc(indirectionStmt);
            indirectionStmt.add_BPred(dispatchStmt);
            indirectionStmt.add_BSucc(entryPoint);
            entryPoint.add_BPred(indirectionStmt);
            asg.add_AugmentedStmt(indirectionStmt);
            LinkedList<AugmentedStmt> toRemove = new LinkedList<AugmentedStmt>();
            for (AugmentedStmt pas : entryPoint.cpreds) {
                if (pas == indirectionStmt || entryPoint != naturalEntryPoint && scc.contains(pas)) continue;
                if (!scc.contains(pas)) {
                    predecessorSet.add(pas);
                }
                GAssignStmt asnStmt = new GAssignStmt(controlLocal, DIntConstant.v(count, null));
                AugmentedStmt directionStmt = new AugmentedStmt(asnStmt);
                directionStmtSet.add(directionStmt);
                this.patch_Stmt(pas.get_Stmt(), entryPoint.get_Stmt(), asnStmt);
                toRemove.addLast(pas);
                pas.csuccs.remove(entryPoint);
                pas.csuccs.add(directionStmt);
                if (pas.bsuccs.contains(entryPoint)) {
                    pas.bsuccs.remove(entryPoint);
                    pas.bsuccs.add(directionStmt);
                }
                directionStmt.cpreds.add(pas);
                if (pas.bsuccs.contains(directionStmt)) {
                    directionStmt.bpreds.add(pas);
                }
                directionStmt.add_BSucc(dispatchStmt);
                dispatchStmt.add_BPred(directionStmt);
                asg.add_AugmentedStmt(directionStmt);
            }
            for (AugmentedStmt ras : toRemove) {
                entryPoint.cpreds.remove(ras);
                if (!entryPoint.bpreds.contains(ras)) continue;
                entryPoint.bpreds.remove(ras);
            }
        }
        asg.add_AugmentedStmt(dispatchStmt);
        block3: for (ExceptionNode en : body.get_ExceptionFacts()) {
            IterableSet tryBody = en.get_TryBody();
            Iterator epit = entry_points.iterator();
            while (epit.hasNext()) {
                if (tryBody.contains(epit.next())) continue;
                continue block3;
            }
            en.add_TryStmts(indirectionStmtSet);
            en.add_TryStmt(dispatchStmt);
            Iterator pit = predecessorSet.iterator();
            while (pit.hasNext()) {
                if (tryBody.contains(pit.next())) continue;
                continue block3;
            }
            en.add_TryStmts(directionStmtSet);
        }
    }

    private AugmentedStmt get_NaturalEntryPoint(LinkedList entry_points, IterableSet scc) {
        AugmentedStmt best_candidate = null;
        int minScore = 0;
        for (AugmentedStmt entryPoint : entry_points) {
            HashSet<AugmentedStmt> touchSet = new HashSet<AugmentedStmt>();
            HashSet backTargets = new HashSet();
            touchSet.add(entryPoint);
            this.DFS(entryPoint, touchSet, backTargets, scc);
            if (best_candidate != null && backTargets.size() >= minScore) continue;
            minScore = touchSet.size();
            best_candidate = entryPoint;
        }
        return best_candidate;
    }

    private void DFS(AugmentedStmt as, HashSet touchSet, HashSet backTargets, IterableSet scc) {
        for (AugmentedStmt sas : as.csuccs) {
            if (!scc.contains(sas)) continue;
            if (touchSet.contains(sas)) {
                if (backTargets.contains(sas)) continue;
                backTargets.add(sas);
                continue;
            }
            touchSet.add(sas);
            this.DFS(sas, touchSet, backTargets, scc);
            touchSet.remove(sas);
        }
    }

    private void patch_Stmt(Stmt src, Stmt oldDst, Stmt newDst) {
        int i;
        if (src instanceof GotoStmt) {
            ((GotoStmt)src).setTarget(newDst);
            return;
        }
        if (src instanceof IfStmt) {
            IfStmt ifs = (IfStmt)src;
            if (ifs.getTarget() == oldDst) {
                ifs.setTarget(newDst);
            }
            return;
        }
        if (src instanceof TableSwitchStmt) {
            TableSwitchStmt tss = (TableSwitchStmt)src;
            if (tss.getDefaultTarget() == oldDst) {
                tss.setDefaultTarget(newDst);
                return;
            }
            for (i = tss.getLowIndex(); i <= tss.getHighIndex(); ++i) {
                if (tss.getTarget(i) != oldDst) continue;
                tss.setTarget(i, newDst);
                return;
            }
        }
        if (src instanceof LookupSwitchStmt) {
            LookupSwitchStmt lss = (LookupSwitchStmt)src;
            if (lss.getDefaultTarget() == oldDst) {
                lss.setDefaultTarget(newDst);
                return;
            }
            for (i = 0; i < lss.getTargetCount(); ++i) {
                if (lss.getTarget(i) != oldDst) continue;
                lss.setTarget(i, newDst);
                return;
            }
        }
    }
}

