/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.internal.AST;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Local;
import soot.SootClass;
import soot.UnitPrinter;
import soot.dava.internal.AST.ASTLabeledNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.SET.SETNodeLabel;
import soot.dava.toolkits.base.AST.ASTAnalysis;
import soot.dava.toolkits.base.AST.TryContentsFinder;

public class ASTTryNode
extends ASTLabeledNode {
    private List tryBody;
    private List catchList;
    private Map exceptionMap;
    private Map paramMap;
    private container tryBodyContainer;

    public ASTTryNode(SETNodeLabel label, List tryBody, List catchList, Map exceptionMap, Map paramMap) {
        super(label);
        this.tryBody = tryBody;
        this.tryBodyContainer = new container(tryBody);
        this.catchList = new ArrayList();
        Iterator cit = catchList.iterator();
        while (cit.hasNext()) {
            this.catchList.add(new container(cit.next()));
        }
        this.exceptionMap = new HashMap();
        for (container c : this.catchList) {
            this.exceptionMap.put(c, exceptionMap.get(c.o));
        }
        this.paramMap = new HashMap();
        for (container c : this.catchList) {
            this.paramMap.put(c, paramMap.get(c.o));
        }
        this.subBodies.add(this.tryBodyContainer);
        cit = this.catchList.iterator();
        while (cit.hasNext()) {
            this.subBodies.add(cit.next());
        }
    }

    protected void perform_AnalysisOnSubBodies(ASTAnalysis a) {
        if (a instanceof TryContentsFinder) {
            TryContentsFinder tcf = (TryContentsFinder)a;
            for (container subBody : this.subBodies) {
                for (ASTNode n : (List)subBody.o) {
                    n.perform_Analysis(a);
                    tcf.v().add_ExceptionSet(subBody, tcf.v().get_ExceptionSet(n));
                }
            }
            a.analyseASTNode(this);
        } else {
            super.perform_AnalysisOnSubBodies(a);
        }
    }

    public boolean isEmpty() {
        return this.tryBody.isEmpty();
    }

    public List get_TryBody() {
        return this.tryBody;
    }

    public container get_TryBodyContainer() {
        return this.tryBodyContainer;
    }

    public List get_CatchList() {
        return this.catchList;
    }

    public Map get_ExceptionMap() {
        return this.exceptionMap;
    }

    public Set get_ExceptionSet() {
        HashSet s = new HashSet();
        Iterator it = this.catchList.iterator();
        while (it.hasNext()) {
            s.add(this.exceptionMap.get(it.next()));
        }
        return s;
    }

    public Object clone() {
        ArrayList<Object> newCatchList = new ArrayList<Object>();
        Iterator it = this.catchList.iterator();
        while (it.hasNext()) {
            newCatchList.add(((container)it.next()).o);
        }
        return new ASTTryNode(this.get_Label(), this.tryBody, newCatchList, this.exceptionMap, this.paramMap);
    }

    public void toString(UnitPrinter up) {
        this.label_toString(up);
        up.literal("try");
        up.newline();
        up.literal("{");
        up.newline();
        up.incIndent();
        this.body_toString(up, this.tryBody);
        up.decIndent();
        up.literal("}");
        up.newline();
        for (container catchBody : this.catchList) {
            up.literal("catch");
            up.literal(" ");
            up.literal("(");
            up.type(((SootClass)this.exceptionMap.get(catchBody)).getType());
            up.literal(" ");
            up.local((Local)this.paramMap.get(catchBody));
            up.literal(")");
            up.newline();
            up.literal("{");
            up.newline();
            up.incIndent();
            this.body_toString(up, (List)catchBody.o);
            up.decIndent();
            up.literal("}");
            up.newline();
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.label_toString());
        b.append("try");
        b.append("\n");
        b.append("{");
        b.append("\n");
        b.append(this.body_toString(this.tryBody));
        b.append("}");
        b.append("\n");
        for (container catchBody : this.catchList) {
            b.append("catch (");
            b.append(((SootClass)this.exceptionMap.get(catchBody)).getName());
            b.append(" ");
            b.append(((Local)this.paramMap.get(catchBody)).getName());
            b.append(")");
            b.append("\n");
            b.append("{");
            b.append("\n");
            b.append(this.body_toString((List)catchBody.o));
            b.append("}");
            b.append("\n");
        }
        return b.toString();
    }

    public class container {
        public Object o;

        public container(Object o) {
            this.o = o;
        }
    }
}

