/*
 * Decompiled with CFR 0.152.
 */
package soot.dava;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.PatchingChain;
import soot.RefType;
import soot.SootField;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.UnitBox;
import soot.Value;
import soot.ValueBox;
import soot.dava.Dava;
import soot.dava.RetriggerAnalysisException;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.SET.SETNode;
import soot.dava.internal.SET.SETTopNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.internal.asg.AugmentedStmtGraph;
import soot.dava.internal.javaRep.DCmpExpr;
import soot.dava.internal.javaRep.DCmpgExpr;
import soot.dava.internal.javaRep.DCmplExpr;
import soot.dava.internal.javaRep.DInstanceFieldRef;
import soot.dava.internal.javaRep.DIntConstant;
import soot.dava.internal.javaRep.DInterfaceInvokeExpr;
import soot.dava.internal.javaRep.DLengthExpr;
import soot.dava.internal.javaRep.DNegExpr;
import soot.dava.internal.javaRep.DNewArrayExpr;
import soot.dava.internal.javaRep.DNewInvokeExpr;
import soot.dava.internal.javaRep.DNewMultiArrayExpr;
import soot.dava.internal.javaRep.DSpecialInvokeExpr;
import soot.dava.internal.javaRep.DStaticFieldRef;
import soot.dava.internal.javaRep.DStaticInvokeExpr;
import soot.dava.internal.javaRep.DThisRef;
import soot.dava.internal.javaRep.DVirtualInvokeExpr;
import soot.dava.toolkits.base.AST.UselessTryRemover;
import soot.dava.toolkits.base.finders.AbruptEdgeFinder;
import soot.dava.toolkits.base.finders.CycleFinder;
import soot.dava.toolkits.base.finders.ExceptionFinder;
import soot.dava.toolkits.base.finders.IfFinder;
import soot.dava.toolkits.base.finders.LabeledBlockFinder;
import soot.dava.toolkits.base.finders.SequenceFinder;
import soot.dava.toolkits.base.finders.SwitchFinder;
import soot.dava.toolkits.base.finders.SynchronizedBlockFinder;
import soot.dava.toolkits.base.misc.MonitorConverter;
import soot.dava.toolkits.base.misc.ThrowNullConverter;
import soot.grimp.GrimpBody;
import soot.grimp.NewInvokeExpr;
import soot.jimple.ArrayRef;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.ConditionExpr;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.Expr;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.LengthExpr;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.MonitorStmt;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.ParameterRef;
import soot.jimple.Ref;
import soot.jimple.ReturnStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.UnopExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.internal.JGotoStmt;
import soot.jimple.internal.JimpleLocal;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.TrapUnitGraph;
import soot.util.IterableSet;
import soot.util.Switchable;

public class DavaBody
extends Body {
    private Map pMap = new HashMap();
    private HashSet consumedConditions = new HashSet();
    private HashSet thisLocals = new HashSet();
    private IterableSet synchronizedBlockFacts = new IterableSet();
    private IterableSet exceptionFacts = new IterableSet();
    private IterableSet monitorFacts = new IterableSet();
    private IterableSet packagesUsed = new IterableSet();
    private Local controlLocal = null;
    private InstanceInvokeExpr constructorExpr = null;
    private Unit constructorUnit;
    private List caughtrefs = new LinkedList();

    DavaBody(SootMethod m) {
        super(m);
    }

    public Unit get_ConstructorUnit() {
        return this.constructorUnit;
    }

    public List get_CaughtRefs() {
        return this.caughtrefs;
    }

    public InstanceInvokeExpr get_ConstructorExpr() {
        return this.constructorExpr;
    }

    public Map get_ParamMap() {
        return this.pMap;
    }

    public HashSet get_ThisLocals() {
        return this.thisLocals;
    }

    public Local get_ControlLocal() {
        if (this.controlLocal == null) {
            this.controlLocal = new JimpleLocal("controlLocal", IntType.v());
            this.getLocals().add(this.controlLocal);
        }
        return this.controlLocal;
    }

    public Set get_ConsumedConditions() {
        return this.consumedConditions;
    }

    public void consume_Condition(AugmentedStmt as) {
        this.consumedConditions.add(as);
    }

    public Object clone() {
        DavaBody b = Dava.v().newBody(this.getMethod());
        b.importBodyContentsFrom(this);
        return b;
    }

    public IterableSet get_SynchronizedBlockFacts() {
        return this.synchronizedBlockFacts;
    }

    public IterableSet get_ExceptionFacts() {
        return this.exceptionFacts;
    }

    public IterableSet get_MonitorFacts() {
        return this.monitorFacts;
    }

    public IterableSet get_PackagesUsed() {
        return this.packagesUsed;
    }

    DavaBody(Body body) {
        this(body.getMethod());
        Dava.v().log("\nstart method " + body.getMethod().toString());
        this.copy_Body(body);
        AugmentedStmtGraph asg = new AugmentedStmtGraph(new BriefUnitGraph(this), new TrapUnitGraph(this));
        ExceptionFinder.v().preprocess(this, asg);
        SETTopNode SET = new SETTopNode(asg.get_ChainView());
        while (true) {
            try {
                CycleFinder.v().find(this, asg, SET);
                IfFinder.v().find(this, asg, SET);
                SwitchFinder.v().find(this, asg, SET);
                SynchronizedBlockFinder.v().find(this, asg, SET);
                ExceptionFinder.v().find(this, asg, SET);
                SequenceFinder.v().find(this, asg, SET);
                LabeledBlockFinder.v().find(this, asg, SET);
                AbruptEdgeFinder.v().find(this, asg, SET);
            }
            catch (RetriggerAnalysisException rae) {
                SET = new SETTopNode(asg.get_ChainView());
                this.consumedConditions = new HashSet();
                continue;
            }
            break;
        }
        MonitorConverter.v().convert(this);
        ThrowNullConverter.v().convert(this);
        ASTNode AST = ((SETNode)SET).emit_AST();
        this.getTraps().clear();
        this.getUnits().clear();
        this.getUnits().addLast(AST);
        do {
            G.v().ASTAnalysis_modified = false;
            AST.perform_Analysis(UselessTryRemover.v());
        } while (G.v().ASTAnalysis_modified);
        Dava.v().log("end method " + body.getMethod().toString());
    }

    private void copy_Body(Body body) {
        Switchable copy;
        if (!(body instanceof GrimpBody)) {
            throw new RuntimeException("You can only create a DavaBody from a GrimpBody!");
        }
        GrimpBody grimpBody = (GrimpBody)body;
        HashMap<Switchable, Unit> bindings = new HashMap<Switchable, Unit>();
        HashMap<Unit, Switchable> reverse_binding = new HashMap<Unit, Switchable>();
        for (Switchable original : grimpBody.getUnits()) {
            copy = (Unit)original.clone();
            this.getUnits().addLast(copy);
            bindings.put(original, (Unit)copy);
            reverse_binding.put((Unit)copy, original);
        }
        for (Unit u : this.getUnits()) {
            Unit[] new_target_list;
            Stmt original_switch;
            Stmt s = (Stmt)u;
            if (s instanceof TableSwitchStmt) {
                TableSwitchStmt ts = (TableSwitchStmt)s;
                original_switch = (TableSwitchStmt)reverse_binding.get(u);
                ts.setDefaultTarget((Unit)bindings.get(original_switch.getDefaultTarget()));
                new_target_list = new LinkedList();
                int target_count = ts.getHighIndex() - ts.getLowIndex() + 1;
                for (int i = 0; i < target_count; ++i) {
                    new_target_list.add((Unit)bindings.get(original_switch.getTarget(i)));
                }
                ts.setTargets((List)new_target_list);
            }
            if (!(s instanceof LookupSwitchStmt)) continue;
            LookupSwitchStmt ls = (LookupSwitchStmt)s;
            original_switch = (LookupSwitchStmt)reverse_binding.get(u);
            ls.setDefaultTarget((Unit)bindings.get(original_switch.getDefaultTarget()));
            new_target_list = new Unit[original_switch.getTargetCount()];
            for (int i = 0; i < original_switch.getTargetCount(); ++i) {
                new_target_list[i] = (Unit)bindings.get(original_switch.getTarget(i));
            }
            ls.setTargets(new_target_list);
            ls.setLookupValues(original_switch.getLookupValues());
        }
        for (Switchable original : grimpBody.getLocals()) {
            copy = Dava.v().newLocal(original.getName(), original.getType());
            this.getLocals().addLast(copy);
            bindings.put(original, (Unit)copy);
        }
        for (UnitBox box : this.getAllUnitBoxes()) {
            Unit oldObject = box.getUnit();
            Unit newObject = (Unit)bindings.get(oldObject);
            if (newObject == null) continue;
            box.setUnit(newObject);
        }
        for (ValueBox vb : this.getUseAndDefBoxes()) {
            if (!(vb.getValue() instanceof Local)) continue;
            vb.setValue((Value)bindings.get(vb.getValue()));
        }
        for (Trap originalTrap : grimpBody.getTraps()) {
            Trap cloneTrap = (Trap)originalTrap.clone();
            Unit handlerUnit = (Unit)bindings.get(originalTrap.getHandlerUnit());
            cloneTrap.setHandlerUnit(handlerUnit);
            cloneTrap.setBeginUnit((Unit)bindings.get(originalTrap.getBeginUnit()));
            cloneTrap.setEndUnit((Unit)bindings.get(originalTrap.getEndUnit()));
            this.getTraps().add(cloneTrap);
        }
        PatchingChain units = this.getUnits();
        Iterator it = units.snapshotIterator();
        while (it.hasNext()) {
            JGotoStmt jgs;
            Unit u = (Unit)it.next();
            Stmt s = (Stmt)u;
            if (s instanceof IfStmt) {
                IfStmt ifs = (IfStmt)s;
                JGotoStmt jgs2 = new JGotoStmt((Unit)units.getSuccOf(u));
                units.insertAfter(jgs2, (Object)u);
                JGotoStmt jumper = new JGotoStmt(ifs.getTarget());
                units.insertAfter(jumper, (Object)jgs2);
                ifs.setTarget(jumper);
                continue;
            }
            if (s instanceof TableSwitchStmt) {
                TableSwitchStmt tss = (TableSwitchStmt)s;
                int targetCount = tss.getHighIndex() - tss.getLowIndex() + 1;
                for (int i = 0; i < targetCount; ++i) {
                    JGotoStmt jgs3 = new JGotoStmt(tss.getTarget(i));
                    units.insertAfter(jgs3, (Object)tss);
                    tss.setTarget(i, jgs3);
                }
                jgs = new JGotoStmt(tss.getDefaultTarget());
                units.insertAfter(jgs, (Object)tss);
                tss.setDefaultTarget(jgs);
                continue;
            }
            if (!(s instanceof LookupSwitchStmt)) continue;
            LookupSwitchStmt lss = (LookupSwitchStmt)s;
            for (int i = 0; i < lss.getTargetCount(); ++i) {
                jgs = new JGotoStmt(lss.getTarget(i));
                units.insertAfter(jgs, (Object)lss);
                lss.setTarget(i, jgs);
            }
            JGotoStmt jgs4 = new JGotoStmt(lss.getDefaultTarget());
            units.insertAfter(jgs4, (Object)lss);
            lss.setDefaultTarget(jgs4);
        }
        for (Trap t : this.getTraps()) {
            JGotoStmt jgs = new JGotoStmt(t.getHandlerUnit());
            units.addLast(jgs);
            t.setHandlerUnit(jgs);
        }
        Iterator it2 = this.getLocals().iterator();
        while (it2.hasNext()) {
            Type t = ((Local)it2.next()).getType();
            if (!(t instanceof RefType)) continue;
            RefType rt = (RefType)t;
            this.addPackage(rt.getSootClass().getJavaPackageName());
        }
        for (Unit u : this.getUnits()) {
            Stmt s = (Stmt)u;
            if (s instanceof IfStmt) {
                this.javafy(((IfStmt)s).getConditionBox());
                continue;
            }
            if (s instanceof ThrowStmt) {
                this.javafy(((ThrowStmt)s).getOpBox());
                continue;
            }
            if (s instanceof TableSwitchStmt) {
                this.javafy(((TableSwitchStmt)s).getKeyBox());
                continue;
            }
            if (s instanceof LookupSwitchStmt) {
                this.javafy(((LookupSwitchStmt)s).getKeyBox());
                continue;
            }
            if (s instanceof MonitorStmt) {
                this.javafy(((MonitorStmt)s).getOpBox());
                continue;
            }
            if (s instanceof DefinitionStmt) {
                DefinitionStmt ds = (DefinitionStmt)s;
                this.javafy(ds.getRightOpBox());
                this.javafy(ds.getLeftOpBox());
                if (!(ds.getRightOp() instanceof IntConstant)) continue;
                ds.getRightOpBox().setValue(DIntConstant.v(((IntConstant)ds.getRightOp()).value, ds.getLeftOp().getType()));
                continue;
            }
            if (s instanceof ReturnStmt) {
                ReturnStmt rs = (ReturnStmt)s;
                if (rs.getOp() instanceof IntConstant) {
                    rs.getOpBox().setValue(DIntConstant.v(((IntConstant)rs.getOp()).value, body.getMethod().getReturnType()));
                    continue;
                }
                this.javafy(rs.getOpBox());
                continue;
            }
            if (!(s instanceof InvokeStmt)) continue;
            this.javafy(((InvokeStmt)s).getInvokeExprBox());
        }
        for (Stmt s : this.getUnits()) {
            if (s instanceof IdentityStmt) {
                IdentityStmt ids = (IdentityStmt)s;
                Value ids_rightOp = ids.getRightOp();
                Value ids_leftOp = ids.getLeftOp();
                if (ids_leftOp instanceof Local && ids_rightOp instanceof ThisRef) {
                    Local thisLocal = (Local)ids_leftOp;
                    this.thisLocals.add(thisLocal);
                    thisLocal.setName("this");
                }
            }
            if (!(s instanceof DefinitionStmt)) continue;
            DefinitionStmt ds = (DefinitionStmt)s;
            Value rightOp = ds.getRightOp();
            if (rightOp instanceof ParameterRef) {
                this.pMap.put(new Integer(((ParameterRef)rightOp).getIndex()), ds.getLeftOp());
            }
            if (!(rightOp instanceof CaughtExceptionRef)) continue;
            this.caughtrefs.add(ds.getLeftOp());
        }
        for (Stmt s : this.getUnits()) {
            SootMethod m;
            String name;
            InstanceInvokeExpr iie;
            Value base;
            InvokeStmt ivs;
            InvokeExpr ie;
            if (!(s instanceof InvokeStmt) || !((ie = (ivs = (InvokeStmt)s).getInvokeExpr()) instanceof InstanceInvokeExpr) || !((base = (iie = (InstanceInvokeExpr)ie).getBase()) instanceof Local) || !((Local)base).getName().equals("this") || !(name = (m = iie.getMethod()).getName()).equals("<init>") && !name.equals("<clinit>")) continue;
            if (this.constructorUnit != null) {
                throw new RuntimeException("More than one candidate for constructor found.");
            }
            this.constructorExpr = iie;
            this.constructorUnit = s;
        }
    }

    private void javafy(ValueBox vb) {
        Value v = vb.getValue();
        if (v instanceof Expr) {
            this.javafy_expr(vb);
        } else if (v instanceof Ref) {
            this.javafy_ref(vb);
        } else if (v instanceof Local) {
            this.javafy_local(vb);
        } else if (v instanceof Constant) {
            this.javafy_constant(vb);
        }
    }

    private void javafy_expr(ValueBox vb) {
        Expr e = (Expr)vb.getValue();
        if (e instanceof BinopExpr) {
            this.javafy_binop_expr(vb);
        } else if (e instanceof UnopExpr) {
            this.javafy_unop_expr(vb);
        } else if (e instanceof CastExpr) {
            this.javafy_cast_expr(vb);
        } else if (e instanceof NewArrayExpr) {
            this.javafy_newarray_expr(vb);
        } else if (e instanceof NewMultiArrayExpr) {
            this.javafy_newmultiarray_expr(vb);
        } else if (e instanceof InstanceOfExpr) {
            this.javafy_instanceof_expr(vb);
        } else if (e instanceof InvokeExpr) {
            this.javafy_invoke_expr(vb);
        } else if (e instanceof NewExpr) {
            this.javafy_new_expr(vb);
        }
    }

    private void javafy_ref(ValueBox vb) {
        Ref r = (Ref)vb.getValue();
        if (r instanceof StaticFieldRef) {
            SootField field = ((StaticFieldRef)r).getField();
            this.addPackage(field.getDeclaringClass().getJavaPackageName());
            vb.setValue(new DStaticFieldRef(field, this.getMethod().getDeclaringClass().getName()));
        } else if (r instanceof ArrayRef) {
            ArrayRef ar = (ArrayRef)r;
            this.javafy(ar.getBaseBox());
            this.javafy(ar.getIndexBox());
        } else if (r instanceof InstanceFieldRef) {
            InstanceFieldRef ifr = (InstanceFieldRef)r;
            this.javafy(ifr.getBaseBox());
            vb.setValue(new DInstanceFieldRef(ifr.getBase(), ifr.getField(), this.thisLocals));
        } else if (r instanceof ThisRef) {
            ThisRef tr = (ThisRef)r;
            vb.setValue(new DThisRef((RefType)tr.getType()));
        }
    }

    private void javafy_local(ValueBox vb) {
    }

    private void javafy_constant(ValueBox vb) {
    }

    private void javafy_binop_expr(ValueBox vb) {
        BinopExpr boe = (BinopExpr)vb.getValue();
        ValueBox leftOpBox = boe.getOp1Box();
        ValueBox rightOpBox = boe.getOp2Box();
        Value leftOp = leftOpBox.getValue();
        Value rightOp = rightOpBox.getValue();
        if (rightOp instanceof IntConstant) {
            if (!(leftOp instanceof IntConstant)) {
                this.javafy(leftOpBox);
                leftOp = leftOpBox.getValue();
                if (boe instanceof ConditionExpr) {
                    rightOpBox.setValue(DIntConstant.v(((IntConstant)rightOp).value, leftOp.getType()));
                } else {
                    rightOpBox.setValue(DIntConstant.v(((IntConstant)rightOp).value, null));
                }
            }
        } else if (leftOp instanceof IntConstant) {
            this.javafy(rightOpBox);
            rightOp = rightOpBox.getValue();
            if (boe instanceof ConditionExpr) {
                leftOpBox.setValue(DIntConstant.v(((IntConstant)leftOp).value, rightOp.getType()));
            } else {
                leftOpBox.setValue(DIntConstant.v(((IntConstant)leftOp).value, null));
            }
        } else {
            this.javafy(rightOpBox);
            rightOp = rightOpBox.getValue();
            this.javafy(leftOpBox);
            leftOp = leftOpBox.getValue();
        }
        if (boe instanceof CmpExpr) {
            vb.setValue(new DCmpExpr(leftOp, rightOp));
        } else if (boe instanceof CmplExpr) {
            vb.setValue(new DCmplExpr(leftOp, rightOp));
        } else if (boe instanceof CmpgExpr) {
            vb.setValue(new DCmpgExpr(leftOp, rightOp));
        }
    }

    private void javafy_unop_expr(ValueBox vb) {
        UnopExpr uoe = (UnopExpr)vb.getValue();
        this.javafy(uoe.getOpBox());
        if (uoe instanceof LengthExpr) {
            vb.setValue(new DLengthExpr(((LengthExpr)uoe).getOp()));
        } else if (uoe instanceof NegExpr) {
            vb.setValue(new DNegExpr(((NegExpr)uoe).getOp()));
        }
    }

    private void javafy_cast_expr(ValueBox vb) {
        CastExpr ce = (CastExpr)vb.getValue();
        this.javafy(ce.getOpBox());
    }

    private void javafy_newarray_expr(ValueBox vb) {
        NewArrayExpr nae = (NewArrayExpr)vb.getValue();
        this.javafy(nae.getSizeBox());
        vb.setValue(new DNewArrayExpr(nae.getBaseType(), nae.getSize()));
    }

    private void javafy_newmultiarray_expr(ValueBox vb) {
        NewMultiArrayExpr nmae = (NewMultiArrayExpr)vb.getValue();
        for (int i = 0; i < nmae.getSizeCount(); ++i) {
            this.javafy(nmae.getSizeBox(i));
        }
        vb.setValue(new DNewMultiArrayExpr(nmae.getBaseType(), nmae.getSizes()));
    }

    private void javafy_instanceof_expr(ValueBox vb) {
        InstanceOfExpr ioe = (InstanceOfExpr)vb.getValue();
        this.javafy(ioe.getOpBox());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void javafy_invoke_expr(ValueBox vb) {
        InvokeExpr ie = (InvokeExpr)vb.getValue();
        this.addPackage(ie.getMethod().getDeclaringClass().getJavaPackageName());
        for (int i = 0; i < ie.getArgCount(); ++i) {
            Value arg = ie.getArg(i);
            if (arg instanceof IntConstant) {
                ie.getArgBox(i).setValue(DIntConstant.v(((IntConstant)arg).value, ie.getMethod().getParameterType(i)));
                continue;
            }
            this.javafy(ie.getArgBox(i));
        }
        if (ie instanceof InstanceInvokeExpr) {
            this.javafy(((InstanceInvokeExpr)ie).getBaseBox());
            if (ie instanceof VirtualInvokeExpr) {
                VirtualInvokeExpr vie = (VirtualInvokeExpr)ie;
                vb.setValue(new DVirtualInvokeExpr(vie.getBase(), vie.getMethod(), vie.getArgs(), this.thisLocals));
                return;
            } else if (ie instanceof SpecialInvokeExpr) {
                SpecialInvokeExpr sie = (SpecialInvokeExpr)ie;
                vb.setValue(new DSpecialInvokeExpr(sie.getBase(), sie.getMethod(), sie.getArgs()));
                return;
            } else {
                if (!(ie instanceof InterfaceInvokeExpr)) throw new RuntimeException("InstanceInvokeExpr " + ie + " not javafied correctly");
                InterfaceInvokeExpr iie = (InterfaceInvokeExpr)ie;
                vb.setValue(new DInterfaceInvokeExpr(iie.getBase(), iie.getMethod(), iie.getArgs()));
            }
            return;
        } else {
            if (!(ie instanceof StaticInvokeExpr)) throw new RuntimeException("InvokeExpr " + ie + " not javafied correctly");
            StaticInvokeExpr sie = (StaticInvokeExpr)ie;
            if (sie instanceof NewInvokeExpr) {
                NewInvokeExpr nie = (NewInvokeExpr)sie;
                RefType rt = nie.getBaseType();
                this.addPackage(rt.getSootClass().getJavaPackageName());
                vb.setValue(new DNewInvokeExpr((RefType)nie.getType(), nie.getMethod(), nie.getArgs()));
                return;
            } else {
                SootMethod method = sie.getMethod();
                this.addPackage(method.getDeclaringClass().getJavaPackageName());
                vb.setValue(new DStaticInvokeExpr(method, sie.getArgs()));
            }
        }
    }

    private void javafy_new_expr(ValueBox vb) {
        NewExpr ne = (NewExpr)vb.getValue();
        this.addPackage(ne.getBaseType().getSootClass().getJavaPackageName());
    }

    public void addPackage(String newPackage) {
        if (newPackage.equals("")) {
            return;
        }
        if (!this.packagesUsed.contains(newPackage)) {
            this.packagesUsed.add(newPackage);
        }
    }
}

