/*
 * Decompiled with CFR 0.152.
 */
package soot.coffi;

import soot.G;
import soot.coffi.CFG;
import soot.coffi.ClassFile;
import soot.coffi.Code_attribute;
import soot.coffi.Instruction;
import soot.coffi.method_info;

class Main {
    Main() {
    }

    public static void main(String[] args) throws RuntimeException {
        if (args.length == 0) {
            G.v().out.println("Usage: java soot.coffi.Main class1 class2 ...");
            System.exit(0);
        }
        for (int i = 0; i < args.length; ++i) {
            Main.printClassInfo(args[i]);
        }
    }

    public static void printClassInfo(String name) {
        ClassFile coffiClass = new ClassFile(name);
        boolean success = coffiClass.loadClassFile();
        if (!success) {
            throw new RuntimeException("Couldn't load class file for " + name);
        }
        long totalLocals = 0L;
        long totalInstructions = 0L;
        long totalCodeSize = 0L;
        for (int i = 0; i < coffiClass.methods_count; ++i) {
            method_info method = coffiClass.methods[i];
            Code_attribute code_attribute = method.locate_code_attribute();
            long numLocals = 0L;
            long numInstructions = 0L;
            long codeSize = 0L;
            if (code_attribute != null) {
                new CFG(method);
                method.cfg.reconstructInstructions();
                numLocals += (long)code_attribute.max_locals;
                codeSize += code_attribute.code_length;
                Instruction ins = method.instructions;
                while (ins != null) {
                    ++numInstructions;
                    ins = ins.next;
                }
            }
            totalLocals += numLocals;
            totalInstructions += numInstructions;
            totalCodeSize += codeSize;
        }
        G.v().out.println(name + ": " + totalLocals + " locals  " + totalInstructions + " bytecode instructions  " + totalCodeSize + " bytes of code");
    }
}

