/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.internal;

import soot.SootField;
import soot.UnitPrinter;
import soot.baf.FieldPutInst;
import soot.baf.InstSwitch;
import soot.baf.JasminClass;
import soot.baf.internal.AbstractInst;
import soot.util.Switch;

public class BFieldPutInst
extends AbstractInst
implements FieldPutInst {
    SootField field;

    public BFieldPutInst(SootField field) {
        this.field = field;
    }

    public int getInCount() {
        return 2;
    }

    public int getOutCount() {
        return 0;
    }

    public Object clone() {
        return new BFieldPutInst(this.getField());
    }

    public int getInMachineCount() {
        return JasminClass.sizeOfType(this.field.getType()) + 1;
    }

    public int getOutMachineCount() {
        return 0;
    }

    public final String getName() {
        return "fieldput";
    }

    final String getParameters() {
        return " " + this.field.getSignature();
    }

    protected void getParameters(UnitPrinter up) {
        up.literal(" ");
        up.fieldRef(this.field);
    }

    public SootField getField() {
        return this.field;
    }

    public void setField(SootField f) {
        this.field = f;
    }

    public void apply(Switch sw) {
        ((InstSwitch)sw).caseFieldPutInst(this);
    }

    public boolean containsFieldRef() {
        return true;
    }
}

