/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.internal;

import java.util.Iterator;
import soot.SootMethod;
import soot.Type;
import soot.UnitPrinter;
import soot.VoidType;
import soot.baf.JasminClass;
import soot.baf.internal.AbstractInst;

abstract class AbstractInvokeInst
extends AbstractInst {
    SootMethod method;

    AbstractInvokeInst() {
    }

    public SootMethod getMethod() {
        return this.method;
    }

    public void setMethod(SootMethod m) {
        this.method = m;
    }

    public Type getType() {
        return this.method.getReturnType();
    }

    public String toString() {
        return this.getName() + this.getParameters();
    }

    public abstract String getName();

    String getParameters() {
        return " " + this.method.getSignature();
    }

    protected void getParameters(UnitPrinter up) {
        up.literal(" ");
        up.method(this.method);
    }

    public int getInCount() {
        return this.getMethod().getParameterCount();
    }

    public int getOutCount() {
        if (this.getMethod().getReturnType() instanceof VoidType) {
            return 0;
        }
        return 1;
    }

    public int getInMachineCount() {
        int count = 0;
        Iterator it = this.getMethod().getParameterTypes().iterator();
        while (it.hasNext()) {
            count += JasminClass.sizeOfType((Type)it.next());
        }
        return count;
    }

    public int getOutMachineCount() {
        if (this.getMethod().getReturnType() instanceof VoidType) {
            return 0;
        }
        return JasminClass.sizeOfType(this.getMethod().getReturnType());
    }

    public boolean containsInvokeExpr() {
        return true;
    }
}

