/*
 * Decompiled with CFR 0.152.
 */
package soot.baf;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.Modifier;
import soot.NullType;
import soot.PatchingChain;
import soot.PrimType;
import soot.RefType;
import soot.ShortType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.StmtAddressType;
import soot.Timers;
import soot.Trap;
import soot.Type;
import soot.TypeSwitch;
import soot.ValueBox;
import soot.VoidType;
import soot.baf.AddInst;
import soot.baf.AndInst;
import soot.baf.ArrayLengthInst;
import soot.baf.ArrayReadInst;
import soot.baf.ArrayWriteInst;
import soot.baf.BafBody;
import soot.baf.CmpInst;
import soot.baf.CmpgInst;
import soot.baf.CmplInst;
import soot.baf.DivInst;
import soot.baf.DoubleWordType;
import soot.baf.Dup1Inst;
import soot.baf.Dup1_x1Inst;
import soot.baf.Dup1_x2Inst;
import soot.baf.Dup2Inst;
import soot.baf.Dup2_x1Inst;
import soot.baf.Dup2_x2Inst;
import soot.baf.EnterMonitorInst;
import soot.baf.ExitMonitorInst;
import soot.baf.FieldGetInst;
import soot.baf.FieldPutInst;
import soot.baf.GotoInst;
import soot.baf.IdentityInst;
import soot.baf.IfCmpEqInst;
import soot.baf.IfCmpGeInst;
import soot.baf.IfCmpGtInst;
import soot.baf.IfCmpLeInst;
import soot.baf.IfCmpLtInst;
import soot.baf.IfCmpNeInst;
import soot.baf.IfEqInst;
import soot.baf.IfGeInst;
import soot.baf.IfGtInst;
import soot.baf.IfLeInst;
import soot.baf.IfLtInst;
import soot.baf.IfNeInst;
import soot.baf.IfNonNullInst;
import soot.baf.IfNullInst;
import soot.baf.IncInst;
import soot.baf.Inst;
import soot.baf.InstBox;
import soot.baf.InstSwitch;
import soot.baf.InstanceCastInst;
import soot.baf.InstanceOfInst;
import soot.baf.InterfaceInvokeInst;
import soot.baf.LoadInst;
import soot.baf.LookupSwitchInst;
import soot.baf.MulInst;
import soot.baf.NegInst;
import soot.baf.NewArrayInst;
import soot.baf.NewInst;
import soot.baf.NewMultiArrayInst;
import soot.baf.NopInst;
import soot.baf.OpTypeArgInst;
import soot.baf.OrInst;
import soot.baf.PopInst;
import soot.baf.PrimitiveCastInst;
import soot.baf.PushInst;
import soot.baf.RemInst;
import soot.baf.ReturnInst;
import soot.baf.ReturnVoidInst;
import soot.baf.ShlInst;
import soot.baf.ShrInst;
import soot.baf.SpecialInvokeInst;
import soot.baf.StaticGetInst;
import soot.baf.StaticInvokeInst;
import soot.baf.StaticPutInst;
import soot.baf.StoreInst;
import soot.baf.SubInst;
import soot.baf.SwapInst;
import soot.baf.TableSwitchInst;
import soot.baf.ThrowInst;
import soot.baf.UshrInst;
import soot.baf.VirtualInvokeInst;
import soot.baf.XorInst;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IdentityRef;
import soot.jimple.IdentityStmt;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.ThisRef;
import soot.options.Options;
import soot.tagkit.Attribute;
import soot.tagkit.Base64;
import soot.tagkit.JasminAttribute;
import soot.tagkit.Tag;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.BriefBlockGraph;

public class JasminClass {
    Map instToLabel;
    Map localToSlot;
    Map subroutineToReturnAddressSlot;
    List code;
    boolean isEmittingMethodCode;
    int labelCount;
    boolean isNextGotoAJsr;
    int returnAddressSlot;
    int currentStackHeight = 0;
    int maxStackHeight = 0;
    Map localToGroup;
    Map groupToColorCount;
    Map localToColor;
    Map blockToStackHeight = new HashMap();
    Map blockToLogicalStackHeight = new HashMap();

    String slashify(String s) {
        return s.replace('.', '/');
    }

    public static int sizeOfType(Type t) {
        if (t instanceof DoubleWordType || t instanceof LongType || t instanceof DoubleType) {
            return 2;
        }
        if (t instanceof VoidType) {
            return 0;
        }
        return 1;
    }

    int argCountOf(SootMethod m) {
        int argCount = 0;
        for (Type t : m.getParameterTypes()) {
            argCount += JasminClass.sizeOfType(t);
        }
        return argCount;
    }

    String jasminDescriptorOf(Type type) {
        TypeSwitch sw = new TypeSwitch(){

            public void caseBooleanType(BooleanType t) {
                this.setResult("Z");
            }

            public void caseByteType(ByteType t) {
                this.setResult("B");
            }

            public void caseCharType(CharType t) {
                this.setResult("C");
            }

            public void caseDoubleType(DoubleType t) {
                this.setResult("D");
            }

            public void caseFloatType(FloatType t) {
                this.setResult("F");
            }

            public void caseIntType(IntType t) {
                this.setResult("I");
            }

            public void caseLongType(LongType t) {
                this.setResult("J");
            }

            public void caseShortType(ShortType t) {
                this.setResult("S");
            }

            public void defaultCase(Type t) {
                throw new RuntimeException("Invalid type: " + t);
            }

            public void caseArrayType(ArrayType t) {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < t.numDimensions; ++i) {
                    buffer.append("[");
                }
                this.setResult(buffer.toString() + JasminClass.this.jasminDescriptorOf(t.baseType));
            }

            public void caseRefType(RefType t) {
                this.setResult("L" + t.getClassName().replace('.', '/') + ";");
            }

            public void caseVoidType(VoidType t) {
                this.setResult("V");
            }
        };
        type.apply(sw);
        return (String)sw.getResult();
    }

    String jasminDescriptorOf(SootMethod m) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        for (Type t : m.getParameterTypes()) {
            buffer.append(this.jasminDescriptorOf(t));
        }
        buffer.append(")");
        buffer.append(this.jasminDescriptorOf(m.getReturnType()));
        return buffer.toString();
    }

    void emit(String s) {
        this.okayEmit(s);
    }

    void okayEmit(String s) {
        if (this.isEmittingMethodCode && !s.endsWith(":")) {
            this.code.add("    " + s);
        } else {
            this.code.add(s);
        }
    }

    public JasminClass(SootClass sootClass) {
        if (Options.v().time()) {
            Timers.v().buildJasminTimer.start();
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + sootClass.getName() + "] Constructing baf.JasminClass...");
        }
        this.code = new LinkedList();
        int modifiers = sootClass.getModifiers();
        if (Modifier.isInterface(modifiers)) {
            this.emit(".interface " + Modifier.toString(modifiers -= 512) + " " + this.slashify(sootClass.getName()));
        } else {
            this.emit(".class " + Modifier.toString(modifiers) + " " + this.slashify(sootClass.getName()));
        }
        if (sootClass.hasSuperclass()) {
            this.emit(".super " + this.slashify(sootClass.getSuperclass().getName()));
        } else {
            this.emit(".super " + this.slashify(sootClass.getName()));
        }
        this.emit("");
        for (SootClass inter : sootClass.getInterfaces()) {
            this.emit(".implements " + this.slashify(inter.getName()));
        }
        if (sootClass.getInterfaceCount() != 0) {
            this.emit("");
        }
        for (Tag tag : sootClass.getTags()) {
            if (!(tag instanceof Attribute)) continue;
            this.emit(".class_attribute " + tag.getName() + " \"" + new String(Base64.encode(((Attribute)tag).getValue())) + "\"");
        }
        for (SootField field : sootClass.getFields()) {
            this.emit(".field " + Modifier.toString(field.getModifiers()) + " " + "\"" + field.getName() + "\"" + " " + this.jasminDescriptorOf(field.getType()));
            for (Tag tag : field.getTags()) {
                if (!(tag instanceof Attribute)) continue;
                this.emit(".field_attribute " + tag.getName() + " \"" + new String(Base64.encode(((Attribute)tag).getValue())) + "\"");
            }
        }
        if (sootClass.getFieldCount() != 0) {
            this.emit("");
        }
        Iterator methodIt = sootClass.methodIterator();
        while (methodIt.hasNext()) {
            this.emitMethod((SootMethod)methodIt.next());
            this.emit("");
        }
        if (Options.v().time()) {
            Timers.v().buildJasminTimer.end();
        }
    }

    void assignColorsToLocals(BafBody body) {
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "] Assigning colors to locals...");
        }
        if (Options.v().time()) {
            Timers.v().packTimer.start();
        }
        this.localToGroup = new HashMap(body.getLocalCount() * 2 + 1, 0.7f);
        this.groupToColorCount = new HashMap(body.getLocalCount() * 2 + 1, 0.7f);
        this.localToColor = new HashMap(body.getLocalCount() * 2 + 1, 0.7f);
        for (Local l : body.getLocals()) {
            PrimType g = JasminClass.sizeOfType(l.getType()) == 1 ? IntType.v() : LongType.v();
            this.localToGroup.put(l, g);
            if (this.groupToColorCount.containsKey(g)) continue;
            this.groupToColorCount.put(g, new Integer(0));
        }
        for (Stmt s : body.getUnits()) {
            if (!(s instanceof IdentityStmt) || !(((IdentityStmt)s).getLeftOp() instanceof Local)) continue;
            Local l = (Local)((IdentityStmt)s).getLeftOp();
            Object group = this.localToGroup.get(l);
            int count = (Integer)this.groupToColorCount.get(group);
            this.localToColor.put(l, new Integer(count));
            this.groupToColorCount.put(group, new Integer(++count));
        }
        if (Options.v().time()) {
            Timers.v().packTimer.end();
        }
    }

    void emitMethod(SootMethod method) {
        if (method.isPhantom()) {
            return;
        }
        this.emit(".method " + Modifier.toString(method.getModifiers()) + " " + method.getName() + this.jasminDescriptorOf(method));
        if (method.isConcrete()) {
            if (!method.hasActiveBody()) {
                throw new RuntimeException("method: " + method.getName() + " has no active body!");
            }
            this.emitMethodBody(method);
        }
        this.emit(".end method");
        for (Tag tag : method.getTags()) {
            if (!(tag instanceof Attribute)) continue;
            this.emit(".method_attribute " + tag.getName() + " \"" + new String(Base64.encode(tag.getValue())) + "\"");
        }
    }

    void emitMethodBody(SootMethod method) {
        BriefBlockGraph blockGraph;
        List blocks;
        Body activeBody;
        if (Options.v().time()) {
            Timers.v().buildJasminTimer.end();
        }
        if (!((activeBody = method.getActiveBody()) instanceof BafBody)) {
            throw new RuntimeException("method: " + method.getName() + " has an invalid active body!");
        }
        BafBody body = (BafBody)activeBody;
        if (body == null) {
            throw new RuntimeException("method: " + method.getName() + " has no active body!");
        }
        if (Options.v().time()) {
            Timers.v().buildJasminTimer.start();
        }
        PatchingChain instList = body.getUnits();
        int stackLimitIndex = -1;
        this.subroutineToReturnAddressSlot = new HashMap(10, 0.7f);
        Iterator boxIt = body.getUnitBoxes(true).iterator();
        this.instToLabel = new HashMap(instList.size() * 2 + 1, 0.7f);
        this.labelCount = 0;
        while (boxIt.hasNext()) {
            InstBox box = (InstBox)boxIt.next();
            if (this.instToLabel.containsKey(box.getUnit())) continue;
            this.instToLabel.put(box.getUnit(), "label" + this.labelCount++);
        }
        for (Trap trap : body.getTraps()) {
            if (trap.getBeginUnit() == trap.getEndUnit()) continue;
            this.emit(".catch " + this.slashify(trap.getException().getName()) + " from " + this.instToLabel.get(trap.getBeginUnit()) + " to " + this.instToLabel.get(trap.getEndUnit()) + " using " + this.instToLabel.get(trap.getHandlerUnit()));
        }
        int localCount = 0;
        int[] paramSlots = new int[method.getParameterCount()];
        int thisSlot = 0;
        HashSet<Local> assignedLocals = new HashSet<Local>();
        HashMap groupColorPairToSlot = new HashMap(body.getLocalCount() * 2 + 1, 0.7f);
        this.localToSlot = new HashMap(body.getLocalCount() * 2 + 1, 0.7f);
        List paramTypes = method.getParameterTypes();
        if (!method.isStatic()) {
            thisSlot = 0;
            ++localCount;
        }
        for (int i = 0; i < paramTypes.size(); ++i) {
            paramSlots[i] = localCount;
            localCount += JasminClass.sizeOfType((Type)paramTypes.get(i));
        }
        for (Inst s : instList) {
            if (!(s instanceof IdentityInst) || !(((IdentityInst)s).getLeftOp() instanceof Local)) continue;
            Local l = (Local)((IdentityInst)s).getLeftOp();
            IdentityRef identity = (IdentityRef)((IdentityInst)s).getRightOp();
            int slot = 0;
            if (identity instanceof ThisRef) {
                if (method.isStatic()) {
                    throw new RuntimeException("Attempting to use 'this' in static method");
                }
                slot = thisSlot;
            } else {
                if (!(identity instanceof ParameterRef)) continue;
                slot = paramSlots[((ParameterRef)identity).getIndex()];
            }
            this.localToSlot.put(l, new Integer(slot));
            assignedLocals.add(l);
        }
        for (Local local : body.getLocals()) {
            if (assignedLocals.contains(local)) continue;
            this.localToSlot.put(local, new Integer(localCount));
            localCount += JasminClass.sizeOfType(local.getType());
            assignedLocals.add(local);
        }
        if (!Modifier.isNative(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers())) {
            this.emit("    .limit stack ?");
            stackLimitIndex = this.code.size() - 1;
            this.emit("    .limit locals " + localCount);
        }
        Iterator codeIt = instList.iterator();
        this.isEmittingMethodCode = true;
        this.maxStackHeight = 0;
        this.isNextGotoAJsr = false;
        while (codeIt.hasNext()) {
            Inst s = (Inst)codeIt.next();
            if (this.instToLabel.containsKey(s)) {
                this.emit(this.instToLabel.get(s) + ":");
            }
            this.emitInst(s);
        }
        this.isEmittingMethodCode = false;
        this.maxStackHeight = 0;
        if (activeBody.getUnits().size() != 0 && (blocks = (blockGraph = new BriefBlockGraph(activeBody)).getBlocks()).size() != 0) {
            Block b = (Block)blocks.get(0);
            List entryPoints = blockGraph.getHeads();
            for (Block entryBlock : entryPoints) {
                Integer initialHeight = entryBlock == b ? new Integer(0) : new Integer(1);
                this.blockToStackHeight.put(entryBlock, initialHeight);
                this.blockToLogicalStackHeight.put(entryBlock, initialHeight);
            }
            for (Block nextBlock : entryPoints) {
                this.calculateStackHeight(nextBlock);
                this.calculateLogicalStackHeightCheck(nextBlock);
            }
        }
        if (!Modifier.isNative(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers())) {
            this.code.set(stackLimitIndex, "    .limit stack " + this.maxStackHeight);
        }
        for (Tag t : body.getTags()) {
            if (!(t instanceof JasminAttribute)) continue;
            this.emit(".code_attribute " + t.getName() + " \"" + ((JasminAttribute)t).getJasminValue(this.instToLabel) + "\"");
        }
    }

    public void print(PrintWriter out) {
        Iterator it = this.code.iterator();
        while (it.hasNext()) {
            out.println(it.next());
        }
    }

    void emitInst(Inst inst) {
        inst.apply(new InstSwitch(){

            public void caseReturnVoidInst(ReturnVoidInst i) {
                JasminClass.this.emit("return");
            }

            public void caseReturnInst(ReturnInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid return type " + t.toString());
                    }

                    public void caseDoubleType(DoubleType t) {
                        JasminClass.this.emit("dreturn");
                    }

                    public void caseFloatType(FloatType t) {
                        JasminClass.this.emit("freturn");
                    }

                    public void caseIntType(IntType t) {
                        JasminClass.this.emit("ireturn");
                    }

                    public void caseByteType(ByteType t) {
                        JasminClass.this.emit("ireturn");
                    }

                    public void caseShortType(ShortType t) {
                        JasminClass.this.emit("ireturn");
                    }

                    public void caseCharType(CharType t) {
                        JasminClass.this.emit("ireturn");
                    }

                    public void caseBooleanType(BooleanType t) {
                        JasminClass.this.emit("ireturn");
                    }

                    public void caseLongType(LongType t) {
                        JasminClass.this.emit("lreturn");
                    }

                    public void caseArrayType(ArrayType t) {
                        JasminClass.this.emit("areturn");
                    }

                    public void caseRefType(RefType t) {
                        JasminClass.this.emit("areturn");
                    }

                    public void caseNullType(NullType t) {
                        JasminClass.this.emit("areturn");
                    }
                });
            }

            public void caseNopInst(NopInst i) {
                JasminClass.this.emit("nop");
            }

            public void caseEnterMonitorInst(EnterMonitorInst i) {
                JasminClass.this.emit("monitorenter");
            }

            public void casePopInst(PopInst i) {
                if (i.getWordCount() == 2) {
                    JasminClass.this.emit("pop2");
                } else {
                    JasminClass.this.emit("pop");
                }
            }

            public void caseExitMonitorInst(ExitMonitorInst i) {
                JasminClass.this.emit("monitorexit");
            }

            public void caseGotoInst(GotoInst i) {
                JasminClass.this.emit("goto " + JasminClass.this.instToLabel.get(i.getTarget()));
            }

            public void casePushInst(PushInst i) {
                if (i.getConstant() instanceof IntConstant) {
                    IntConstant v = (IntConstant)i.getConstant();
                    if (v.value == -1) {
                        JasminClass.this.emit("iconst_m1");
                    } else if (v.value >= 0 && v.value <= 5) {
                        JasminClass.this.emit("iconst_" + v.value);
                    } else if (v.value >= -128 && v.value <= 127) {
                        JasminClass.this.emit("bipush " + v.value);
                    } else if (v.value >= Short.MIN_VALUE && v.value <= Short.MAX_VALUE) {
                        JasminClass.this.emit("sipush " + v.value);
                    } else {
                        JasminClass.this.emit("ldc " + v.toString());
                    }
                } else if (i.getConstant() instanceof StringConstant) {
                    JasminClass.this.emit("ldc " + i.getConstant().toString());
                } else if (i.getConstant() instanceof DoubleConstant) {
                    DoubleConstant v = (DoubleConstant)i.getConstant();
                    if (v.value == 0.0) {
                        JasminClass.this.emit("dconst_0");
                    } else if (v.value == 1.0) {
                        JasminClass.this.emit("dconst_1");
                    } else {
                        String s = v.toString();
                        if (s.equals("#Infinity")) {
                            s = "+DoubleInfinity";
                        }
                        if (s.equals("#-Infinity")) {
                            s = "-DoubleInfinity";
                        }
                        if (s.equals("#NaN")) {
                            s = "+DoubleNaN";
                        }
                        JasminClass.this.emit("ldc2_w " + s);
                    }
                } else if (i.getConstant() instanceof FloatConstant) {
                    FloatConstant v = (FloatConstant)i.getConstant();
                    if (v.value == 0.0f) {
                        JasminClass.this.emit("fconst_0");
                    } else if (v.value == 1.0f) {
                        JasminClass.this.emit("fconst_1");
                    } else if (v.value == 2.0f) {
                        JasminClass.this.emit("fconst_2");
                    } else {
                        String s = v.toString();
                        if (s.equals("#InfinityF")) {
                            s = "+FloatInfinity";
                        }
                        if (s.equals("#-InfinityF")) {
                            s = "-FloatInfinity";
                        }
                        if (s.equals("#NaNF")) {
                            s = "+FloatNaN";
                        }
                        JasminClass.this.emit("ldc " + s);
                    }
                } else if (i.getConstant() instanceof LongConstant) {
                    LongConstant v = (LongConstant)i.getConstant();
                    if (v.value == 0L) {
                        JasminClass.this.emit("lconst_0");
                    } else if (v.value == 1L) {
                        JasminClass.this.emit("lconst_1");
                    } else {
                        JasminClass.this.emit("ldc2_w " + v.toString());
                    }
                } else if (i.getConstant() instanceof NullConstant) {
                    JasminClass.this.emit("aconst_null");
                } else {
                    throw new RuntimeException("unsupported opcode");
                }
            }

            public void caseIdentityInst(IdentityInst i) {
                if (i.getRightOp() instanceof CaughtExceptionRef && i.getLeftOp() instanceof Local) {
                    int slot = (Integer)JasminClass.this.localToSlot.get(i.getLeftOp());
                    if (slot >= 0 && slot <= 3) {
                        JasminClass.this.emit("astore_" + slot);
                    } else {
                        JasminClass.this.emit("astore " + slot);
                    }
                }
            }

            public void caseStoreInst(StoreInst i) {
                final int slot = (Integer)JasminClass.this.localToSlot.get(i.getLocal());
                i.getOpType().apply(new TypeSwitch(){

                    public void caseArrayType(ArrayType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("astore_" + slot);
                        } else {
                            JasminClass.this.emit("astore " + slot);
                        }
                    }

                    public void caseDoubleType(DoubleType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("dstore_" + slot);
                        } else {
                            JasminClass.this.emit("dstore " + slot);
                        }
                    }

                    public void caseFloatType(FloatType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("fstore_" + slot);
                        } else {
                            JasminClass.this.emit("fstore " + slot);
                        }
                    }

                    public void caseIntType(IntType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("istore_" + slot);
                        } else {
                            JasminClass.this.emit("istore " + slot);
                        }
                    }

                    public void caseByteType(ByteType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("istore_" + slot);
                        } else {
                            JasminClass.this.emit("istore " + slot);
                        }
                    }

                    public void caseShortType(ShortType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("istore_" + slot);
                        } else {
                            JasminClass.this.emit("istore " + slot);
                        }
                    }

                    public void caseCharType(CharType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("istore_" + slot);
                        } else {
                            JasminClass.this.emit("istore " + slot);
                        }
                    }

                    public void caseBooleanType(BooleanType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("istore_" + slot);
                        } else {
                            JasminClass.this.emit("istore " + slot);
                        }
                    }

                    public void caseLongType(LongType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("lstore_" + slot);
                        } else {
                            JasminClass.this.emit("lstore " + slot);
                        }
                    }

                    public void caseRefType(RefType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("astore_" + slot);
                        } else {
                            JasminClass.this.emit("astore " + slot);
                        }
                    }

                    public void caseStmtAddressType(StmtAddressType t) {
                        JasminClass.this.isNextGotoAJsr = true;
                        JasminClass.this.returnAddressSlot = slot;
                    }

                    public void caseNullType(NullType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("astore_" + slot);
                        } else {
                            JasminClass.this.emit("astore " + slot);
                        }
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid local type:" + t);
                    }
                });
            }

            public void caseLoadInst(LoadInst i) {
                final int slot = (Integer)JasminClass.this.localToSlot.get(i.getLocal());
                i.getOpType().apply(new TypeSwitch(){

                    public void caseArrayType(ArrayType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("aload_" + slot);
                        } else {
                            JasminClass.this.emit("aload " + slot);
                        }
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid local type to load" + t);
                    }

                    public void caseDoubleType(DoubleType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("dload_" + slot);
                        } else {
                            JasminClass.this.emit("dload " + slot);
                        }
                    }

                    public void caseFloatType(FloatType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("fload_" + slot);
                        } else {
                            JasminClass.this.emit("fload " + slot);
                        }
                    }

                    public void caseIntType(IntType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("iload_" + slot);
                        } else {
                            JasminClass.this.emit("iload " + slot);
                        }
                    }

                    public void caseByteType(ByteType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("iload_" + slot);
                        } else {
                            JasminClass.this.emit("iload " + slot);
                        }
                    }

                    public void caseShortType(ShortType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("iload_" + slot);
                        } else {
                            JasminClass.this.emit("iload " + slot);
                        }
                    }

                    public void caseCharType(CharType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("iload_" + slot);
                        } else {
                            JasminClass.this.emit("iload " + slot);
                        }
                    }

                    public void caseBooleanType(BooleanType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("iload_" + slot);
                        } else {
                            JasminClass.this.emit("iload " + slot);
                        }
                    }

                    public void caseLongType(LongType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("lload_" + slot);
                        } else {
                            JasminClass.this.emit("lload " + slot);
                        }
                    }

                    public void caseRefType(RefType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("aload_" + slot);
                        } else {
                            JasminClass.this.emit("aload " + slot);
                        }
                    }

                    public void caseNullType(NullType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("aload_" + slot);
                        } else {
                            JasminClass.this.emit("aload " + slot);
                        }
                    }
                });
            }

            public void caseArrayWriteInst(ArrayWriteInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    public void caseArrayType(ArrayType t) {
                        JasminClass.this.emit("aastore");
                    }

                    public void caseDoubleType(DoubleType t) {
                        JasminClass.this.emit("dastore");
                    }

                    public void caseFloatType(FloatType t) {
                        JasminClass.this.emit("fastore");
                    }

                    public void caseIntType(IntType t) {
                        JasminClass.this.emit("iastore");
                    }

                    public void caseLongType(LongType t) {
                        JasminClass.this.emit("lastore");
                    }

                    public void caseRefType(RefType t) {
                        JasminClass.this.emit("aastore");
                    }

                    public void caseByteType(ByteType t) {
                        JasminClass.this.emit("bastore");
                    }

                    public void caseBooleanType(BooleanType t) {
                        JasminClass.this.emit("bastore");
                    }

                    public void caseCharType(CharType t) {
                        JasminClass.this.emit("castore");
                    }

                    public void caseShortType(ShortType t) {
                        JasminClass.this.emit("sastore");
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid type: " + t);
                    }
                });
            }

            public void caseArrayReadInst(ArrayReadInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    public void caseArrayType(ArrayType ty) {
                        JasminClass.this.emit("aaload");
                    }

                    public void caseBooleanType(BooleanType ty) {
                        JasminClass.this.emit("baload");
                    }

                    public void caseByteType(ByteType ty) {
                        JasminClass.this.emit("baload");
                    }

                    public void caseCharType(CharType ty) {
                        JasminClass.this.emit("caload");
                    }

                    public void defaultCase(Type ty) {
                        throw new RuntimeException("invalid base type");
                    }

                    public void caseDoubleType(DoubleType ty) {
                        JasminClass.this.emit("daload");
                    }

                    public void caseFloatType(FloatType ty) {
                        JasminClass.this.emit("faload");
                    }

                    public void caseIntType(IntType ty) {
                        JasminClass.this.emit("iaload");
                    }

                    public void caseLongType(LongType ty) {
                        JasminClass.this.emit("laload");
                    }

                    public void caseNullType(NullType ty) {
                        JasminClass.this.emit("aaload");
                    }

                    public void caseRefType(RefType ty) {
                        JasminClass.this.emit("aaload");
                    }

                    public void caseShortType(ShortType ty) {
                        JasminClass.this.emit("saload");
                    }
                });
            }

            public void caseIfNullInst(IfNullInst i) {
                JasminClass.this.emit("ifnull " + JasminClass.this.instToLabel.get(i.getTarget()));
            }

            public void caseIfNonNullInst(IfNonNullInst i) {
                JasminClass.this.emit("ifnonnull " + JasminClass.this.instToLabel.get(i.getTarget()));
            }

            public void caseIfEqInst(IfEqInst i) {
                JasminClass.this.emit("ifeq " + JasminClass.this.instToLabel.get(i.getTarget()));
            }

            public void caseIfNeInst(IfNeInst i) {
                JasminClass.this.emit("ifne " + JasminClass.this.instToLabel.get(i.getTarget()));
            }

            public void caseIfGtInst(IfGtInst i) {
                JasminClass.this.emit("ifgt " + JasminClass.this.instToLabel.get(i.getTarget()));
            }

            public void caseIfGeInst(IfGeInst i) {
                JasminClass.this.emit("ifge " + JasminClass.this.instToLabel.get(i.getTarget()));
            }

            public void caseIfLtInst(IfLtInst i) {
                JasminClass.this.emit("iflt " + JasminClass.this.instToLabel.get(i.getTarget()));
            }

            public void caseIfLeInst(IfLeInst i) {
                JasminClass.this.emit("ifle " + JasminClass.this.instToLabel.get(i.getTarget()));
            }

            public void caseIfCmpEqInst(final IfCmpEqInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    public void caseIntType(IntType t) {
                        JasminClass.this.emit("if_icmpeq " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseBooleanType(BooleanType t) {
                        JasminClass.this.emit("if_icmpeq " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseShortType(ShortType t) {
                        JasminClass.this.emit("if_icmpeq " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseCharType(CharType t) {
                        JasminClass.this.emit("if_icmpeq " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseByteType(ByteType t) {
                        JasminClass.this.emit("if_icmpeq " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseDoubleType(DoubleType t) {
                        JasminClass.this.emit("dcmpg");
                        JasminClass.this.emit("ifeq " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseLongType(LongType t) {
                        JasminClass.this.emit("lcmp");
                        JasminClass.this.emit("ifeq " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseFloatType(FloatType t) {
                        JasminClass.this.emit("fcmpg");
                        JasminClass.this.emit("ifeq " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseArrayType(ArrayType t) {
                        JasminClass.this.emit("if_acmpeq " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseRefType(RefType t) {
                        JasminClass.this.emit("if_acmpeq " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseNullType(NullType t) {
                        JasminClass.this.emit("if_acmpeq " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseIfCmpNeInst(final IfCmpNeInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    public void caseIntType(IntType t) {
                        JasminClass.this.emit("if_icmpne " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseBooleanType(BooleanType t) {
                        JasminClass.this.emit("if_icmpne " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseShortType(ShortType t) {
                        JasminClass.this.emit("if_icmpne " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseCharType(CharType t) {
                        JasminClass.this.emit("if_icmpne " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseByteType(ByteType t) {
                        JasminClass.this.emit("if_icmpne " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseDoubleType(DoubleType t) {
                        JasminClass.this.emit("dcmpg");
                        JasminClass.this.emit("ifne " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseLongType(LongType t) {
                        JasminClass.this.emit("lcmp");
                        JasminClass.this.emit("ifne " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseFloatType(FloatType t) {
                        JasminClass.this.emit("fcmpg");
                        JasminClass.this.emit("ifne " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseArrayType(ArrayType t) {
                        JasminClass.this.emit("if_acmpne " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseRefType(RefType t) {
                        JasminClass.this.emit("if_acmpne " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseNullType(NullType t) {
                        JasminClass.this.emit("if_acmpne " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseIfCmpGtInst(final IfCmpGtInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    public void caseIntType(IntType t) {
                        JasminClass.this.emit("if_icmpgt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseBooleanType(BooleanType t) {
                        JasminClass.this.emit("if_icmpgt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseShortType(ShortType t) {
                        JasminClass.this.emit("if_icmpgt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseCharType(CharType t) {
                        JasminClass.this.emit("if_icmpgt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseByteType(ByteType t) {
                        JasminClass.this.emit("if_icmpgt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseDoubleType(DoubleType t) {
                        JasminClass.this.emit("dcmpg");
                        JasminClass.this.emit("ifgt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseLongType(LongType t) {
                        JasminClass.this.emit("lcmp");
                        JasminClass.this.emit("ifgt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseFloatType(FloatType t) {
                        JasminClass.this.emit("fcmpg");
                        JasminClass.this.emit("ifgt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseArrayType(ArrayType t) {
                        JasminClass.this.emit("if_acmpgt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseRefType(RefType t) {
                        JasminClass.this.emit("if_acmpgt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseNullType(NullType t) {
                        JasminClass.this.emit("if_acmpgt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseIfCmpGeInst(final IfCmpGeInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    public void caseIntType(IntType t) {
                        JasminClass.this.emit("if_icmpge " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseBooleanType(BooleanType t) {
                        JasminClass.this.emit("if_icmpge " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseShortType(ShortType t) {
                        JasminClass.this.emit("if_icmpge " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseCharType(CharType t) {
                        JasminClass.this.emit("if_icmpge " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseByteType(ByteType t) {
                        JasminClass.this.emit("if_icmpge " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseDoubleType(DoubleType t) {
                        JasminClass.this.emit("dcmpg");
                        JasminClass.this.emit("ifge " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseLongType(LongType t) {
                        JasminClass.this.emit("lcmp");
                        JasminClass.this.emit("ifge " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseFloatType(FloatType t) {
                        JasminClass.this.emit("fcmpg");
                        JasminClass.this.emit("ifge " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseArrayType(ArrayType t) {
                        JasminClass.this.emit("if_acmpge " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseRefType(RefType t) {
                        JasminClass.this.emit("if_acmpge " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseNullType(NullType t) {
                        JasminClass.this.emit("if_acmpge " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseIfCmpLtInst(final IfCmpLtInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    public void caseIntType(IntType t) {
                        JasminClass.this.emit("if_icmplt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseBooleanType(BooleanType t) {
                        JasminClass.this.emit("if_icmplt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseShortType(ShortType t) {
                        JasminClass.this.emit("if_icmplt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseCharType(CharType t) {
                        JasminClass.this.emit("if_icmplt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseByteType(ByteType t) {
                        JasminClass.this.emit("if_icmplt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseDoubleType(DoubleType t) {
                        JasminClass.this.emit("dcmpg");
                        JasminClass.this.emit("iflt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseLongType(LongType t) {
                        JasminClass.this.emit("lcmp");
                        JasminClass.this.emit("iflt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseFloatType(FloatType t) {
                        JasminClass.this.emit("fcmpg");
                        JasminClass.this.emit("iflt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseArrayType(ArrayType t) {
                        JasminClass.this.emit("if_acmplt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseRefType(RefType t) {
                        JasminClass.this.emit("if_acmplt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseNullType(NullType t) {
                        JasminClass.this.emit("if_acmplt " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseIfCmpLeInst(final IfCmpLeInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    public void caseIntType(IntType t) {
                        JasminClass.this.emit("if_icmple " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseBooleanType(BooleanType t) {
                        JasminClass.this.emit("if_icmple " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseShortType(ShortType t) {
                        JasminClass.this.emit("if_icmple " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseCharType(CharType t) {
                        JasminClass.this.emit("if_icmple " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseByteType(ByteType t) {
                        JasminClass.this.emit("if_icmple " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseDoubleType(DoubleType t) {
                        JasminClass.this.emit("dcmpg");
                        JasminClass.this.emit("ifle " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseLongType(LongType t) {
                        JasminClass.this.emit("lcmp");
                        JasminClass.this.emit("ifle " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseFloatType(FloatType t) {
                        JasminClass.this.emit("fcmpg");
                        JasminClass.this.emit("ifle " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseArrayType(ArrayType t) {
                        JasminClass.this.emit("if_acmple " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseRefType(RefType t) {
                        JasminClass.this.emit("if_acmple " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void caseNullType(NullType t) {
                        JasminClass.this.emit("if_acmple " + JasminClass.this.instToLabel.get(i.getTarget()));
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseStaticGetInst(StaticGetInst i) {
                SootField field = i.getField();
                JasminClass.this.emit("getstatic " + JasminClass.this.slashify(field.getDeclaringClass().getName()) + "/" + field.getName() + " " + JasminClass.this.jasminDescriptorOf(field.getType()));
            }

            public void caseStaticPutInst(StaticPutInst i) {
                JasminClass.this.emit("putstatic " + JasminClass.this.slashify(i.getField().getDeclaringClass().getName()) + "/" + i.getField().getName() + " " + JasminClass.this.jasminDescriptorOf(i.getField().getType()));
            }

            public void caseFieldGetInst(FieldGetInst i) {
                JasminClass.this.emit("getfield " + JasminClass.this.slashify(i.getField().getDeclaringClass().getName()) + "/" + i.getField().getName() + " " + JasminClass.this.jasminDescriptorOf(i.getField().getType()));
            }

            public void caseFieldPutInst(FieldPutInst i) {
                JasminClass.this.emit("putfield " + JasminClass.this.slashify(i.getField().getDeclaringClass().getName()) + "/" + i.getField().getName() + " " + JasminClass.this.jasminDescriptorOf(i.getField().getType()));
            }

            public void caseInstanceCastInst(InstanceCastInst i) {
                Type castType = i.getCastType();
                if (castType instanceof RefType) {
                    JasminClass.this.emit("checkcast " + JasminClass.this.slashify(castType.toString()));
                } else if (castType instanceof ArrayType) {
                    JasminClass.this.emit("checkcast " + JasminClass.this.jasminDescriptorOf(castType));
                }
            }

            public void caseInstanceOfInst(InstanceOfInst i) {
                Type checkType = i.getCheckType();
                if (checkType instanceof RefType) {
                    JasminClass.this.emit("instanceof " + JasminClass.this.slashify(checkType.toString()));
                } else if (checkType instanceof ArrayType) {
                    JasminClass.this.emit("instanceof " + JasminClass.this.jasminDescriptorOf(checkType));
                }
            }

            public void caseNewInst(NewInst i) {
                JasminClass.this.emit("new " + JasminClass.this.slashify(i.getBaseType().toString()));
            }

            public void casePrimitiveCastInst(PrimitiveCastInst i) {
                JasminClass.this.emit(i.toString());
            }

            public void caseStaticInvokeInst(StaticInvokeInst i) {
                SootMethod m = i.getMethod();
                JasminClass.this.emit("invokestatic " + JasminClass.this.slashify(m.getDeclaringClass().getName()) + "/" + m.getName() + JasminClass.this.jasminDescriptorOf(m));
            }

            public void caseVirtualInvokeInst(VirtualInvokeInst i) {
                SootMethod m = i.getMethod();
                JasminClass.this.emit("invokevirtual " + JasminClass.this.slashify(m.getDeclaringClass().getName()) + "/" + m.getName() + JasminClass.this.jasminDescriptorOf(m));
            }

            public void caseInterfaceInvokeInst(InterfaceInvokeInst i) {
                SootMethod m = i.getMethod();
                JasminClass.this.emit("invokeinterface " + JasminClass.this.slashify(m.getDeclaringClass().getName()) + "/" + m.getName() + JasminClass.this.jasminDescriptorOf(m) + " " + (JasminClass.this.argCountOf(m) + 1));
            }

            public void caseSpecialInvokeInst(SpecialInvokeInst i) {
                SootMethod m = i.getMethod();
                JasminClass.this.emit("invokespecial " + JasminClass.this.slashify(m.getDeclaringClass().getName()) + "/" + m.getName() + JasminClass.this.jasminDescriptorOf(m));
            }

            public void caseThrowInst(ThrowInst i) {
                JasminClass.this.emit("athrow");
            }

            public void caseCmpInst(CmpInst i) {
                JasminClass.this.emit("lcmp");
            }

            public void caseCmplInst(CmplInst i) {
                if (i.getOpType().equals(FloatType.v())) {
                    JasminClass.this.emit("fcmpl");
                } else {
                    JasminClass.this.emit("dcmpl");
                }
            }

            public void caseCmpgInst(CmpgInst i) {
                if (i.getOpType().equals(FloatType.v())) {
                    JasminClass.this.emit("fcmpg");
                } else {
                    JasminClass.this.emit("dcmpg");
                }
            }

            private void emitOpTypeInst(final String s, OpTypeArgInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    private void handleIntCase() {
                        JasminClass.this.emit("i" + s);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        JasminClass.this.emit("l" + s);
                    }

                    public void caseDoubleType(DoubleType t) {
                        JasminClass.this.emit("d" + s);
                    }

                    public void caseFloatType(FloatType t) {
                        JasminClass.this.emit("f" + s);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for div");
                    }
                });
            }

            public void caseAddInst(AddInst i) {
                this.emitOpTypeInst("add", i);
            }

            public void caseDivInst(DivInst i) {
                this.emitOpTypeInst("div", i);
            }

            public void caseSubInst(SubInst i) {
                this.emitOpTypeInst("sub", i);
            }

            public void caseMulInst(MulInst i) {
                this.emitOpTypeInst("mul", i);
            }

            public void caseRemInst(RemInst i) {
                this.emitOpTypeInst("rem", i);
            }

            public void caseShlInst(ShlInst i) {
                this.emitOpTypeInst("shl", i);
            }

            public void caseAndInst(AndInst i) {
                this.emitOpTypeInst("and", i);
            }

            public void caseOrInst(OrInst i) {
                this.emitOpTypeInst("or", i);
            }

            public void caseXorInst(XorInst i) {
                this.emitOpTypeInst("xor", i);
            }

            public void caseShrInst(ShrInst i) {
                this.emitOpTypeInst("shr", i);
            }

            public void caseUshrInst(UshrInst i) {
                this.emitOpTypeInst("ushr", i);
            }

            public void caseIncInst(IncInst i) {
                if (((ValueBox)i.getUseBoxes().get(0)).getValue() != ((ValueBox)i.getDefBoxes().get(0)).getValue()) {
                    throw new RuntimeException("iinc def and use boxes don't match");
                }
                JasminClass.this.emit("iinc " + (Integer)JasminClass.this.localToSlot.get(i.getLocal()) + " " + i.getConstant());
            }

            public void caseArrayLengthInst(ArrayLengthInst i) {
                JasminClass.this.emit("arraylength");
            }

            public void caseNegInst(NegInst i) {
                this.emitOpTypeInst("neg", i);
            }

            public void caseNewArrayInst(NewArrayInst i) {
                if (i.getBaseType() instanceof RefType) {
                    JasminClass.this.emit("anewarray " + JasminClass.this.slashify(i.getBaseType().toString()));
                } else if (i.getBaseType() instanceof ArrayType) {
                    JasminClass.this.emit("anewarray " + JasminClass.this.jasminDescriptorOf(i.getBaseType()));
                } else {
                    JasminClass.this.emit("newarray " + i.getBaseType().toString());
                }
            }

            public void caseNewMultiArrayInst(NewMultiArrayInst i) {
                JasminClass.this.emit("multianewarray " + JasminClass.this.jasminDescriptorOf(i.getBaseType()) + " " + i.getDimensionCount());
            }

            public void caseLookupSwitchInst(LookupSwitchInst i) {
                JasminClass.this.emit("lookupswitch");
                List lookupValues = i.getLookupValues();
                List targets = i.getTargets();
                for (int j = 0; j < lookupValues.size(); ++j) {
                    JasminClass.this.emit("  " + lookupValues.get(j) + " : " + JasminClass.this.instToLabel.get(targets.get(j)));
                }
                JasminClass.this.emit("  default : " + JasminClass.this.instToLabel.get(i.getDefaultTarget()));
            }

            public void caseTableSwitchInst(TableSwitchInst i) {
                JasminClass.this.emit("tableswitch " + i.getLowIndex() + " ; high = " + i.getHighIndex());
                List targets = i.getTargets();
                for (int j = 0; j < targets.size(); ++j) {
                    JasminClass.this.emit("  " + JasminClass.this.instToLabel.get(targets.get(j)));
                }
                JasminClass.this.emit("default : " + JasminClass.this.instToLabel.get(i.getDefaultTarget()));
            }

            public void caseDup1Inst(Dup1Inst i) {
                Type firstOpType = i.getOp1Type();
                if (firstOpType instanceof LongType || firstOpType instanceof DoubleType) {
                    JasminClass.this.emit("dup2");
                } else {
                    JasminClass.this.emit("dup");
                }
            }

            public void caseDup2Inst(Dup2Inst i) {
                Type firstOpType = i.getOp1Type();
                Type secondOpType = i.getOp2Type();
                if (firstOpType instanceof LongType || firstOpType instanceof DoubleType) {
                    JasminClass.this.emit("dup2");
                    if (secondOpType instanceof LongType || secondOpType instanceof DoubleType) {
                        JasminClass.this.emit("dup2");
                    } else {
                        JasminClass.this.emit("dup");
                    }
                } else if (secondOpType instanceof LongType || secondOpType instanceof DoubleType) {
                    if (firstOpType instanceof LongType || firstOpType instanceof DoubleType) {
                        JasminClass.this.emit("dup2");
                    } else {
                        JasminClass.this.emit("dup");
                    }
                    JasminClass.this.emit("dup2");
                } else {
                    G.v().out.println("3000:(JasminClass): dup2 created");
                    JasminClass.this.emit("dup2");
                }
            }

            public void caseDup1_x1Inst(Dup1_x1Inst i) {
                Type opType = i.getOp1Type();
                Type underType = i.getUnder1Type();
                if (opType instanceof LongType || opType instanceof DoubleType) {
                    if (underType instanceof LongType || underType instanceof DoubleType) {
                        JasminClass.this.emit("dup2_x2");
                    } else {
                        JasminClass.this.emit("dup2_x1");
                    }
                } else if (underType instanceof LongType || underType instanceof DoubleType) {
                    JasminClass.this.emit("dup_x2");
                } else {
                    JasminClass.this.emit("dup_x1");
                }
            }

            public void caseDup1_x2Inst(Dup1_x2Inst i) {
                throw new RuntimeException("undifined");
            }

            public void caseDup2_x1Inst(Dup2_x1Inst i) {
                throw new RuntimeException("undifined");
            }

            public void caseDup2_x2Inst(Dup2_x2Inst i) {
                throw new RuntimeException("undifined");
            }

            public void caseSwapInst(SwapInst i) {
                JasminClass.this.emit("swap");
            }
        });
    }

    private void calculateStackHeight(Block aBlock) {
        Iterator it = aBlock.iterator();
        int blockHeight = (Integer)this.blockToStackHeight.get(aBlock);
        while (it.hasNext()) {
            Inst nInst = (Inst)it.next();
            if ((blockHeight -= nInst.getInMachineCount()) < 0) {
                throw new RuntimeException("Negative Stack height has been attained: \nStackHeight: " + blockHeight + "\n" + "At instruction:" + nInst + "\n" + "Block:\n" + aBlock + "\n\nMethod: " + aBlock.getBody().getMethod().getName() + "\n" + aBlock.getBody().getMethod());
            }
            if ((blockHeight += nInst.getOutMachineCount()) <= this.maxStackHeight) continue;
            this.maxStackHeight = blockHeight;
        }
        for (Block b : aBlock.getSuccs()) {
            Integer i = (Integer)this.blockToStackHeight.get(b);
            if (i != null) {
                if (i == blockHeight) continue;
                throw new RuntimeException("incoherent stack height at block merge point " + b + aBlock);
            }
            this.blockToStackHeight.put(b, new Integer(blockHeight));
            this.calculateStackHeight(b);
        }
    }

    private void calculateLogicalStackHeightCheck(Block aBlock) {
        Iterator it = aBlock.iterator();
        int blockHeight = (Integer)this.blockToLogicalStackHeight.get(aBlock);
        while (it.hasNext()) {
            Inst nInst = (Inst)it.next();
            if ((blockHeight -= nInst.getInCount()) < 0) {
                throw new RuntimeException("Negative Stack Logical height has been attained: \nStackHeight: " + blockHeight + "\nAt instruction:" + nInst + "\nBlock:\n" + aBlock + "\n\nMethod: " + aBlock.getBody().getMethod().getName() + "\n" + aBlock.getBody().getMethod());
            }
            blockHeight += nInst.getOutCount();
        }
        for (Block b : aBlock.getSuccs()) {
            Integer i = (Integer)this.blockToLogicalStackHeight.get(b);
            if (i != null) {
                if (i == blockHeight) continue;
                throw new RuntimeException("incoherent logical stack height at block merge point " + b + aBlock);
            }
            this.blockToLogicalStackHeight.put(b, new Integer(blockHeight));
            this.calculateLogicalStackHeightCheck(b);
        }
    }
}

