/*
 * Decompiled with CFR 0.152.
 */
package soot.baf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import soot.Body;
import soot.DoubleType;
import soot.G;
import soot.Local;
import soot.LongType;
import soot.PackManager;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.UnitBox;
import soot.UnknownType;
import soot.baf.Baf;
import soot.baf.DoubleWordType;
import soot.baf.PlaceholderInst;
import soot.baf.WordType;
import soot.jimple.ConvertToBaf;
import soot.jimple.JimpleBody;
import soot.jimple.JimpleToBafContext;
import soot.jimple.Stmt;
import soot.options.Options;

public class BafBody
extends Body {
    public Object clone() {
        BafBody b = new BafBody(this.getMethod());
        b.importBodyContentsFrom(this);
        return b;
    }

    BafBody(SootMethod m) {
        super(m);
    }

    public BafBody(Body body, Map options) {
        super(body.getMethod());
        if (Options.v().verbose()) {
            G.v().out.println("[" + this.getMethod().getName() + "] Constructing BafBody...");
        }
        if (!(body instanceof JimpleBody)) {
            throw new RuntimeException("Can only construct BafBody's directly from JimpleBody's.");
        }
        JimpleBody jimpleBody = (JimpleBody)body;
        jimpleBody.validate();
        JimpleToBafContext context = new JimpleToBafContext(jimpleBody.getLocalCount());
        for (Local l : jimpleBody.getLocals()) {
            Type t = l.getType();
            Local newLocal = Baf.v().newLocal(l.getName(), UnknownType.v());
            if (t.equals(DoubleType.v()) || t.equals(LongType.v())) {
                newLocal.setType(DoubleWordType.v());
            } else {
                newLocal.setType(WordType.v());
            }
            context.setBafLocalOfJimpleLocal(l, newLocal);
            this.getLocals().add(newLocal);
        }
        HashMap stmtToFirstInstruction = new HashMap();
        for (Stmt s : jimpleBody.getUnits()) {
            ArrayList conversionList = new ArrayList();
            context.setCurrentUnit(s);
            ((ConvertToBaf)((Object)s)).convertToBaf(context, conversionList);
            stmtToFirstInstruction.put(s, conversionList.get(0));
            this.getUnits().addAll(conversionList);
        }
        for (UnitBox box : this.getAllUnitBoxes()) {
            if (!(box.getUnit() instanceof PlaceholderInst)) continue;
            Unit source = ((PlaceholderInst)box.getUnit()).getSource();
            box.setUnit((Unit)stmtToFirstInstruction.get(source));
        }
        for (Trap trap : jimpleBody.getTraps()) {
            this.getTraps().add(Baf.v().newTrap(trap.getException(), (Unit)stmtToFirstInstruction.get(trap.getBeginUnit()), (Unit)stmtToFirstInstruction.get(trap.getEndUnit()), (Unit)stmtToFirstInstruction.get(trap.getHandlerUnit())));
        }
        PackManager.v().getPack("bb").apply(this);
    }
}

