/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import soot.Body;
import soot.Hierarchy;
import soot.PatchingChain;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.Trap;
import soot.Unit;
import soot.util.Chain;

public class TrapManager {
    public static boolean isExceptionCaughtAt(SootClass e, Unit u, Body b) {
        Hierarchy h = Scene.v().getActiveHierarchy();
        PatchingChain units = b.getUnits();
        for (Trap t : b.getTraps()) {
            if (!h.isClassSubclassOfIncluding(e, t.getException())) continue;
            Iterator it = units.iterator(t.getBeginUnit(), units.getPredOf(t.getEndUnit()));
            while (it.hasNext()) {
                if (!u.equals(it.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static List getTrapsAt(Unit unit, Body b) {
        ArrayList<Trap> trapsList = new ArrayList<Trap>();
        PatchingChain units = b.getUnits();
        for (Trap t : b.getTraps()) {
            Iterator it = units.iterator(t.getBeginUnit(), units.getPredOf(t.getEndUnit()));
            while (it.hasNext()) {
                if (!unit.equals(it.next())) continue;
                trapsList.add(t);
            }
        }
        return trapsList;
    }

    public static Set getTrappedUnitsOf(Body b) {
        HashSet trapsSet = new HashSet();
        PatchingChain units = b.getUnits();
        for (Trap t : b.getTraps()) {
            Iterator it = units.iterator(t.getBeginUnit(), units.getPredOf(t.getEndUnit()));
            while (it.hasNext()) {
                trapsSet.add(it.next());
            }
        }
        return trapsSet;
    }

    public static void splitTrapsAgainst(Body b, Unit rangeStart, Unit rangeEnd) {
        Chain traps = b.getTraps();
        PatchingChain units = b.getUnits();
        Iterator trapsIt = traps.snapshotIterator();
        block0: while (trapsIt.hasNext()) {
            Trap t = (Trap)trapsIt.next();
            Iterator unitIt = units.iterator(t.getBeginUnit(), t.getEndUnit());
            boolean insideRange = false;
            while (unitIt.hasNext()) {
                Unit u = (Unit)unitIt.next();
                if (u.equals(rangeStart)) {
                    insideRange = true;
                }
                if (!unitIt.hasNext()) {
                    if (!insideRange) continue block0;
                    Trap newTrap = (Trap)t.clone();
                    t.setBeginUnit(rangeStart);
                    newTrap.setEndUnit(rangeStart);
                    traps.insertAfter(newTrap, (Object)t);
                }
                if (!u.equals(rangeEnd)) continue;
                if (!insideRange) {
                    throw new RuntimeException("inversed range?");
                }
                Trap firstTrap = (Trap)t.clone();
                Trap secondTrap = (Trap)t.clone();
                firstTrap.setEndUnit(rangeStart);
                secondTrap.setBeginUnit(rangeStart);
                secondTrap.setEndUnit(rangeEnd);
                t.setBeginUnit(rangeEnd);
                traps.insertAfter(firstTrap, (Object)t);
                traps.insertAfter(secondTrap, (Object)t);
            }
        }
    }

    public static List getExceptionTypesOf(Unit u, Body body) {
        ArrayList<RefType> possibleTypes = new ArrayList<RefType>();
        for (Trap trap : body.getTraps()) {
            Unit handler = trap.getHandlerUnit();
            if (handler != u) continue;
            possibleTypes.add(RefType.v(trap.getException().getName()));
        }
        return possibleTypes;
    }
}

