/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.FastHierarchy;
import soot.G;
import soot.Hierarchy;
import soot.PointsToAnalysis;
import soot.RefType;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootResolver;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.EntryPoints;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.jimple.toolkits.pointer.DumbPointerAnalysis;
import soot.jimple.toolkits.pointer.SideEffectAnalysis;
import soot.options.Options;
import soot.util.Chain;
import soot.util.HashChain;
import soot.util.Numberer;
import soot.util.SourceLocator;
import soot.util.StringNumberer;

public class Scene {
    Chain classes = new HashChain();
    Chain applicationClasses = new HashChain();
    Chain libraryClasses = new HashChain();
    Chain phantomClasses = new HashChain();
    private Map nameToClass = new HashMap();
    Numberer typeNumberer = new Numberer();
    Numberer methodNumberer = new Numberer();
    Numberer fieldNumberer = new Numberer();
    Numberer classNumberer = new Numberer();
    StringNumberer subSigNumberer = new StringNumberer();
    Numberer localNumberer = new Numberer();
    private Hierarchy activeHierarchy;
    private FastHierarchy activeFastHierarchy;
    private CallGraph activeCallGraph;
    private ReachableMethods reachableMethods;
    private PointsToAnalysis activePointsToAnalysis;
    private SideEffectAnalysis activeSideEffectAnalysis;
    private List entryPoints;
    boolean allowsPhantomRefs = false;
    SootClass mainClass;
    String sootClassPath = null;
    Set reservedNames = new HashSet();
    private int stateCount;

    public Scene(Singletons.Global g) {
        this.setReservedNames();
        String scp = System.getProperty("soot.class.path");
        if (scp != null) {
            this.setSootClassPath(scp);
        }
    }

    public static Scene v() {
        return G.v().Scene();
    }

    public void setMainClass(SootClass m) {
        this.mainClass = m;
    }

    public Set getReservedNames() {
        return this.reservedNames;
    }

    public String quotedNameOf(String s) {
        if (this.reservedNames.contains(s)) {
            return "'" + s + "'";
        }
        return s;
    }

    public SootClass getMainClass() {
        if (this.mainClass == null) {
            throw new RuntimeException("There is no main class set!");
        }
        return this.mainClass;
    }

    public void setSootClassPath(String p) {
        this.sootClassPath = p;
    }

    public String getSootClassPath() {
        String optionscp;
        if (this.sootClassPath == null && (optionscp = Options.v().soot_classpath()).length() > 0) {
            this.sootClassPath = optionscp;
        }
        return this.sootClassPath;
    }

    public int getState() {
        return this.stateCount;
    }

    private void modifyHierarchy() {
        ++this.stateCount;
        this.activeFastHierarchy = null;
        this.activeSideEffectAnalysis = null;
        this.activePointsToAnalysis = null;
    }

    public void addClass(SootClass c) {
        if (c.isInScene()) {
            throw new RuntimeException("already managed: " + c.getName());
        }
        if (this.containsClass(c.getName())) {
            throw new RuntimeException("duplicate class: " + c.getName());
        }
        this.classes.add(c);
        c.setLibraryClass();
        this.nameToClass.put(c.getName(), c.getType());
        c.getType().setSootClass(c);
        c.setInScene(true);
        this.modifyHierarchy();
    }

    public void removeClass(SootClass c) {
        if (!c.isInScene()) {
            throw new RuntimeException();
        }
        this.classes.remove(c);
        c.getType().setSootClass(null);
        c.setInScene(false);
        this.modifyHierarchy();
    }

    public boolean containsClass(String className) {
        RefType type = (RefType)this.nameToClass.get(className);
        if (type == null) {
            return false;
        }
        SootClass c = type.getSootClass();
        if (c == null) {
            return false;
        }
        return c.isInScene();
    }

    public String signatureToClass(String sig) {
        if (sig.charAt(0) != '<') {
            throw new RuntimeException("oops " + sig);
        }
        if (sig.charAt(sig.length() - 1) != '>') {
            throw new RuntimeException("oops " + sig);
        }
        int index = sig.indexOf(":");
        if (index < 0) {
            throw new RuntimeException("oops " + sig);
        }
        return sig.substring(1, index);
    }

    public String signatureToSubsignature(String sig) {
        if (sig.charAt(0) != '<') {
            throw new RuntimeException("oops " + sig);
        }
        if (sig.charAt(sig.length() - 1) != '>') {
            throw new RuntimeException("oops " + sig);
        }
        int index = sig.indexOf(":");
        if (index < 0) {
            throw new RuntimeException("oops " + sig);
        }
        return sig.substring(index + 2, sig.length() - 1);
    }

    private SootField grabField(String fieldSignature) {
        String cname = this.signatureToClass(fieldSignature);
        String fname = this.signatureToSubsignature(fieldSignature);
        if (!this.containsClass(cname)) {
            return null;
        }
        SootClass c = this.getSootClass(cname);
        if (!c.declaresField(fname)) {
            return null;
        }
        return c.getField(fname);
    }

    public boolean containsField(String fieldSignature) {
        return this.grabField(fieldSignature) != null;
    }

    private SootMethod grabMethod(String methodSignature) {
        String cname = this.signatureToClass(methodSignature);
        String mname = this.signatureToSubsignature(methodSignature);
        if (!this.containsClass(cname)) {
            return null;
        }
        SootClass c = this.getSootClass(cname);
        if (!c.declaresMethod(mname)) {
            return null;
        }
        return c.getMethod(mname);
    }

    public boolean containsMethod(String methodSignature) {
        return this.grabMethod(methodSignature) != null;
    }

    public SootField getField(String fieldSignature) {
        SootField f = this.grabField(fieldSignature);
        if (f != null) {
            return f;
        }
        throw new RuntimeException("tried to get nonexistent field " + fieldSignature);
    }

    public SootMethod getMethod(String methodSignature) {
        SootMethod m = this.grabMethod(methodSignature);
        if (m != null) {
            return m;
        }
        throw new RuntimeException("tried to get nonexistent method " + methodSignature);
    }

    public SootClass loadClassAndSupport(String className) {
        Scene.v().setPhantomRefs(true);
        SootResolver resolver = new SootResolver();
        SootClass toReturn = resolver.resolveClassAndSupportClasses(className);
        Scene.v().setPhantomRefs(false);
        return toReturn;
    }

    public RefType getRefType(String className) {
        return (RefType)this.nameToClass.get(className);
    }

    public void addRefType(RefType type) {
        this.nameToClass.put(type.getClassName(), type);
    }

    public SootClass getSootClass(String className) {
        RefType type = (RefType)this.nameToClass.get(className);
        SootClass toReturn = null;
        if (type != null) {
            toReturn = type.getSootClass();
        }
        if (toReturn != null) {
            return toReturn;
        }
        if (Scene.v().allowsPhantomRefs()) {
            SootClass c = new SootClass(className);
            c.setPhantom(true);
            this.addClass(c);
            return c;
        }
        throw new RuntimeException(System.getProperty("line.separator") + "Aborting: can't find classfile" + className);
    }

    public Chain getClasses() {
        return this.classes;
    }

    public Chain getApplicationClasses() {
        return this.applicationClasses;
    }

    public Chain getLibraryClasses() {
        return this.libraryClasses;
    }

    public Chain getPhantomClasses() {
        return this.phantomClasses;
    }

    Chain getContainingChain(SootClass c) {
        if (c.isApplicationClass()) {
            return this.getApplicationClasses();
        }
        if (c.isLibraryClass()) {
            return this.getLibraryClasses();
        }
        if (c.isPhantomClass()) {
            return this.getPhantomClasses();
        }
        return null;
    }

    public SideEffectAnalysis getSideEffectAnalysis() {
        if (!this.hasSideEffectAnalysis()) {
            this.setSideEffectAnalysis(new SideEffectAnalysis(this.getPointsToAnalysis(), this.getCallGraph()));
        }
        return this.activeSideEffectAnalysis;
    }

    public void setSideEffectAnalysis(SideEffectAnalysis sea) {
        this.activeSideEffectAnalysis = sea;
    }

    public boolean hasSideEffectAnalysis() {
        return this.activeSideEffectAnalysis != null;
    }

    public void releaseSideEffectAnalysis() {
        this.activeSideEffectAnalysis = null;
    }

    public PointsToAnalysis getPointsToAnalysis() {
        if (!this.hasPointsToAnalysis()) {
            return DumbPointerAnalysis.v();
        }
        return this.activePointsToAnalysis;
    }

    public void setPointsToAnalysis(PointsToAnalysis pa) {
        this.activePointsToAnalysis = pa;
    }

    public boolean hasPointsToAnalysis() {
        return this.activePointsToAnalysis != null;
    }

    public void releasePointsToAnalysis() {
        this.activePointsToAnalysis = null;
    }

    public FastHierarchy getOrMakeFastHierarchy() {
        if (!this.hasFastHierarchy()) {
            this.setFastHierarchy(new FastHierarchy());
        }
        return this.getFastHierarchy();
    }

    public FastHierarchy getFastHierarchy() {
        if (!this.hasFastHierarchy()) {
            throw new RuntimeException("no active FastHierarchy present for scene");
        }
        return this.activeFastHierarchy;
    }

    public void setFastHierarchy(FastHierarchy hierarchy) {
        this.activeFastHierarchy = hierarchy;
    }

    public boolean hasFastHierarchy() {
        return this.activeFastHierarchy != null;
    }

    public void releaseFastHierarchy() {
        this.activeFastHierarchy = null;
    }

    public Hierarchy getActiveHierarchy() {
        if (!this.hasActiveHierarchy()) {
            this.setActiveHierarchy(new Hierarchy());
        }
        return this.activeHierarchy;
    }

    public void setActiveHierarchy(Hierarchy hierarchy) {
        this.activeHierarchy = hierarchy;
    }

    public boolean hasActiveHierarchy() {
        return this.activeHierarchy != null;
    }

    public void releaseActiveHierarchy() {
        this.activeHierarchy = null;
    }

    public List getEntryPoints() {
        if (this.entryPoints == null) {
            this.entryPoints = EntryPoints.v().all();
        }
        return this.entryPoints;
    }

    public void setEntryPoints(List entryPoints) {
        this.entryPoints = entryPoints;
    }

    public CallGraph getCallGraph() {
        if (!this.hasCallGraph()) {
            throw new RuntimeException("No call graph present in Scene. Maybe you want Whole Program mode (-w).");
        }
        return this.activeCallGraph;
    }

    public void setCallGraph(CallGraph cg) {
        this.reachableMethods = null;
        this.activeCallGraph = cg;
    }

    public boolean hasCallGraph() {
        return this.activeCallGraph != null;
    }

    public void releaseCallGraph() {
        this.activeCallGraph = null;
        this.reachableMethods = null;
    }

    public ReachableMethods getReachableMethods() {
        if (this.reachableMethods == null) {
            this.reachableMethods = new ReachableMethods(this.getCallGraph(), this.getEntryPoints());
        }
        this.reachableMethods.update();
        return this.reachableMethods;
    }

    public void setReachableMethods(ReachableMethods rm) {
        this.reachableMethods = rm;
    }

    public boolean hasReachableMethods() {
        return this.reachableMethods != null;
    }

    public void releaseReachableMethods() {
        this.reachableMethods = null;
    }

    public boolean getPhantomRefs() {
        if (!Options.v().allow_phantom_refs()) {
            return false;
        }
        return this.allowsPhantomRefs;
    }

    public void setPhantomRefs(boolean value) {
        this.allowsPhantomRefs = value;
    }

    public boolean allowsPhantomRefs() {
        return this.getPhantomRefs();
    }

    public Numberer getTypeNumberer() {
        return this.typeNumberer;
    }

    public Numberer getMethodNumberer() {
        return this.methodNumberer;
    }

    public Numberer getFieldNumberer() {
        return this.fieldNumberer;
    }

    public Numberer getClassNumberer() {
        return this.classNumberer;
    }

    public StringNumberer getSubSigNumberer() {
        return this.subSigNumberer;
    }

    public Numberer getLocalNumberer() {
        return this.localNumberer;
    }

    private void setReservedNames() {
        Set rn = this.getReservedNames();
        rn.add("newarray");
        rn.add("newmultiarray");
        rn.add("nop");
        rn.add("ret");
        rn.add("specialinvoke");
        rn.add("staticinvoke");
        rn.add("tableswitch");
        rn.add("virtualinvoke");
        rn.add("null_type");
        rn.add("unknown");
        rn.add("cmp");
        rn.add("cmpg");
        rn.add("cmpl");
        rn.add("entermonitor");
        rn.add("exitmonitor");
        rn.add("interfaceinvoke");
        rn.add("lengthof");
        rn.add("lookupswitch");
        rn.add("neg");
        rn.add("if");
        rn.add("abstract");
        rn.add("boolean");
        rn.add("break");
        rn.add("byte");
        rn.add("case");
        rn.add("catch");
        rn.add("char");
        rn.add("class");
        rn.add("final");
        rn.add("native");
        rn.add("public");
        rn.add("protected");
        rn.add("private");
        rn.add("static");
        rn.add("synchronized");
        rn.add("transient");
        rn.add("volatile");
        rn.add("interface");
        rn.add("void");
        rn.add("short");
        rn.add("int");
        rn.add("long");
        rn.add("float");
        rn.add("double");
        rn.add("extends");
        rn.add("implements");
        rn.add("breakpoint");
        rn.add("default");
        rn.add("goto");
        rn.add("instanceof");
        rn.add("new");
        rn.add("return");
        rn.add("throw");
        rn.add("throws");
        rn.add("null");
        rn.add("from");
        rn.add("to");
    }

    public void loadNecessaryClasses() {
        for (String name : Options.v().classes()) {
            SootClass c = Scene.v().loadClassAndSupport(name);
            if (this.mainClass == null) {
                this.mainClass = c;
                Scene.v().setMainClass(c);
            }
            c.setApplicationClass();
        }
        HashSet dynClasses = new HashSet();
        dynClasses.addAll(Options.v().dynamic_class());
        for (String path : Options.v().dynamic_dir()) {
            dynClasses.addAll(SourceLocator.v().getClassesUnder(path));
        }
        for (String pkg : Options.v().dynamic_package()) {
            dynClasses.addAll(SourceLocator.v().classesInDynamicPackage(pkg));
        }
        for (String className : dynClasses) {
            Scene.v().loadClassAndSupport(className);
        }
        for (String path : Options.v().process_dir()) {
            for (String cl : SourceLocator.v().getClassesUnder(path)) {
                Scene.v().loadClassAndSupport(cl).setApplicationClass();
            }
        }
        this.prepareClasses();
    }

    private void prepareClasses() {
        LinkedList<String> excludedPackages = new LinkedList<String>();
        if (Options.v().exclude() != null) {
            excludedPackages.addAll(Options.v().exclude());
        }
        if (!Options.v().include_all()) {
            excludedPackages.add("java.");
            excludedPackages.add("sun.");
            excludedPackages.add("javax.");
            excludedPackages.add("com.sun.");
            excludedPackages.add("com.ibm.");
            excludedPackages.add("org.xml.");
            excludedPackages.add("org.w3c.");
            excludedPackages.add("org.apache.");
        }
        for (SootClass s : Scene.v().getClasses()) {
            if (s.isPhantom()) continue;
            if (Options.v().app()) {
                s.setApplicationClass();
            }
            if (Options.v().classes().contains(s.getName())) {
                s.setApplicationClass();
                continue;
            }
            for (String pkg : excludedPackages) {
                if (!s.isApplicationClass() || !s.getPackageName().startsWith(pkg)) continue;
                s.setLibraryClass();
            }
            for (String pkg : Options.v().include()) {
                if (!s.getPackageName().startsWith(pkg)) continue;
                s.setApplicationClass();
            }
        }
    }
}

