/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import soot.Unit;
import soot.util.Chain;

public class PatchingChain
extends AbstractCollection
implements Chain {
    protected Chain innerChain;

    public PatchingChain(Chain aChain) {
        this.innerChain = aChain;
    }

    public Chain getNonPatchingChain() {
        return this.innerChain;
    }

    public boolean add(Object o) {
        return this.innerChain.add(o);
    }

    public void swapWith(Object out, Object in) {
        this.insertBefore(in, out);
        this.remove(out);
    }

    public void insertAfter(Object toInsert, Object point) {
        this.innerChain.insertAfter(toInsert, point);
    }

    public void insertAfter(List toInsert, Object point) {
        this.innerChain.insertAfter(toInsert, point);
    }

    public void insertBefore(List toInsert, Object point) {
        LinkedList backwardList = new LinkedList();
        Iterator it = toInsert.iterator();
        while (it.hasNext()) {
            backwardList.addFirst(it.next());
        }
        Object previousPoint = point;
        for (Object o : backwardList) {
            this.insertBefore(o, previousPoint);
            previousPoint = o;
        }
    }

    public void insertBefore(Object toInsert, Object point) {
        ((Unit)point).redirectJumpsToThisTo((Unit)toInsert);
        this.innerChain.insertBefore(toInsert, point);
    }

    public boolean follows(Object a, Object b) {
        return this.innerChain.follows(a, b);
    }

    public boolean remove(Object obj) {
        boolean res = false;
        if (this.contains(obj)) {
            Unit successor = (Unit)this.getSuccOf(obj);
            if (successor == null) {
                successor = (Unit)this.getPredOf(obj);
            }
            res = this.innerChain.remove(obj);
            ((Unit)obj).redirectJumpsToThisTo(successor);
        }
        return res;
    }

    public boolean contains(Object u) {
        return this.innerChain.contains(u);
    }

    public void addFirst(Object u) {
        this.innerChain.addFirst(u);
    }

    public void addLast(Object u) {
        this.innerChain.addLast(u);
    }

    public void removeFirst() {
        this.remove(this.innerChain.getFirst());
    }

    public void removeLast() {
        this.remove(this.innerChain.getLast());
    }

    public Object getFirst() {
        return this.innerChain.getFirst();
    }

    public Object getLast() {
        return this.innerChain.getLast();
    }

    public Object getSuccOf(Object point) {
        return this.innerChain.getSuccOf(point);
    }

    public Object getPredOf(Object point) {
        return this.innerChain.getPredOf(point);
    }

    public Iterator snapshotIterator() {
        ArrayList l = new ArrayList();
        l.addAll(this);
        return l.iterator();
    }

    public Iterator iterator() {
        return new PatchingIterator(this.innerChain);
    }

    public Iterator iterator(Object u) {
        return new PatchingIterator(this.innerChain, u);
    }

    public Iterator iterator(Object head, Object tail) {
        return new PatchingIterator(this.innerChain, head, tail);
    }

    public int size() {
        return this.innerChain.size();
    }

    protected class PatchingIterator
    implements Iterator {
        protected Iterator innerIterator = null;
        protected Object lastObject;
        protected boolean state = false;

        protected PatchingIterator(Chain innerChain) {
            this.innerIterator = innerChain.iterator();
        }

        protected PatchingIterator(Chain innerChain, Object u) {
            this.innerIterator = innerChain.iterator(u);
        }

        protected PatchingIterator(Chain innerChain, Object head, Object tail) {
            this.innerIterator = innerChain.iterator(head, tail);
        }

        public boolean hasNext() {
            return this.innerIterator.hasNext();
        }

        public Object next() {
            this.lastObject = this.innerIterator.next();
            this.state = true;
            return this.lastObject;
        }

        public void remove() {
            if (!this.state) {
                throw new IllegalStateException("remove called before first next() call");
            }
            Unit successor = (Unit)PatchingChain.this.getSuccOf(this.lastObject);
            if (successor == null) {
                successor = (Unit)PatchingChain.this.getPredOf(this.lastObject);
            }
            this.innerIterator.remove();
            ((Unit)this.lastObject).redirectJumpsToThisTo(successor);
        }
    }
}

