/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyPack;
import soot.G;
import soot.HasPhaseOptions;
import soot.JavaToJimpleBodyPack;
import soot.JimpleBodyPack;
import soot.Pack;
import soot.Printer;
import soot.Scene;
import soot.ScenePack;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Transform;
import soot.XMLAttributesPrinter;
import soot.baf.Baf;
import soot.baf.toolkits.base.LoadStoreOptimizer;
import soot.baf.toolkits.base.PeepholeOptimizer;
import soot.dava.Dava;
import soot.dava.DavaPrinter;
import soot.dava.toolkits.base.misc.PackageNamer;
import soot.dava.toolkits.base.misc.ThrowFinder;
import soot.grimp.Grimp;
import soot.grimp.toolkits.base.ConstructorFolder;
import soot.jimple.JasminClass;
import soot.jimple.JimpleBody;
import soot.jimple.spark.BDDSparkTransformer;
import soot.jimple.spark.SparkTransformer;
import soot.jimple.spark.fieldrw.FieldTagAggregator;
import soot.jimple.spark.fieldrw.FieldTagger;
import soot.jimple.toolkits.annotation.arraycheck.ArrayBoundsChecker;
import soot.jimple.toolkits.annotation.arraycheck.RectangularArrayFinder;
import soot.jimple.toolkits.annotation.callgraph.CallGraphTagger;
import soot.jimple.toolkits.annotation.defs.ReachingDefsTagger;
import soot.jimple.toolkits.annotation.fields.UnreachableFieldsTagger;
import soot.jimple.toolkits.annotation.methods.UnreachableMethodsTagger;
import soot.jimple.toolkits.annotation.nullcheck.NullPointerChecker;
import soot.jimple.toolkits.annotation.nullcheck.NullPointerColorer;
import soot.jimple.toolkits.annotation.parity.ParityTagger;
import soot.jimple.toolkits.annotation.profiling.ProfilingGenerator;
import soot.jimple.toolkits.annotation.qualifiers.TightestQualifiersTagger;
import soot.jimple.toolkits.annotation.tags.ArrayNullTagAggregator;
import soot.jimple.toolkits.base.Aggregator;
import soot.jimple.toolkits.callgraph.CHATransformer;
import soot.jimple.toolkits.callgraph.CallGraphPack;
import soot.jimple.toolkits.invoke.StaticInliner;
import soot.jimple.toolkits.invoke.StaticMethodBinder;
import soot.jimple.toolkits.pointer.DependenceTagAggregator;
import soot.jimple.toolkits.pointer.ParameterAliasTagger;
import soot.jimple.toolkits.pointer.SideEffectTagger;
import soot.jimple.toolkits.scalar.CommonSubexpressionEliminator;
import soot.jimple.toolkits.scalar.ConditionalBranchFolder;
import soot.jimple.toolkits.scalar.ConstantPropagatorAndFolder;
import soot.jimple.toolkits.scalar.CopyPropagator;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.jimple.toolkits.scalar.LocalNameStandardizer;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.jimple.toolkits.scalar.UnconditionalBranchFolder;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.jimple.toolkits.scalar.pre.BusyCodeMotion;
import soot.jimple.toolkits.scalar.pre.LazyCodeMotion;
import soot.jimple.toolkits.typing.TypeAssigner;
import soot.options.Options;
import soot.shimple.Shimple;
import soot.shimple.ShimpleBody;
import soot.shimple.ShimpleTransformer;
import soot.shimple.toolkits.scalar.SConstantPropagatorAndFolder;
import soot.tagkit.LineNumberTagAggregator;
import soot.toolkits.scalar.LocalPacker;
import soot.toolkits.scalar.LocalSplitter;
import soot.toolkits.scalar.UnusedLocalEliminator;
import soot.util.EscapedWriter;
import soot.util.SourceLocator;
import soot.xml.TagCollector;
import soot.xml.XMLPrinter;

public class PackManager {
    private boolean onlyStandardPacks = false;
    private Map packNameToPack = new HashMap();
    private List packList = new LinkedList();

    public PackManager(Singletons.Global g) {
        G.v().PhaseOptions().setPackManager(this);
        this.init();
    }

    public boolean onlyStandardPacks() {
        return this.onlyStandardPacks;
    }

    void notifyAddPack() {
        this.onlyStandardPacks = false;
    }

    private void init() {
        Pack p = new JimpleBodyPack();
        this.addPack(p);
        p.add(new Transform("jb.ls", LocalSplitter.v()));
        p.add(new Transform("jb.a", Aggregator.v()));
        p.add(new Transform("jb.ule", UnusedLocalEliminator.v()));
        p.add(new Transform("jb.tr", TypeAssigner.v()));
        p.add(new Transform("jb.ulp", LocalPacker.v()));
        p.add(new Transform("jb.lns", LocalNameStandardizer.v()));
        p.add(new Transform("jb.cp", CopyPropagator.v()));
        p.add(new Transform("jb.dae", DeadAssignmentEliminator.v()));
        p.add(new Transform("jb.cp-ule", UnusedLocalEliminator.v()));
        p.add(new Transform("jb.lp", LocalPacker.v()));
        p.add(new Transform("jb.ne", NopEliminator.v()));
        p.add(new Transform("jb.uce", UnreachableCodeEliminator.v()));
        p = new JavaToJimpleBodyPack();
        this.addPack(p);
        p.add(new Transform("jj.ls", LocalSplitter.v()));
        p.add(new Transform("jj.a", Aggregator.v()));
        p.add(new Transform("jj.ule", UnusedLocalEliminator.v()));
        p.add(new Transform("jj.ne", NopEliminator.v()));
        p.add(new Transform("jj.tr", TypeAssigner.v()));
        p.add(new Transform("jj.ulp", LocalPacker.v()));
        p.add(new Transform("jj.lns", LocalNameStandardizer.v()));
        p.add(new Transform("jj.cp", CopyPropagator.v()));
        p.add(new Transform("jj.dae", DeadAssignmentEliminator.v()));
        p.add(new Transform("jj.cp-ule", UnusedLocalEliminator.v()));
        p.add(new Transform("jj.lp", LocalPacker.v()));
        p.add(new Transform("jj.uce", UnreachableCodeEliminator.v()));
        p = new CallGraphPack("cg");
        this.addPack(p);
        p.add(new Transform("cg.cha", CHATransformer.v()));
        p.add(new Transform("cg.spark", SparkTransformer.v()));
        p.add(new Transform("cg.bdd", BDDSparkTransformer.v()));
        p = new ScenePack("wstp");
        this.addPack(p);
        p = new ScenePack("wsop");
        this.addPack(p);
        p = new ScenePack("wjtp");
        this.addPack(p);
        p = new ScenePack("wjop");
        this.addPack(p);
        p.add(new Transform("wjop.smb", StaticMethodBinder.v()));
        p.add(new Transform("wjop.si", StaticInliner.v()));
        p = new ScenePack("wjap");
        this.addPack(p);
        p.add(new Transform("wjap.ra", RectangularArrayFinder.v()));
        p.add(new Transform("wjap.umt", UnreachableMethodsTagger.v()));
        p.add(new Transform("wjap.uft", UnreachableFieldsTagger.v()));
        p.add(new Transform("wjap.tqt", TightestQualifiersTagger.v()));
        p = new BodyPack("shimple");
        this.addPack(p);
        p = new BodyPack("stp");
        this.addPack(p);
        p = new BodyPack("sop");
        this.addPack(p);
        p.add(new Transform("sop.cpf", SConstantPropagatorAndFolder.v()));
        p = new BodyPack("jtp");
        this.addPack(p);
        p = new BodyPack("jop");
        this.addPack(p);
        p.add(new Transform("jop.cse", CommonSubexpressionEliminator.v()));
        p.add(new Transform("jop.bcm", BusyCodeMotion.v()));
        p.add(new Transform("jop.lcm", LazyCodeMotion.v()));
        p.add(new Transform("jop.cp", CopyPropagator.v()));
        p.add(new Transform("jop.cpf", ConstantPropagatorAndFolder.v()));
        p.add(new Transform("jop.cbf", ConditionalBranchFolder.v()));
        p.add(new Transform("jop.dae", DeadAssignmentEliminator.v()));
        p.add(new Transform("jop.uce1", UnreachableCodeEliminator.v()));
        p.add(new Transform("jop.ubf1", UnconditionalBranchFolder.v()));
        p.add(new Transform("jop.uce2", UnreachableCodeEliminator.v()));
        p.add(new Transform("jop.ubf2", UnconditionalBranchFolder.v()));
        p.add(new Transform("jop.ule", UnusedLocalEliminator.v()));
        p = new BodyPack("jap");
        this.addPack(p);
        p.add(new Transform("jap.npc", NullPointerChecker.v()));
        p.add(new Transform("jap.npcolorer", NullPointerColorer.v()));
        p.add(new Transform("jap.abc", ArrayBoundsChecker.v()));
        p.add(new Transform("jap.profiling", ProfilingGenerator.v()));
        p.add(new Transform("jap.sea", SideEffectTagger.v()));
        p.add(new Transform("jap.fieldrw", FieldTagger.v()));
        p.add(new Transform("jap.cgtagger", CallGraphTagger.v()));
        p.add(new Transform("jap.parity", ParityTagger.v()));
        p.add(new Transform("jap.pat", ParameterAliasTagger.v()));
        p.add(new Transform("jap.rdtagger", ReachingDefsTagger.v()));
        p = new BodyPack("gb");
        this.addPack(p);
        p.add(new Transform("gb.a1", Aggregator.v()));
        p.add(new Transform("gb.cf", ConstructorFolder.v()));
        p.add(new Transform("gb.a2", Aggregator.v()));
        p.add(new Transform("gb.ule", UnusedLocalEliminator.v()));
        p = new BodyPack("gop");
        this.addPack(p);
        p = new BodyPack("bb");
        this.addPack(p);
        p.add(new Transform("bb.lso", LoadStoreOptimizer.v()));
        p.add(new Transform("bb.pho", PeepholeOptimizer.v()));
        p.add(new Transform("bb.ule", UnusedLocalEliminator.v()));
        p.add(new Transform("bb.lp", LocalPacker.v()));
        p = new BodyPack("bop");
        this.addPack(p);
        p = new BodyPack("tag");
        this.addPack(p);
        p.add(new Transform("tag.ln", LineNumberTagAggregator.v()));
        p.add(new Transform("tag.an", ArrayNullTagAggregator.v()));
        p.add(new Transform("tag.dep", DependenceTagAggregator.v()));
        p.add(new Transform("tag.fieldrw", FieldTagAggregator.v()));
        this.onlyStandardPacks = true;
    }

    public static PackManager v() {
        return G.v().PackManager();
    }

    private void addPack(Pack p) {
        if (this.packNameToPack.containsKey(p.getPhaseName())) {
            throw new RuntimeException("Duplicate pack " + p.getPhaseName());
        }
        this.packNameToPack.put(p.getPhaseName(), p);
        this.packList.add(p);
    }

    public boolean hasPack(String phaseName) {
        return this.getPhase(phaseName) != null;
    }

    public Pack getPack(String phaseName) {
        Pack p = (Pack)this.packNameToPack.get(phaseName);
        return p;
    }

    public boolean hasPhase(String phaseName) {
        return this.getPhase(phaseName) != null;
    }

    public HasPhaseOptions getPhase(String phaseName) {
        int index = phaseName.indexOf(".");
        if (index < 0) {
            return this.getPack(phaseName);
        }
        String packName = phaseName.substring(0, index);
        if (!this.hasPack(packName)) {
            return null;
        }
        return this.getPack(packName).get(phaseName);
    }

    public Transform getTransform(String phaseName) {
        return (Transform)this.getPhase(phaseName);
    }

    public Collection allPacks() {
        return Collections.unmodifiableList(this.packList);
    }

    public void runPacks() {
        if (Options.v().whole_program() || Options.v().whole_shimple()) {
            this.runWholeProgramPacks();
        }
        this.preProcessDAVA();
        this.runBodyPacks(this.reachableClasses());
    }

    public void writeOutput() {
        if (Options.v().output_format() == 13) {
            this.postProcessDAVA();
        } else {
            this.writeOutput(this.reachableClasses());
        }
        this.postProcessXML(this.reachableClasses());
        this.releaseBodies(this.reachableClasses());
    }

    private void runWholeProgramPacks() {
        this.getPack("cg").apply();
        if (Options.v().whole_shimple()) {
            ShimpleTransformer.v().transform();
            this.getPack("wstp").apply();
            this.getPack("wsop").apply();
        } else {
            this.getPack("wjtp").apply();
            this.getPack("wjop").apply();
            this.getPack("wjap").apply();
        }
    }

    private void preProcessDAVA() {
        if (Options.v().output_format() == 13) {
            ThrowFinder.v().find();
            PackageNamer.v().fixNames();
            G.v().out.println();
        }
    }

    private void runBodyPacks(Iterator classes) {
        while (classes.hasNext()) {
            SootClass cl = (SootClass)classes.next();
            this.runBodyPacks(cl);
        }
    }

    private void writeOutput(Iterator classes) {
        while (classes.hasNext()) {
            SootClass cl = (SootClass)classes.next();
            this.writeClass(cl);
        }
    }

    private void releaseBodies(Iterator classes) {
        while (classes.hasNext()) {
            SootClass cl = (SootClass)classes.next();
            this.releaseBodies(cl);
        }
    }

    private Iterator reachableClasses() {
        return Scene.v().getApplicationClasses().iterator();
    }

    private void postProcessDAVA() {
        G.v().out.println();
        for (SootClass s : Scene.v().getApplicationClasses()) {
            FileOutputStream streamOut = null;
            PrintWriter writerOut = null;
            String fileName = SourceLocator.v().getFileNameFor(s, Options.v().output_format());
            try {
                streamOut = new FileOutputStream(fileName);
                writerOut = new PrintWriter(new OutputStreamWriter(streamOut));
            }
            catch (IOException e) {
                G.v().out.println("Cannot output file " + fileName);
            }
            G.v().out.print("Generating " + fileName + "... ");
            G.v().out.flush();
            DavaPrinter.v().printTo(s, writerOut);
            G.v().out.println();
            G.v().out.flush();
            try {
                writerOut.flush();
                streamOut.close();
            }
            catch (IOException e) {
                G.v().out.println("Cannot close output file " + fileName);
            }
        }
        G.v().out.println();
    }

    private void runBodyPacks(SootClass c) {
        SootMethod m;
        int format = Options.v().output_format();
        if (format == 13) {
            G.v().out.print("Decompiling ");
        } else {
            G.v().out.print("Transforming ");
        }
        G.v().out.println(c.getName() + "... ");
        boolean produceBaf = false;
        boolean produceGrimp = false;
        boolean produceDava = false;
        boolean produceJimple = true;
        boolean produceShimple = false;
        switch (format) {
            case 1: 
            case 2: 
            case 9: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                produceShimple = true;
                produceJimple = false;
                break;
            }
            case 13: {
                produceDava = true;
            }
            case 7: 
            case 8: {
                produceGrimp = true;
                break;
            }
            case 5: 
            case 6: {
                produceBaf = true;
                break;
            }
            case 11: 
            case 12: {
                produceGrimp = Options.v().via_grimp();
                produceBaf = !produceGrimp;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        TagCollector tc = new TagCollector();
        boolean wholeShimple = Options.v().whole_shimple();
        if (Options.v().via_shimple()) {
            produceShimple = true;
        }
        Iterator methodIt = c.methodIterator();
        while (methodIt.hasNext()) {
            m = (SootMethod)methodIt.next();
            if (!m.isConcrete()) continue;
            if (produceShimple || wholeShimple) {
                ShimpleBody sBody = null;
                Body body = m.retrieveActiveBody();
                if (body instanceof ShimpleBody) {
                    sBody = (ShimpleBody)body;
                    if (!sBody.isSSA()) {
                        sBody.rebuild();
                    }
                } else {
                    sBody = Shimple.v().newBody(body);
                }
                m.setActiveBody(sBody);
                PackManager.v().getPack("stp").apply(sBody);
                PackManager.v().getPack("sop").apply(sBody);
                if (produceJimple || wholeShimple && !produceShimple) {
                    m.setActiveBody(sBody.toJimpleBody());
                }
            }
            if (produceJimple) {
                JimpleBody body = (JimpleBody)m.retrieveActiveBody();
                PackManager.v().getPack("jtp").apply(body);
                PackManager.v().getPack("jop").apply(body);
                PackManager.v().getPack("jap").apply(body);
                if (Options.v().xml_attributes() && Options.v().output_format() != 1) {
                    tc.collectBodyTags(body);
                }
            }
            if (produceGrimp) {
                m.setActiveBody(Grimp.v().newBody(m.getActiveBody(), "gb"));
                PackManager.v().getPack("gop").apply(m.getActiveBody());
                continue;
            }
            if (!produceBaf) continue;
            m.setActiveBody(Baf.v().newBody((JimpleBody)m.getActiveBody()));
            PackManager.v().getPack("bop").apply(m.getActiveBody());
            PackManager.v().getPack("tag").apply(m.getActiveBody());
        }
        if (Options.v().xml_attributes() && Options.v().output_format() != 1) {
            this.processXMLForClass(c, tc);
        }
        if (produceDava) {
            methodIt = c.methodIterator();
            while (methodIt.hasNext()) {
                m = (SootMethod)methodIt.next();
                if (!m.isConcrete()) continue;
                m.setActiveBody(Dava.v().newBody(m.getActiveBody()));
            }
        }
    }

    private void writeClass(SootClass c) {
        int format = Options.v().output_format();
        if (format == 10) {
            return;
        }
        if (format == 13) {
            return;
        }
        FileOutputStream streamOut = null;
        PrintWriter writerOut = null;
        boolean noOutputFile = false;
        String fileName = SourceLocator.v().getFileNameFor(c, format);
        if (format != 12) {
            try {
                streamOut = new FileOutputStream(fileName);
                writerOut = new PrintWriter(new OutputStreamWriter(streamOut));
                G.v().out.println("Writing to " + fileName);
            }
            catch (IOException e) {
                G.v().out.println("Cannot output file " + fileName);
            }
        }
        if (Options.v().xml_attributes()) {
            Printer.v().setOption(16);
        }
        switch (format) {
            case 11: {
                if (c.containsBafBody()) {
                    new soot.baf.JasminClass(c).print(writerOut);
                    break;
                }
                new JasminClass(c).print(writerOut);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                Printer.v().setOption(1);
                Printer.v().printTo(c, writerOut);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                writerOut = new PrintWriter(new EscapedWriter(new OutputStreamWriter(streamOut)));
                Printer.v().printTo(c, writerOut);
                break;
            }
            case 12: {
                Printer.v().write(c, SourceLocator.v().getOutputDir());
                break;
            }
            case 9: {
                writerOut = new PrintWriter(new EscapedWriter(new OutputStreamWriter(streamOut)));
                XMLPrinter.v().printJimpleStyleTo(c, writerOut);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (format != 12) {
            try {
                writerOut.flush();
                streamOut.close();
            }
            catch (IOException e) {
                G.v().out.println("Cannot close output file " + fileName);
            }
        }
    }

    private void postProcessXML(Iterator classes) {
        if (!Options.v().xml_attributes()) {
            return;
        }
        if (Options.v().output_format() != 1) {
            return;
        }
        while (classes.hasNext()) {
            SootClass c = (SootClass)classes.next();
            this.processXMLForClass(c);
        }
    }

    private void processXMLForClass(SootClass c, TagCollector tc) {
        int format = Options.v().output_format();
        String fileName = SourceLocator.v().getFileNameFor(c, format);
        XMLAttributesPrinter xap = new XMLAttributesPrinter(fileName, SourceLocator.v().getOutputDir());
        xap.printAttrs(c, tc);
    }

    private void processXMLForClass(SootClass c) {
        int format = Options.v().output_format();
        String fileName = SourceLocator.v().getFileNameFor(c, format);
        XMLAttributesPrinter xap = new XMLAttributesPrinter(fileName, SourceLocator.v().getOutputDir());
        xap.printAttrs(c);
    }

    private void releaseBodies(SootClass cl) {
        Iterator methodIt = cl.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod m = (SootMethod)methodIt.next();
            if (!m.hasActiveBody()) continue;
            m.releaseActiveBody();
        }
    }
}

