/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.HasPhaseOptions;
import soot.PhaseOptions;
import soot.Transform;
import soot.options.Options;
import soot.util.Chain;
import soot.util.HashChain;

public abstract class Pack
implements HasPhaseOptions {
    private String name;
    Chain opts = new HashChain();

    public String getPhaseName() {
        return this.name;
    }

    public Pack(String name) {
        this.name = name;
    }

    public Iterator iterator() {
        return this.opts.iterator();
    }

    public void add(Transform t) {
        PhaseOptions.v().getPM().notifyAddPack();
        if (this.get(t.getPhaseName()) != null) {
            throw new RuntimeException("Phase " + t.getPhaseName() + " already " + "in pack");
        }
        this.opts.add(t);
    }

    public void insertAfter(Transform t, String phaseName) {
        PhaseOptions.v().getPM().notifyAddPack();
        for (Transform tr : this.opts) {
            if (!tr.getPhaseName().equals(phaseName)) continue;
            this.opts.insertAfter(t, (Object)tr);
            return;
        }
        throw new RuntimeException("phase " + phaseName + " not found!");
    }

    public void insertBefore(Transform t, String phaseName) {
        PhaseOptions.v().getPM().notifyAddPack();
        for (Transform tr : this.opts) {
            if (!tr.getPhaseName().equals(phaseName)) continue;
            this.opts.insertBefore(t, (Object)tr);
            return;
        }
        throw new RuntimeException("phase " + phaseName + " not found!");
    }

    public Transform get(String phaseName) {
        for (Transform tr : this.opts) {
            if (!tr.getPhaseName().equals(phaseName)) continue;
            return tr;
        }
        return null;
    }

    protected void internalApply() {
        throw new RuntimeException("wrong type of pack");
    }

    protected void internalApply(Body b) {
        throw new RuntimeException("wrong type of pack");
    }

    public final void apply() {
        Map options = PhaseOptions.v().getPhaseOptions(this);
        if (!PhaseOptions.getBoolean(options, "enabled")) {
            return;
        }
        this.internalApply();
    }

    public final void apply(Body b) {
        Map options = PhaseOptions.v().getPhaseOptions(this);
        if (!PhaseOptions.getBoolean(options, "enabled")) {
            return;
        }
        this.internalApply(b);
    }

    public String getDeclaredOptions() {
        return Options.getDeclaredOptionsForPhase(this.getPhaseName());
    }

    public String getDefaultOptions() {
        return Options.getDefaultOptionsForPhase(this.getPhaseName());
    }
}

