/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import soot.AbstractUnitPrinter;
import soot.Body;
import soot.PatchingChain;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.UnitBox;
import soot.jimple.IdentityRef;

public abstract class LabeledUnitPrinter
extends AbstractUnitPrinter {
    protected Map labels;
    protected Map references;
    protected String labelIndent = "     ";

    public LabeledUnitPrinter(Body b) {
        this.createLabelMaps(b);
    }

    public Map labels() {
        return this.labels;
    }

    public Map references() {
        return this.references;
    }

    public abstract void literal(String var1);

    public abstract void method(SootMethod var1);

    public abstract void fieldRef(SootField var1);

    public abstract void identityRef(IdentityRef var1);

    public abstract void type(Type var1);

    public void unitRef(Unit u, boolean branchTarget) {
        String oldIndent = this.getIndent();
        if (branchTarget) {
            this.setIndent(this.labelIndent);
            this.handleIndent();
            this.setIndent(oldIndent);
            String label = (String)this.labels.get(u);
            if (label == null || label.equals("<unnamed>")) {
                label = "[?= " + u + "]";
            }
            this.output.append(label);
        } else {
            String ref = (String)this.references.get(u);
            if (this.startOfLine) {
                String newIndent = "(" + ref + ")" + this.indent.substring(ref.length() + 2);
                this.setIndent(newIndent);
                this.handleIndent();
                this.setIndent(oldIndent);
            } else {
                this.output.append(ref);
            }
        }
    }

    private void createLabelMaps(Body body) {
        PatchingChain units = body.getUnits();
        this.labels = new HashMap(units.size() * 2 + 1, 0.7f);
        this.references = new HashMap(units.size() * 2 + 1, 0.7f);
        Iterator boxIt = body.getAllUnitBoxes().iterator();
        HashSet<Unit> labelStmts = new HashSet<Unit>();
        HashSet<Unit> refStmts = new HashSet<Unit>();
        while (boxIt.hasNext()) {
            UnitBox box = (UnitBox)boxIt.next();
            Unit stmt = box.getUnit();
            if (box.isBranchTarget()) {
                labelStmts.add(stmt);
                continue;
            }
            refStmts.add(stmt);
        }
        int labelCount = 0;
        int refCount = 0;
        for (Unit s : units) {
            if (labelStmts.contains(s)) {
                this.labels.put(s, "label" + labelCount++);
            }
            if (!refStmts.contains(s)) continue;
            this.references.put(s, Integer.toString(refCount++));
        }
    }
}

