/*
 * Decompiled with CFR 0.152.
 */
package soot;

import soot.Body;
import soot.LabeledUnitPrinter;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.IdentityRef;
import soot.jimple.Jimple;
import soot.jimple.ParameterRef;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;

public class BriefUnitPrinter
extends LabeledUnitPrinter {
    private boolean baf;
    private boolean eatSpace = false;

    public BriefUnitPrinter(Body body) {
        super(body);
    }

    public void startUnit(Unit u) {
        super.startUnit(u);
        this.baf = !(u instanceof Stmt);
    }

    public void method(SootMethod m) {
        this.handleIndent();
        if (!this.baf && m.isStatic()) {
            this.output.append(m.getDeclaringClass().getName());
            this.literal(".");
        }
        this.output.append(m.getName());
    }

    public void fieldRef(SootField f) {
        this.handleIndent();
        if (this.baf || f.isStatic()) {
            this.output.append(f.getDeclaringClass().getName());
            this.literal(".");
        }
        this.output.append(f.getName());
    }

    public void identityRef(IdentityRef r) {
        this.handleIndent();
        if (r instanceof ThisRef) {
            this.literal("@this");
        } else if (r instanceof ParameterRef) {
            ParameterRef pr = (ParameterRef)r;
            this.literal("@parameter" + pr.getIndex());
        } else if (r instanceof CaughtExceptionRef) {
            this.literal("@caughtexception");
        } else {
            throw new RuntimeException();
        }
    }

    public void literal(String s) {
        block4: {
            block5: {
                this.handleIndent();
                if (this.eatSpace && s.equals(" ")) {
                    this.eatSpace = false;
                    return;
                }
                this.eatSpace = false;
                if (this.baf) break block4;
                Jimple.v();
                if (s.equals("staticinvoke")) break block5;
                Jimple.v();
                if (s.equals("virtualinvoke")) break block5;
                Jimple.v();
                if (!s.equals("interfaceinvoke")) break block4;
            }
            this.eatSpace = true;
            return;
        }
        this.output.append(s);
    }

    public void type(Type t) {
        this.handleIndent();
        this.output.append(t.toString());
    }
}

