/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import soot.Local;
import soot.PatchingChain;
import soot.SootMethod;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.Value;
import soot.ValueBox;
import soot.jimple.IdentityStmt;
import soot.jimple.ParameterRef;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.options.Options;
import soot.tagkit.AbstractHost;
import soot.tagkit.CodeAttribute;
import soot.tagkit.Tag;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.scalar.SimpleLocalDefs;
import soot.util.Chain;
import soot.util.HashChain;

public abstract class Body
extends AbstractHost
implements Serializable {
    protected transient SootMethod method = null;
    protected Chain localChain = new HashChain();
    protected Chain trapChain = new HashChain();
    protected PatchingChain unitChain = new PatchingChain(new HashChain());

    public abstract Object clone();

    protected Body(SootMethod m) {
        this.method = m;
    }

    protected Body() {
    }

    public SootMethod getMethod() {
        if (this.method == null) {
            throw new RuntimeException("no method associated w/ body");
        }
        return this.method;
    }

    public void setMethod(SootMethod method) {
        this.method = method;
    }

    public int getLocalCount() {
        return this.localChain.size();
    }

    public void importBodyContentsFrom(Body b) {
        Object copy;
        HashMap<Object, Object> bindings = new HashMap<Object, Object>();
        for (Object original : b.getUnits()) {
            copy = (Unit)original.clone();
            this.unitChain.addLast(copy);
            bindings.put(original, copy);
        }
        for (Object original : b.getTraps()) {
            copy = (Trap)original.clone();
            this.trapChain.addLast(copy);
            bindings.put(original, copy);
        }
        for (Object original : b.getLocals()) {
            copy = (Value)original.clone();
            this.localChain.addLast(copy);
            bindings.put(original, copy);
        }
        for (UnitBox box : this.getAllUnitBoxes()) {
            Unit oldObject = box.getUnit();
            Unit newObject = (Unit)bindings.get(oldObject);
            if (newObject == null) continue;
            box.setUnit(newObject);
        }
        for (ValueBox vb : this.getUseBoxes()) {
            if (!(vb.getValue() instanceof Local)) continue;
            vb.setValue((Value)bindings.get(vb.getValue()));
        }
        for (ValueBox vb : this.getDefBoxes()) {
            if (!(vb.getValue() instanceof Local)) continue;
            vb.setValue((Value)bindings.get(vb.getValue()));
        }
    }

    public void validate() {
        this.validateLocals();
        this.validateTraps();
        this.validateUnitBoxes();
        if (Options.v().debug()) {
            this.validateUses();
        }
    }

    public void validateLocals() {
        Iterator it = this.getUseBoxes().iterator();
        while (it.hasNext()) {
            this.validateLocal((ValueBox)it.next());
        }
        it = this.getDefBoxes().iterator();
        while (it.hasNext()) {
            this.validateLocal((ValueBox)it.next());
        }
    }

    private void validateLocal(ValueBox vb) {
        Value value = vb.getValue();
        if (value instanceof Local && !this.localChain.contains(value)) {
            throw new RuntimeException("Local not in chain : " + value);
        }
    }

    public void validateTraps() {
        for (Trap t : this.getTraps()) {
            if (!this.unitChain.contains(t.getBeginUnit())) {
                throw new RuntimeException("begin not in chain");
            }
            if (!this.unitChain.contains(t.getEndUnit())) {
                throw new RuntimeException("end not in chain");
            }
            if (this.unitChain.contains(t.getHandlerUnit())) continue;
            throw new RuntimeException("handler not in chain");
        }
    }

    public void validateUnitBoxes() {
        for (UnitBox ub : this.getAllUnitBoxes()) {
            if (this.unitChain.contains(ub.getUnit())) continue;
            throw new RuntimeException("Unitbox points outside unitChain! to unit : " + ub.getUnit());
        }
    }

    public void validateUses() {
        SimpleLocalDefs ld = new SimpleLocalDefs(new CompleteUnitGraph(this));
        for (Unit u : this.getUnits()) {
            Iterator useBoxIt = u.getUseBoxes().iterator();
            while (useBoxIt.hasNext()) {
                List l;
                Value v = ((ValueBox)useBoxIt.next()).getValue();
                if (!(v instanceof Local) || (l = ld.getDefsOfAt((Local)v, u)).size() != 0) continue;
                throw new RuntimeException("no defs for value!");
            }
        }
    }

    public Chain getLocals() {
        return this.localChain;
    }

    public Chain getTraps() {
        return this.trapChain;
    }

    public Local getThisLocal() {
        for (Stmt s : this.getUnits()) {
            if (!(s instanceof IdentityStmt) || !(((IdentityStmt)s).getRightOp() instanceof ThisRef)) continue;
            return (Local)((IdentityStmt)s).getLeftOp();
        }
        throw new RuntimeException("couldn't find identityref!");
    }

    public Local getParameterLocal(int i) {
        for (Stmt s : this.getUnits()) {
            IdentityStmt is;
            ParameterRef pr;
            if (!(s instanceof IdentityStmt) || !(((IdentityStmt)s).getRightOp() instanceof ParameterRef) || (pr = (ParameterRef)(is = (IdentityStmt)s).getRightOp()).getIndex() != i) continue;
            return (Local)is.getLeftOp();
        }
        throw new RuntimeException("couldn't find parameterref!");
    }

    public PatchingChain getUnits() {
        return this.unitChain;
    }

    public List getAllUnitBoxes() {
        ArrayList unitBoxList = new ArrayList();
        for (Object item : this.unitChain) {
            unitBoxList.addAll(item.getUnitBoxes());
        }
        for (Object item : this.trapChain) {
            unitBoxList.addAll(item.getUnitBoxes());
        }
        for (Tag t : this.getTags()) {
            if (!(t instanceof CodeAttribute)) continue;
            unitBoxList.addAll(((CodeAttribute)t).getUnitBoxes());
        }
        return unitBoxList;
    }

    public List getUnitBoxes(boolean branchTarget) {
        ArrayList unitBoxList = new ArrayList();
        for (Object item : this.unitChain) {
            if (branchTarget) {
                if (!item.branches()) continue;
                unitBoxList.addAll(item.getUnitBoxes());
                continue;
            }
            if (item.branches()) continue;
            unitBoxList.addAll(item.getUnitBoxes());
        }
        for (Object item : this.trapChain) {
            unitBoxList.addAll(item.getUnitBoxes());
        }
        for (Tag t : this.getTags()) {
            if (!(t instanceof CodeAttribute)) continue;
            unitBoxList.addAll(((CodeAttribute)t).getUnitBoxes());
        }
        return unitBoxList;
    }

    public List getUseBoxes() {
        ArrayList useBoxList = new ArrayList();
        for (Unit item : this.unitChain) {
            useBoxList.addAll(item.getUseBoxes());
        }
        return useBoxList;
    }

    public List getDefBoxes() {
        ArrayList defBoxList = new ArrayList();
        for (Unit item : this.unitChain) {
            defBoxList.addAll(item.getDefBoxes());
        }
        return defBoxList;
    }

    public List getUseAndDefBoxes() {
        ArrayList useAndDefBoxList = new ArrayList();
        for (Unit item : this.unitChain) {
            useAndDefBoxList.addAll(item.getUseBoxes());
            useAndDefBoxList.addAll(item.getDefBoxes());
        }
        return useAndDefBoxList;
    }
}

