/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.Iterator;
import java.util.Stack;
import soot.Unit;
import soot.UnitPrinter;
import soot.ValueBox;
import soot.tagkit.ColorTag;
import soot.tagkit.Host;
import soot.tagkit.JimpleLineNumberTag;
import soot.tagkit.PositionTag;

public class AttributesUnitPrinter {
    private int startOffset;
    private Stack startOffsets;
    private int endOffset;
    private int startStmtOffset;
    private int startLn;
    private int currentLn;
    private int lastNewline;
    private UnitPrinter printer;

    public AttributesUnitPrinter(int currentLnNum) {
        this.currentLn = currentLnNum;
    }

    public void startUnit(Unit u) {
        this.startLn = this.currentLn;
        this.startStmtOffset = this.output().length() - this.lastNewline;
    }

    public void endUnit(Unit u) {
        int endStmtOffset = this.output().length() - this.lastNewline;
        if (this.hasTag(u)) {
            u.addTag(new JimpleLineNumberTag(this.startLn, this.currentLn));
        }
        if (this.hasColorTag(u)) {
            u.addTag(new PositionTag(this.startStmtOffset, endStmtOffset));
        }
    }

    public void startValueBox(ValueBox u) {
        if (this.startOffsets == null) {
            this.startOffsets = new Stack();
        }
        this.startOffsets.push(new Integer(this.output().length() - this.lastNewline));
    }

    public void endValueBox(ValueBox u) {
        this.endOffset = this.output().length() - this.lastNewline;
        if (this.hasColorTag(u)) {
            u.addTag(new PositionTag((Integer)this.startOffsets.pop(), this.endOffset));
        }
    }

    private boolean hasTag(Host h) {
        if (h instanceof Unit) {
            Iterator usesAndDefsIt = ((Unit)h).getUseAndDefBoxes().iterator();
            while (usesAndDefsIt.hasNext()) {
                if (!this.hasTag((ValueBox)usesAndDefsIt.next())) continue;
                return true;
            }
        }
        return !h.getTags().isEmpty();
    }

    private boolean hasColorTag(Host h) {
        Iterator it = h.getTags().iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof ColorTag)) continue;
            return true;
        }
        return false;
    }

    public void setEndLn(int ln) {
        this.currentLn = ln;
    }

    public int getEndLn() {
        return this.currentLn;
    }

    public void newline() {
        ++this.currentLn;
        this.lastNewline = this.output().length();
    }

    private StringBuffer output() {
        return this.printer.output();
    }

    public void setUnitPrinter(UnitPrinter up) {
        this.printer = up;
    }
}

