/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import sun.misc.Unsafe;
import sun.reflect.ReflectionFactory;

public class Sun14ReflectionProvider
extends PureJavaReflectionProvider {
    private static final ReflectionFactory reflectionFactory = ReflectionFactory.getReflectionFactory();
    private static final Map constructorCache = new HashMap();
    private static Unsafe cachedUnsafe;
    static /* synthetic */ Class class$java$lang$Object;

    private Unsafe getUnsafe() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        if (cachedUnsafe != null) {
            return cachedUnsafe;
        }
        Class<?> clazz = Class.forName("java.io.ObjectStreamClass$FieldReflector");
        Field field = clazz.getDeclaredField("unsafe");
        field.setAccessible(true);
        cachedUnsafe = (Unsafe)field.get(null);
        return cachedUnsafe;
    }

    public Object newInstance(Class clazz) {
        try {
            Constructor constructor = this.getMungedConstructor(clazz);
            Object t = constructor.newInstance(new Object[0]);
            return t;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ObjectAccessException("Cannot construct " + clazz.getName(), noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new ObjectAccessException("Cannot construct " + clazz.getName(), securityException);
        }
        catch (InstantiationException instantiationException) {
            throw new ObjectAccessException("Cannot construct " + clazz.getName(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ObjectAccessException("Cannot construct " + clazz.getName(), illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ObjectAccessException("Cannot construct " + clazz.getName(), illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ObjectAccessException("Cannot construct " + clazz.getName(), invocationTargetException);
        }
    }

    private Constructor getMungedConstructor(Class clazz) throws NoSuchMethodException {
        if (!constructorCache.containsKey(clazz)) {
            Constructor constructor = (class$java$lang$Object == null ? (class$java$lang$Object = Sun14ReflectionProvider.class$("java.lang.Object")) : class$java$lang$Object).getDeclaredConstructor(new Class[0]);
            Constructor<?> constructor2 = reflectionFactory.newConstructorForSerialization(clazz, constructor);
            constructorCache.put(clazz, constructor2);
        }
        return (Constructor)constructorCache.get(clazz);
    }

    public void writeField(Object object, String string, Object object2, Class clazz) {
        this.write(this.fieldDictionary.field(object.getClass(), string, clazz), object, object2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void write(Field field, Object object, Object object2) {
        try {
            Unsafe unsafe = this.getUnsafe();
            long l = unsafe.objectFieldOffset(field);
            Class<?> clazz = field.getType();
            if (clazz.isPrimitive()) {
                if (clazz.equals(Integer.TYPE)) {
                    unsafe.putInt(object, l, (Integer)object2);
                    return;
                } else if (clazz.equals(Long.TYPE)) {
                    unsafe.putLong(object, l, (Long)object2);
                    return;
                } else if (clazz.equals(Short.TYPE)) {
                    unsafe.putShort(object, l, (Short)object2);
                    return;
                } else if (clazz.equals(Character.TYPE)) {
                    unsafe.putChar(object, l, ((Character)object2).charValue());
                    return;
                } else if (clazz.equals(Byte.TYPE)) {
                    unsafe.putByte(object, l, (Byte)object2);
                    return;
                } else if (clazz.equals(Float.TYPE)) {
                    unsafe.putFloat(object, l, ((Float)object2).floatValue());
                    return;
                } else if (clazz.equals(Double.TYPE)) {
                    unsafe.putDouble(object, l, (Double)object2);
                    return;
                } else {
                    if (!clazz.equals(Boolean.TYPE)) throw new ObjectAccessException("Could not set field " + object.getClass() + "." + field.getName() + ": Unknown type " + clazz);
                    unsafe.putBoolean(object, l, (Boolean)object2);
                }
                return;
            } else {
                unsafe.putObject(object, l, object2);
            }
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ObjectAccessException("Could not set field " + object.getClass() + "." + field.getName(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ObjectAccessException("Could not set field " + object.getClass() + "." + field.getName(), illegalAccessException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ObjectAccessException("Could not set field " + object.getClass() + "." + field.getName(), noSuchFieldException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ObjectAccessException("Could not set field " + object.getClass() + "." + field.getName(), classNotFoundException);
        }
    }

    protected void validateFieldAccess(Field field) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

