/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream;

import com.thoughtworks.xstream.MarshallingStrategy;
import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.DefaultClassMapper;
import com.thoughtworks.xstream.core.DefaultConverterLookup;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.core.ReferenceByIdMarshallingStrategy;
import com.thoughtworks.xstream.core.ReferenceByXPathMarshallingStrategy;
import com.thoughtworks.xstream.core.TreeMarshallingStrategy;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class XStream {
    private HierarchicalStreamDriver hierarchicalStreamDriver;
    private MarshallingStrategy marshallingStrategy;
    private ClassMapper classMapper;
    private DefaultConverterLookup converterLookup;
    public static final int NO_REFERENCES = 1001;
    public static final int ID_REFERENCES = 1002;
    public static final int XPATH_REFERENCES = 1003;

    public XStream() {
        this(JVM.bestReflectionProvider(), new DefaultClassMapper(), new XppDriver());
    }

    public XStream(HierarchicalStreamDriver hierarchicalStreamDriver) {
        this(JVM.bestReflectionProvider(), new DefaultClassMapper(), hierarchicalStreamDriver);
    }

    public XStream(ReflectionProvider reflectionProvider) {
        this(reflectionProvider, new DefaultClassMapper(), new XppDriver());
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver hierarchicalStreamDriver) {
        this(reflectionProvider, new DefaultClassMapper(), hierarchicalStreamDriver);
    }

    public XStream(ReflectionProvider reflectionProvider, ClassMapper classMapper, HierarchicalStreamDriver hierarchicalStreamDriver) {
        this(reflectionProvider, classMapper, hierarchicalStreamDriver, "class");
    }

    public XStream(ReflectionProvider reflectionProvider, ClassMapper classMapper, HierarchicalStreamDriver hierarchicalStreamDriver, String string) {
        this.classMapper = classMapper;
        this.hierarchicalStreamDriver = hierarchicalStreamDriver;
        this.setMode(1003);
        this.converterLookup = new DefaultConverterLookup(reflectionProvider, classMapper, string);
        this.converterLookup.setupDefaults();
    }

    public void setMarshallingStrategy(MarshallingStrategy marshallingStrategy) {
        this.marshallingStrategy = marshallingStrategy;
    }

    public String toXML(Object object) {
        StringWriter stringWriter = new StringWriter();
        PrettyPrintWriter prettyPrintWriter = new PrettyPrintWriter(stringWriter);
        this.marshal(object, prettyPrintWriter);
        return ((Object)stringWriter).toString();
    }

    public void toXML(Object object, Writer writer) {
        this.marshal(object, new PrettyPrintWriter(writer));
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter) {
        this.marshallingStrategy.marshal(hierarchicalStreamWriter, object, this.converterLookup, this.classMapper);
    }

    public Object fromXML(String string) {
        return this.fromXML(new StringReader(string));
    }

    public Object fromXML(Reader reader) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(reader), null);
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader) {
        return this.unmarshal(hierarchicalStreamReader, null);
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, Object object) {
        return this.marshallingStrategy.unmarshal(object, hierarchicalStreamReader, this.converterLookup, this.classMapper);
    }

    public void alias(String string, Class clazz) {
        this.converterLookup.alias(string, clazz, clazz);
    }

    public void alias(String string, Class clazz, Class clazz2) {
        this.converterLookup.alias(string, clazz, clazz2);
    }

    public void registerConverter(Converter converter) {
        this.converterLookup.registerConverter(converter);
    }

    public ClassMapper getClassMapper() {
        return this.classMapper;
    }

    public ConverterLookup getConverterLookup() {
        return this.converterLookup;
    }

    public void setMode(int n) {
        switch (n) {
            case 1001: {
                this.setMarshallingStrategy(new TreeMarshallingStrategy());
                break;
            }
            case 1002: {
                this.setMarshallingStrategy(new ReferenceByIdMarshallingStrategy());
                break;
            }
            case 1003: {
                this.setMarshallingStrategy(new ReferenceByXPathMarshallingStrategy());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode : " + n);
            }
        }
    }
}

