/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime;

import java.util.Date;
import org.jibx.runtime.JiBXException;

public abstract class Utility {
    private static final int MSPERMINUTE = 60000;
    private static final int MSPERHOUR = 3600000;
    private static final int MSPERDAY = 86400000;
    private static final long LMSPERDAY = 86400000L;
    private static final long MSPERYEAR = 31536000000L;
    private static final long MSPERAVGYEAR = 31557600000L;
    private static final long MSPERCENTURY = 3155695200000L;
    private static final long TIME_BASE = 62135596800000L;
    private static final int[] MONTHS_NONLEAP = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static final int[] MONTHS_LEAP = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};
    private static final long[] BIAS_MONTHMS = new long[]{0L, 0L, 0L, 0L, 2678400000L, 5270400000L, 7948800000L, 10540800000L, 13219200000L, 15897600000L, 18489600000L, 21168000000L, 23760000000L, 26438400000L, 29116800000L};

    private static int parseDigits(String text, int offset, int length) throws JiBXException {
        int value = 0;
        if (length > 9) {
            try {
                value = Integer.parseInt(text.substring(offset, offset + length));
            }
            catch (NumberFormatException ex) {
                throw new JiBXException(ex.getMessage());
            }
        } else {
            int limit = offset + length;
            while (offset < limit) {
                char chr;
                if ((chr = text.charAt(offset++)) >= '0' && chr <= '9') {
                    value = value * 10 + (chr - 48);
                    continue;
                }
                throw new JiBXException("Non-digit in number value");
            }
        }
        return value;
    }

    public static int parseInt(String text) throws JiBXException {
        text = text.trim();
        int offset = 0;
        int limit = text.length();
        if (limit == 0) {
            throw new JiBXException("Empty number value");
        }
        boolean negate = false;
        char chr = text.charAt(0);
        if (chr == '-') {
            if (limit > 9) {
                try {
                    return Integer.parseInt(text);
                }
                catch (NumberFormatException ex) {
                    throw new JiBXException(ex.getMessage());
                }
            }
            negate = true;
            ++offset;
        } else if (chr == '+') {
            ++offset;
        }
        if (offset >= limit) {
            throw new JiBXException("Invalid number format");
        }
        int value = Utility.parseDigits(text, offset, limit - offset);
        if (negate) {
            return -value;
        }
        return value;
    }

    public static String serializeInt(int value) {
        return Integer.toString(value);
    }

    public static long parseLong(String text) throws JiBXException {
        text = text.trim();
        int offset = 0;
        int limit = text.length();
        if (limit == 0) {
            throw new JiBXException("Empty number value");
        }
        boolean negate = false;
        char chr = text.charAt(0);
        if (chr == '-') {
            negate = true;
            ++offset;
        } else if (chr == '+') {
            ++offset;
        }
        if (offset >= limit) {
            throw new JiBXException("Invalid number format");
        }
        long value = 0L;
        if (limit - offset > 18) {
            if (chr == '+') {
                text = text.substring(1);
            }
            try {
                value = Long.parseLong(text);
            }
            catch (NumberFormatException ex) {
                throw new JiBXException(ex.getMessage());
            }
        } else {
            while (offset < limit) {
                if ((chr = text.charAt(offset++)) >= '0' && chr <= '9') {
                    value = value * 10L + (long)(chr - 48);
                    continue;
                }
                throw new JiBXException("Non-digit in number value");
            }
            if (negate) {
                value = -value;
            }
        }
        return value;
    }

    public static String serializeLong(long value) {
        return Long.toString(value);
    }

    public static short parseShort(String text) throws JiBXException {
        int value = Utility.parseInt(text);
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new JiBXException("Value out of range");
        }
        return (short)value;
    }

    public static String serializeShort(short value) {
        return Short.toString(value);
    }

    public static byte parseByte(String text) throws JiBXException {
        int value = Utility.parseInt(text);
        if (value < -128 || value > 127) {
            throw new JiBXException("Value out of range");
        }
        return (byte)value;
    }

    public static String serializeByte(byte value) {
        return Byte.toString(value);
    }

    public static boolean parseBoolean(String text) throws JiBXException {
        if ("true".equals(text = text.trim()) || "1".equals(text)) {
            return true;
        }
        if ("false".equals(text) || "0".equals(text)) {
            return false;
        }
        throw new JiBXException("Invalid boolean value");
    }

    public static String serializeBoolean(boolean value) {
        return value ? "true" : "false";
    }

    public static char parseChar(String text) throws JiBXException {
        int value = Utility.parseInt(text);
        if (value < 0 || value > 65535) {
            throw new JiBXException("Value out of range");
        }
        return (char)value;
    }

    public static String serializeChar(char value) {
        return Integer.toString(value);
    }

    public static float parseFloat(String text) throws JiBXException {
        if ("-INF".equals(text = text.trim())) {
            return Float.NEGATIVE_INFINITY;
        }
        if ("INF".equals(text)) {
            return Float.POSITIVE_INFINITY;
        }
        try {
            return Float.parseFloat(text);
        }
        catch (NumberFormatException ex) {
            throw new JiBXException(ex.getMessage());
        }
    }

    public static String serializeFloat(float value) {
        if (Float.isInfinite(value)) {
            return value < 0.0f ? "-INF" : "INF";
        }
        return Float.toString(value);
    }

    public static double parseDouble(String text) throws JiBXException {
        if ("-INF".equals(text = text.trim())) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("INF".equals(text)) {
            return Double.POSITIVE_INFINITY;
        }
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException ex) {
            throw new JiBXException(ex.getMessage());
        }
    }

    public static String serializeDouble(double value) {
        if (Double.isInfinite(value)) {
            return value < 0.0 ? "-INF" : "INF";
        }
        return Double.toString(value);
    }

    public static long parseYear(String text) throws JiBXException {
        text = text.trim();
        boolean valid = true;
        int minc = 4;
        char chr = text.charAt(0);
        if (chr == '-') {
            minc = 5;
        } else if (chr == '+') {
            valid = false;
        }
        if (text.length() < minc) {
            valid = false;
        }
        if (!valid) {
            throw new JiBXException("Invalid year format");
        }
        int year = Utility.parseInt(text);
        if (year == 0) {
            throw new JiBXException("Year value 0 is not allowed");
        }
        if (year > 0) {
            --year;
        }
        long day = (long)year * 365L + (long)(year / 4) - (long)(year / 100) + (long)(year / 400);
        return day * 86400000L - 62135596800000L;
    }

    public static long parseYearMonth(String text) throws JiBXException {
        boolean leap;
        text = text.trim();
        boolean valid = true;
        int minc = 7;
        char chr = text.charAt(0);
        if (chr == '-') {
            minc = 8;
        } else if (chr == '+') {
            valid = false;
        }
        int split = text.length() - 3;
        if (text.length() < minc) {
            valid = false;
        } else if (text.charAt(split) != '-') {
            valid = false;
        }
        if (!valid) {
            throw new JiBXException("Invalid date format");
        }
        int year = Utility.parseInt(text.substring(0, split));
        if (year == 0) {
            throw new JiBXException("Year value 0 is not allowed");
        }
        int month = Utility.parseDigits(text, split + 1, 2) - 1;
        if (month < 0 || month > 11) {
            throw new JiBXException("Month value out of range");
        }
        boolean bl = leap = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        if (year > 0) {
            --year;
        }
        long day = (long)year * 365L + (long)(year / 4) - (long)(year / 100) + (long)(year / 400) + (long)(leap ? MONTHS_LEAP : MONTHS_NONLEAP)[month];
        return day * 86400000L - 62135596800000L;
    }

    public static long parseDate(String text) throws JiBXException {
        int[] starts;
        boolean valid = true;
        int minc = 10;
        char chr = text.charAt(0);
        if (chr == '-') {
            minc = 11;
        } else if (chr == '+') {
            valid = false;
        }
        int split = text.length() - 6;
        if (text.length() < minc) {
            valid = false;
        } else if (text.charAt(split) != '-' || text.charAt(split + 3) != '-') {
            valid = false;
        }
        if (!valid) {
            throw new JiBXException("Invalid date format");
        }
        int year = Utility.parseInt(text.substring(0, split));
        if (year == 0) {
            throw new JiBXException("Year value 0 is not allowed");
        }
        int month = Utility.parseDigits(text, split + 1, 2) - 1;
        if (month < 0 || month > 11) {
            throw new JiBXException("Month value out of range");
        }
        long day = Utility.parseDigits(text, split + 4, 2) - 1;
        boolean leap = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        int[] nArray = starts = leap ? MONTHS_LEAP : MONTHS_NONLEAP;
        if (day < 0L || day >= (long)(starts[month + 1] - starts[month])) {
            throw new JiBXException("Day value out of range");
        }
        if (year > 0) {
            --year;
        }
        return (day += (long)year * 365L + (long)(year / 4) - (long)(year / 100) + (long)(year / 400) + (long)starts[month]) * 86400000L - 62135596800000L;
    }

    public static Date deserializeDate(String text) throws JiBXException {
        if (text == null) {
            return null;
        }
        return new Date(Utility.parseDate(text));
    }

    public static long parseDateTime(String text) throws JiBXException {
        boolean valid;
        int split = text.indexOf(84);
        if (split < 0) {
            throw new JiBXException("Missing 'T' separator in dateTime");
        }
        long result = Utility.parseDate(text.substring(0, split));
        int limit = text.length();
        boolean bl = valid = limit > split + 8 && text.charAt(split + 3) == ':' && text.charAt(split + 6) == ':';
        if (valid) {
            int hour = Utility.parseDigits(text, split + 1, 2);
            int minute = Utility.parseDigits(text, split + 4, 2);
            int second = Utility.parseDigits(text, split + 7, 2);
            if (hour > 23 || minute > 59 || second > 60) {
                valid = false;
            } else {
                int milli = ((hour * 60 + minute) * 60 + second) * 1000;
                if (limit > (split += 9)) {
                    if (text.charAt(limit - 1) == 'Z') {
                        --limit;
                    } else {
                        char chr = text.charAt(limit - 6);
                        if (chr == '-' || chr == '+') {
                            hour = Utility.parseDigits(text, limit - 5, 2);
                            minute = Utility.parseDigits(text, limit - 2, 2);
                            if (hour > 23 || minute > 59) {
                                valid = false;
                            } else {
                                int offset = (hour * 60 + minute) * 60 * 1000;
                                milli = chr == '-' ? (milli += offset) : (milli -= offset);
                            }
                            limit -= 6;
                        }
                    }
                    if (text.charAt(split) == '.') {
                        double fraction = Double.parseDouble(text.substring(split, limit));
                        milli = (int)((double)milli + fraction * 1000.0);
                    } else if (limit > split) {
                        valid = false;
                    }
                }
                result += (long)milli;
            }
        }
        if (valid) {
            return result;
        }
        throw new JiBXException("Invalid dateTime format");
    }

    public static Date deserializeDateTime(String text) throws JiBXException {
        if (text == null) {
            return null;
        }
        return new Date(Utility.parseDateTime(text));
    }

    protected static void formatYearNumber(long year, StringBuffer buff) {
        if (year <= 0L) {
            buff.append('-');
            year = -(year - 1L);
        }
        if (year < 1000L) {
            buff.append('0');
            if (year < 100L) {
                buff.append('0');
                if (year < 10L) {
                    buff.append('0');
                }
            }
        }
        buff.append(year);
    }

    protected static void formatTwoDigits(int value, StringBuffer buff) {
        if (value < 10) {
            buff.append('0');
        }
        buff.append(value);
    }

    protected static void formatYear(long value, StringBuffer buff) {
        long yms;
        int yday;
        int month;
        long time = value + 26438400000L + 64800000L;
        long century = time / 3155695200000L;
        long adjusted = time + (century - century / 4L) * 86400000L;
        int year = (int)(adjusted / 31557600000L);
        if (adjusted < 0L) {
            --year;
        }
        if ((month = (5 * (yday = (int)((yms = adjusted + 21600000L - (long)(year * 365 + year / 4) * 86400000L) / 86400000L)) + 456) / 153) > 12) {
            ++year;
        }
        Utility.formatYearNumber(year, buff);
    }

    protected static long formatYearMonth(long value, StringBuffer buff) {
        long yms;
        int yday;
        long time = value + 26438400000L + 64800000L;
        long century = time / 3155695200000L;
        long adjusted = time + (century - century / 4L) * 86400000L;
        int year = (int)(adjusted / 31557600000L);
        if (adjusted < 0L) {
            --year;
        }
        if ((yday = (int)((yms = adjusted + 21600000L - (long)(year * 365 + year / 4) * 86400000L) / 86400000L)) == 0) {
            int dcnt;
            boolean bce;
            boolean bl = bce = year < 0;
            if (bce) {
                --year;
            }
            int n = dcnt = year % 4 == 0 ? 366 : 365;
            if (!bce) {
                --year;
            }
            yms += (long)dcnt * 86400000L;
            yday += dcnt;
        }
        int month = (5 * yday + 456) / 153;
        long rem = yms - BIAS_MONTHMS[month] - 86400000L;
        if (month > 12) {
            ++year;
            month -= 12;
        }
        Utility.formatYearNumber(year, buff);
        buff.append('-');
        Utility.formatTwoDigits(month, buff);
        return rem;
    }

    protected static int formatYearMonthDay(long value, StringBuffer buff) {
        long extra = Utility.formatYearMonth(value, buff);
        int day = (int)(extra / 86400000L) + 1;
        buff.append('-');
        Utility.formatTwoDigits(day, buff);
        return (int)(extra % 86400000L);
    }

    public static String serializeYear(long time) throws JiBXException {
        StringBuffer buff = new StringBuffer(6);
        Utility.formatYear(time + 62135596800000L, buff);
        return buff.toString();
    }

    public static String serializeYear(Date date) throws JiBXException {
        return Utility.serializeYear(date.getTime());
    }

    public static String serializeYearMonth(long time) throws JiBXException {
        StringBuffer buff = new StringBuffer(12);
        Utility.formatYearMonth(time + 62135596800000L, buff);
        return buff.toString();
    }

    public static String serializeYearMonth(Date date) throws JiBXException {
        return Utility.serializeYearMonth(date.getTime());
    }

    public static String serializeDate(long time) throws JiBXException {
        StringBuffer buff = new StringBuffer(12);
        Utility.formatYearMonthDay(time + 62135596800000L, buff);
        return buff.toString();
    }

    public static String serializeDate(Date date) throws JiBXException {
        return Utility.serializeDate(date.getTime());
    }

    public static String serializeDateTime(long time) throws JiBXException {
        StringBuffer buff = new StringBuffer(24);
        int extra = Utility.formatYearMonthDay(time + 62135596800000L, buff);
        buff.append('T');
        Utility.formatTwoDigits(extra / 3600000, buff);
        buff.append(':');
        Utility.formatTwoDigits((extra %= 3600000) / 60000, buff);
        buff.append(':');
        Utility.formatTwoDigits((extra %= 60000) / 1000, buff);
        if ((extra %= 1000) > 0) {
            buff.append('.');
            buff.append(extra / 100);
            if ((extra %= 100) > 0) {
                buff.append(extra / 10);
                if ((extra %= 10) > 0) {
                    buff.append(extra);
                }
            }
        }
        return buff.toString();
    }

    public static String serializeDateTime(Date date) throws JiBXException {
        return Utility.serializeDateTime(date.getTime());
    }

    public static boolean isEqual(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public static int enumValue(String target, String[] enums, int[] vals) throws JiBXException {
        int base = 0;
        int limit = enums.length - 1;
        while (base <= limit) {
            int cur = base + limit >> 1;
            int diff = target.compareTo(enums[cur]);
            if (diff < 0) {
                limit = cur - 1;
                continue;
            }
            if (diff > 0) {
                base = cur + 1;
                continue;
            }
            if (vals != null) {
                return vals[cur];
            }
            return cur;
        }
        throw new JiBXException("Target value \"" + target + "\" not found in enumeration");
    }
}

