/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ActionElement;
import antlr.ActionTransInfo;
import antlr.Alternative;
import antlr.AlternativeBlock;
import antlr.AlternativeElement;
import antlr.BlockEndElement;
import antlr.CharLiteralElement;
import antlr.CharRangeElement;
import antlr.CodeGenerator;
import antlr.Grammar;
import antlr.GrammarAtom;
import antlr.GrammarSymbol;
import antlr.JavaCharFormatter;
import antlr.LexerGrammar;
import antlr.Lookahead;
import antlr.MakeGrammar;
import antlr.OneOrMoreBlock;
import antlr.ParserGrammar;
import antlr.RuleBlock;
import antlr.RuleRefElement;
import antlr.RuleSymbol;
import antlr.StringLiteralElement;
import antlr.SynPredBlock;
import antlr.TokenManager;
import antlr.TokenRangeElement;
import antlr.TokenRefElement;
import antlr.Tool;
import antlr.TreeElement;
import antlr.TreeWalkerGrammar;
import antlr.WildcardElement;
import antlr.ZeroOrMoreBlock;
import antlr.collections.impl.Vector;
import java.io.IOException;
import java.util.Enumeration;

public class DocBookCodeGenerator
extends CodeGenerator {
    protected int syntacticPredLevel = 0;
    protected boolean doingLexRules = false;
    protected boolean firstElementInAlt;
    protected AlternativeElement prevAltElem = null;

    public DocBookCodeGenerator() {
        this.charFormatter = new JavaCharFormatter();
    }

    static String HTMLEncode(String s) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        int len = s.length();
        while (i < len) {
            char c = s.charAt(i);
            if (c == '&') {
                buf.append("&amp;");
            } else if (c == '\"') {
                buf.append("&quot;");
            } else if (c == '\'') {
                buf.append("&#039;");
            } else if (c == '<') {
                buf.append("&lt;");
            } else if (c == '>') {
                buf.append("&gt;");
            } else {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    static String QuoteForId(String s) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        int len = s.length();
        while (i < len) {
            char c = s.charAt(i);
            if (c == '_') {
                buf.append(".");
            } else {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    public void gen() {
        try {
            Enumeration grammarIter = this.behavior.grammars.elements();
            while (grammarIter.hasMoreElements()) {
                Grammar g = (Grammar)grammarIter.nextElement();
                g.setCodeGenerator(this);
                g.generate();
                if (!this.antlrTool.hasError()) continue;
                this.antlrTool.fatalError("Exiting due to errors.");
            }
        }
        catch (IOException e) {
            this.antlrTool.reportException(e, null);
        }
    }

    public void gen(ActionElement action) {
    }

    public void gen(AlternativeBlock blk) {
        this.genGenericBlock(blk, "");
    }

    public void gen(BlockEndElement end) {
    }

    public void gen(CharLiteralElement atom) {
        if (atom.not) {
            this._print("~");
        }
        this._print(String.valueOf(DocBookCodeGenerator.HTMLEncode(atom.atomText)) + " ");
    }

    public void gen(CharRangeElement r) {
        this.print(String.valueOf(r.beginText) + ".." + r.endText + " ");
    }

    public void gen(LexerGrammar g) throws IOException {
        this.setGrammar(g);
        this.antlrTool.reportProgress("Generating " + this.grammar.getClassName() + ".html");
        this.currentOutput = this.antlrTool.openOutputFile(String.valueOf(this.grammar.getClassName()) + ".html");
        this.tabs = 0;
        this.doingLexRules = true;
        this.genHeader();
        this.println("");
        if (this.grammar.comment != null) {
            this._println(DocBookCodeGenerator.HTMLEncode(this.grammar.comment));
        }
        this.println("<para>Definition of lexer " + this.grammar.getClassName() + ", which is a subclass of " + this.grammar.getSuperClass() + ".</para>");
        this.genNextToken();
        Enumeration ids = this.grammar.rules.elements();
        while (ids.hasMoreElements()) {
            RuleSymbol rs = (RuleSymbol)ids.nextElement();
            if (rs.id.equals("mnextToken")) continue;
            this.genRule(rs);
        }
        this.currentOutput.close();
        this.currentOutput = null;
        this.doingLexRules = false;
    }

    public void gen(OneOrMoreBlock blk) {
        this.genGenericBlock(blk, "+");
    }

    public void gen(ParserGrammar g) throws IOException {
        this.setGrammar(g);
        this.antlrTool.reportProgress("Generating " + this.grammar.getClassName() + ".sgml");
        this.currentOutput = this.antlrTool.openOutputFile(String.valueOf(this.grammar.getClassName()) + ".sgml");
        this.tabs = 0;
        this.genHeader();
        this.println("");
        if (this.grammar.comment != null) {
            this._println(DocBookCodeGenerator.HTMLEncode(this.grammar.comment));
        }
        this.println("<para>Definition of parser " + this.grammar.getClassName() + ", which is a subclass of " + this.grammar.getSuperClass() + ".</para>");
        Enumeration rules = this.grammar.rules.elements();
        while (rules.hasMoreElements()) {
            this.println("");
            GrammarSymbol sym = (GrammarSymbol)rules.nextElement();
            if (!(sym instanceof RuleSymbol)) continue;
            this.genRule((RuleSymbol)sym);
        }
        --this.tabs;
        this.println("");
        this.genTail();
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(RuleRefElement rr) {
        RuleSymbol cfr_ignored_0 = (RuleSymbol)this.grammar.getSymbol(rr.targetRule);
        this._print("<link linkend=\"" + DocBookCodeGenerator.QuoteForId(rr.targetRule) + "\">");
        this._print(rr.targetRule);
        this._print("</link>");
        this._print(" ");
    }

    public void gen(StringLiteralElement atom) {
        if (atom.not) {
            this._print("~");
        }
        this._print(DocBookCodeGenerator.HTMLEncode(atom.atomText));
        this._print(" ");
    }

    public void gen(TokenRangeElement r) {
        this.print(String.valueOf(r.beginText) + ".." + r.endText + " ");
    }

    public void gen(TokenRefElement atom) {
        if (atom.not) {
            this._print("~");
        }
        this._print(atom.atomText);
        this._print(" ");
    }

    public void gen(TreeElement t) {
        this.print(t + " ");
    }

    public void gen(TreeWalkerGrammar g) throws IOException {
        this.setGrammar(g);
        this.antlrTool.reportProgress("Generating " + this.grammar.getClassName() + ".sgml");
        this.currentOutput = this.antlrTool.openOutputFile(String.valueOf(this.grammar.getClassName()) + ".sgml");
        this.tabs = 0;
        this.genHeader();
        this.println("");
        this.println("");
        if (this.grammar.comment != null) {
            this._println(DocBookCodeGenerator.HTMLEncode(this.grammar.comment));
        }
        this.println("<para>Definition of tree parser " + this.grammar.getClassName() + ", which is a subclass of " + this.grammar.getSuperClass() + ".</para>");
        this.println("");
        ++this.tabs;
        Enumeration rules = this.grammar.rules.elements();
        while (rules.hasMoreElements()) {
            this.println("");
            GrammarSymbol sym = (GrammarSymbol)rules.nextElement();
            if (!(sym instanceof RuleSymbol)) continue;
            this.genRule((RuleSymbol)sym);
        }
        --this.tabs;
        this.println("");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(WildcardElement wc) {
        this._print(". ");
    }

    public void gen(ZeroOrMoreBlock blk) {
        this.genGenericBlock(blk, "*");
    }

    protected void genAlt(Alternative alt) {
        if (alt.getTreeSpecifier() != null) {
            this._print(alt.getTreeSpecifier().getText());
        }
        this.prevAltElem = null;
        AlternativeElement elem = alt.head;
        while (!(elem instanceof BlockEndElement)) {
            elem.generate();
            this.firstElementInAlt = false;
            this.prevAltElem = elem;
            elem = elem.next;
        }
    }

    public void genCommonBlock(AlternativeBlock blk) {
        if (blk.alternatives.size() > 1) {
            this.println("<itemizedlist mark=\"none\">");
        }
        int i = 0;
        while (i < blk.alternatives.size()) {
            Alternative alt = blk.getAlternativeAt(i);
            AlternativeElement cfr_ignored_0 = alt.head;
            if (blk.alternatives.size() > 1) {
                this.print("<listitem><para>");
            }
            if (i > 0 && blk.alternatives.size() > 1) {
                this._print("| ");
            }
            boolean save = this.firstElementInAlt;
            this.firstElementInAlt = true;
            ++this.tabs;
            this.genAlt(alt);
            --this.tabs;
            this.firstElementInAlt = save;
            if (blk.alternatives.size() > 1) {
                this._println("</para></listitem>");
            }
            ++i;
        }
        if (blk.alternatives.size() > 1) {
            this.println("</itemizedlist>");
        }
    }

    public void genFollowSetForRuleBlock(RuleBlock blk) {
        Lookahead follow = this.grammar.theLLkAnalyzer.FOLLOW(1, blk.endNode);
        this.printSet(this.grammar.maxk, 1, follow);
    }

    protected void genGenericBlock(AlternativeBlock blk, String blkOp) {
        if (blk.alternatives.size() > 1) {
            this._println("");
            if (!this.firstElementInAlt) {
                this._println("(");
            } else {
                this._print("(");
            }
        } else {
            this._print("( ");
        }
        this.genCommonBlock(blk);
        if (blk.alternatives.size() > 1) {
            this._println("");
            this.print(")" + blkOp + " ");
            if (!(blk.next instanceof BlockEndElement)) {
                this._println("");
                this.print("");
            }
        } else {
            this._print(")" + blkOp + " ");
        }
    }

    protected void genHeader() {
        this.println("<?xml version=\"1.0\" standalone=\"no\"?>");
        this.println("<!DOCTYPE book PUBLIC \"-//OASIS//DTD DocBook V3.1//EN\">");
        this.println("<book lang=\"en\">");
        this.println("<bookinfo>");
        this.println("<title>Grammar " + this.grammar.getClassName() + "</title>");
        this.println("  <author>");
        this.println("    <firstname></firstname>");
        this.println("    <othername></othername>");
        this.println("    <surname></surname>");
        this.println("    <affiliation>");
        this.println("     <address>");
        this.println("     <email></email>");
        this.println("     </address>");
        this.println("    </affiliation>");
        this.println("  </author>");
        this.println("  <othercredit>");
        this.println("    <contrib>");
        this.println("    Generated by <ulink url=\"http://www.ANTLR.org/\">ANTLR</ulink>" + Tool.version);
        this.println("    from " + this.antlrTool.grammarFile);
        this.println("    </contrib>");
        this.println("  </othercredit>");
        this.println("  <pubdate></pubdate>");
        this.println("  <abstract>");
        this.println("  <para>");
        this.println("  </para>");
        this.println("  </abstract>");
        this.println("</bookinfo>");
        this.println("<chapter>");
        this.println("<title></title>");
    }

    protected void genLookaheadSetForAlt(Alternative alt) {
        if (this.doingLexRules && alt.cache[1].containsEpsilon()) {
            this.println("MATCHES ALL");
            return;
        }
        int depth = alt.lookaheadDepth;
        if (depth == Integer.MAX_VALUE) {
            depth = this.grammar.maxk;
        }
        int i = 1;
        while (i <= depth) {
            Lookahead lookahead = alt.cache[i];
            this.printSet(depth, i, lookahead);
            ++i;
        }
    }

    public void genLookaheadSetForBlock(AlternativeBlock blk) {
        int depth = 0;
        int i = 0;
        while (i < blk.alternatives.size()) {
            Alternative alt = blk.getAlternativeAt(i);
            if (alt.lookaheadDepth == Integer.MAX_VALUE) {
                depth = this.grammar.maxk;
                break;
            }
            if (depth < alt.lookaheadDepth) {
                depth = alt.lookaheadDepth;
            }
            ++i;
        }
        i = 1;
        while (i <= depth) {
            Lookahead lookahead = this.grammar.theLLkAnalyzer.look(i, blk);
            this.printSet(depth, i, lookahead);
            ++i;
        }
    }

    public void genNextToken() {
        this.println("");
        this.println("/** Lexer nextToken rule:");
        this.println(" *  The lexer nextToken rule is synthesized from all of the user-defined");
        this.println(" *  lexer rules.  It logically consists of one big alternative block with");
        this.println(" *  each user-defined rule being an alternative.");
        this.println(" */");
        RuleBlock blk = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
        RuleSymbol nextTokenRs = new RuleSymbol("mnextToken");
        nextTokenRs.setDefined();
        nextTokenRs.setBlock(blk);
        nextTokenRs.access = "private";
        this.grammar.define(nextTokenRs);
        this.genCommonBlock(blk);
    }

    public void genRule(RuleSymbol s) {
        if (s == null || !s.isDefined()) {
            return;
        }
        this.println("");
        if (s.access.length() != 0 && !s.access.equals("public")) {
            this._print("<para>" + s.access + " </para>");
        }
        this.println("<section id=\"" + DocBookCodeGenerator.QuoteForId(s.getId()) + "\">");
        this.println("<title>" + s.getId() + "</title>");
        if (s.comment != null) {
            this._println("<para>" + DocBookCodeGenerator.HTMLEncode(s.comment) + "</para>");
        }
        this.println("<para>");
        RuleBlock rblk = s.getBlock();
        this._println("");
        this.print(String.valueOf(s.getId()) + ":\t");
        ++this.tabs;
        this.genCommonBlock(rblk);
        this._println("");
        --this.tabs;
        this._println("</para>");
        this._println("</section><!-- section \"" + s.getId() + "\" -->");
    }

    protected void genSynPred(SynPredBlock blk) {
    }

    public void genTail() {
        this.println("</chapter>");
        this.println("</book>");
    }

    protected void genTokenTypes(TokenManager tm) throws IOException {
        this.antlrTool.reportProgress("Generating " + tm.getName() + CodeGenerator.TokenTypesFileSuffix + CodeGenerator.TokenTypesFileExt);
        this.currentOutput = this.antlrTool.openOutputFile(String.valueOf(tm.getName()) + CodeGenerator.TokenTypesFileSuffix + CodeGenerator.TokenTypesFileExt);
        this.tabs = 0;
        this.genHeader();
        this.println("");
        this.println("*** Tokens used by the parser");
        this.println("This is a list of the token numeric values and the corresponding");
        this.println("token identifiers.  Some tokens are literals, and because of that");
        this.println("they have no identifiers.  Literals are double-quoted.");
        ++this.tabs;
        Vector v = tm.getVocabulary();
        int i = 4;
        while (i < v.size()) {
            String s = (String)v.elementAt(i);
            if (s != null) {
                this.println(String.valueOf(s) + " = " + i);
            }
            ++i;
        }
        --this.tabs;
        this.println("*** End of tokens used by the parser");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    protected String processActionForSpecialSymbols(String actionStr, int line, RuleBlock currentRule, ActionTransInfo tInfo) {
        return actionStr;
    }

    public String getASTCreateString(Vector v) {
        return null;
    }

    public String getASTCreateString(GrammarAtom atom, String str) {
        return null;
    }

    public String mapTreeId(String id, ActionTransInfo tInfo) {
        return id;
    }

    public void printSet(int depth, int k, Lookahead lookahead) {
        int numCols = 5;
        int[] elems = lookahead.fset.toArray();
        if (depth != 1) {
            this.print("k==" + k + ": {");
        } else {
            this.print("{ ");
        }
        if (elems.length > numCols) {
            this._println("");
            ++this.tabs;
            this.print("");
        }
        int column = 0;
        int i = 0;
        while (i < elems.length) {
            if (++column > numCols) {
                this._println("");
                this.print("");
                column = 0;
            }
            if (this.doingLexRules) {
                this._print(this.charFormatter.literalChar(elems[i]));
            } else {
                this._print((String)this.grammar.tokenManager.getVocabulary().elementAt(elems[i]));
            }
            if (i != elems.length - 1) {
                this._print(", ");
            }
            ++i;
        }
        if (elems.length > numCols) {
            this._println("");
            --this.tabs;
            this.print("");
        }
        this._println(" }");
    }
}

