/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.CharFormatter;

class CppCharFormatter
implements CharFormatter {
    CppCharFormatter() {
    }

    public String escapeChar(int c, boolean forCharLiteral) {
        switch (c) {
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 13: {
                return "\\r";
            }
            case 92: {
                return "\\\\";
            }
            case 39: {
                return "\\'";
            }
            case 34: {
                return "\\\"";
            }
        }
        if (c < 32 || c > 126) {
            if (c > 255) {
                String s = Integer.toString(c, 16);
                while (s.length() < 4) {
                    s = String.valueOf('0') + s;
                }
                return "\\u" + s;
            }
            return "\\" + Integer.toString(c, 8);
        }
        return String.valueOf((char)c);
    }

    public String escapeString(String s) {
        String retval = new String();
        int i = 0;
        while (i < s.length()) {
            retval = String.valueOf(retval) + this.escapeChar(s.charAt(i), false);
            ++i;
        }
        return retval;
    }

    public String literalChar(int c) {
        String ret = "0x" + Integer.toString(c, 16);
        if (c >= 0 && c <= 126) {
            ret = String.valueOf(ret) + " /* '" + this.escapeChar(c, true) + "' */ ";
        }
        return ret;
    }

    public String literalString(String s) {
        return "\"" + this.escapeString(s) + "\"";
    }
}

