/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.toolkits.bandera;

import edu.ksu.cis.bandera.tool.Tool;
import edu.ksu.cis.bandera.tool.ToolConfigurationView;
import edu.ksu.cis.bandera.tool.ToolIconView;
import edu.ksu.cis.bandera.util.BaseObservable;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.CompleteStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.interfaces.IEscapeInfo;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.processing.Environment;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IStmtSequencesRetriever;
import edu.ksu.cis.indus.processing.OneAllStmtSequenceRetriever;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CGBasedXMLizingProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.callgraphs.OFABasedCallInfoCollector;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.LockAcquisitionBasedEquivalence;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv3;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.flow.processors.ThreadGraph;
import edu.ksu.cis.indus.staticanalyses.interfaces.IAnalysis;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.AbstractValueAnalyzerBasedProcessor;
import edu.ksu.cis.indus.staticanalyses.processing.AnalysesController;
import edu.ksu.cis.indus.staticanalyses.processing.CGBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.processing.ValueAnalyzerBasedProcessingController;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import edu.ksu.cis.indus.staticanalyses.tokens.TokenUtil;
import edu.ksu.cis.indus.staticanalyses.tokens.soot.SootValueTypeManager;
import edu.ksu.cis.indus.toolkits.bandera.DependenceAndMayFollowInfoCalculator;
import edu.ksu.cis.indus.toolkits.bandera.DependenceAndMayFollowInfoCalculatorV2;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Value;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RelativeDependenceInfoTool
extends BaseObservable
implements Tool {
    public static final Comparable<String> ROOT_METHODS = "entryPoints";
    public static final Comparable<String> SCENE = "scene";
    public static final Comparable<String> SERIALIZE_DATA_OUTPUT = "SerializedDataMap";
    static final Logger LOGGER = LoggerFactory.getLogger(RelativeDependenceInfoTool.class);
    static final String SYNC_METHOD_LOCATION = "sync";
    static final String THROWEX_METHOD_LOCATION = "throwEx";
    static final String UNSYNC_METHOD_LOCATION = "unsync";
    static final String UNSYNCEX_METHOD_LOCATION = "unsyncEx";
    private static final List<Comparable<?>> IN_ARGUMENTS_IDS = new ArrayList();
    private static final String METHOD_PREFIX = "{|";
    private static final String METHOD_SUFFIX = "|}";
    private static final List<Comparable<?>> OUT_ARGUMENTS_IDS;
    boolean arrayRefInApplicationClassesOnly;
    final Collection<String> arrayRefs = new HashSet<String>();
    final Collection<String> atomicMethodSignatures = new HashSet<String>();
    final Collection<String> nonAtomicSealedMethodSignatures = new HashSet<String>();
    final Map<String, Collection<String>> dependence = new HashMap<String, Collection<String>>();
    boolean fieldRefInApplicationClassesOnly;
    final Collection<String> fieldRefs = new HashSet<String>();
    boolean lockAcqInApplicationClassesOnly;
    final Collection<String> lockAcquisitions = new HashSet<String>();
    final Map<String, Collection<String>> mayFollow = new HashMap<String, Collection<String>>();
    final Collection<String> seenStmts = new HashSet<String>();
    private boolean abort;
    private IEnvironment env;
    private final Map<SootMethod, String> method2birsig = new HashMap<SootMethod, String>();
    private Collection<SootMethod> rootMethods;
    private boolean useV2Calculator;

    static {
        IN_ARGUMENTS_IDS.add(SCENE);
        IN_ARGUMENTS_IDS.add(ROOT_METHODS);
        OUT_ARGUMENTS_IDS = new ArrayList();
        OUT_ARGUMENTS_IDS.add(SERIALIZE_DATA_OUTPUT);
    }

    static String constructMethodName(SootMethod sm) {
        SootClass _sc = sm.getDeclaringClass();
        String _className = _sc.getName();
        String _methodName = sm.getName();
        int _size = sm.getParameterCount();
        String[] _paramTypeNames = new String[_size];
        int _i = 0;
        while (_i < _size) {
            _paramTypeNames[_i] = sm.getParameterType(_i).toString();
            ++_i;
        }
        StringBuffer _sb = new StringBuffer(METHOD_PREFIX);
        _sb.append(_className);
        _sb.append('.');
        _sb.append(_methodName);
        _sb.append('(');
        int _size1 = _paramTypeNames.length;
        if (_size1 > 0) {
            _sb.append(_paramTypeNames[0]);
            int _i2 = 1;
            while (_i2 < _size1) {
                _sb.append(',');
                _sb.append(_paramTypeNames[_i2]);
                ++_i2;
            }
        }
        _sb.append(')');
        _sb.append(METHOD_SUFFIX);
        return _sb.toString();
    }

    public String getConfiguration() throws Exception {
        Properties _result = new Properties();
        _result.setProperty("edu.ksu.cis.indus.toolkits.bandera.ArrayRefsInApplicationClassesOnly", String.valueOf(this.arrayRefInApplicationClassesOnly));
        _result.setProperty("edu.ksu.cis.indus.toolkits.bandera.FieldRefsInApplicationClassesOnly", String.valueOf(this.fieldRefInApplicationClassesOnly));
        _result.setProperty("edu.ksu.cis.indus.toolkits.bandera.LockAcquisitionsInApplicationClassesOnly", String.valueOf(this.lockAcqInApplicationClassesOnly));
        ByteArrayOutputStream _out = new ByteArrayOutputStream();
        _result.store(_out, null);
        return _out.toString();
    }

    public List<Comparable<?>> getInputParameterList() {
        return Collections.unmodifiableList(IN_ARGUMENTS_IDS);
    }

    public Map<Comparable<String>, Map<Object, Object>> getOutputMap() {
        HashMap<Object, Object> _map = new HashMap<Object, Object>();
        _map.put(Constants.DEPENDENCE, this.dependence);
        _map.put(Constants.KNOWN_TRANSITIONS, this.seenStmts);
        _map.put(Constants.MAY_FOLLOW_RELATION, this.mayFollow);
        _map.put(Constants.LOCK_ACQUISITIONS, this.lockAcquisitions);
        _map.put(Constants.ARRAY_REFS, this.arrayRefs);
        _map.put(Constants.FIELD_REFS, this.fieldRefs);
        _map.put(Constants.ATOMIC_METHODS, this.atomicMethodSignatures);
        _map.put(Constants.NON_ATOMIC_SEALED_METHODS, this.nonAtomicSealedMethodSignatures);
        return Collections.singletonMap(SERIALIZE_DATA_OUTPUT, _map);
    }

    public List<Comparable<?>> getOutputParameterList() {
        return Collections.unmodifiableList(OUT_ARGUMENTS_IDS);
    }

    public ToolConfigurationView getToolConfigurationView() {
        return null;
    }

    public ToolIconView getToolIconView() {
        return null;
    }

    public void quit() throws Exception {
        this.abort = true;
    }

    public void run() throws Exception {
        this.abort = false;
        this.run(this.env, this.rootMethods);
    }

    public void setConfiguration(String arg0) throws Exception {
        Properties _p = new Properties();
        _p.load(new ByteArrayInputStream(arg0.getBytes()));
        this.fieldRefInApplicationClassesOnly = _p.contains("edu.ksu.cis.indus.toolkits.bandera.FieldRefsInApplicationClassesOnly") && Boolean.valueOf(_p.getProperty("edu.ksu.cis.indus.toolkits.bandera.FieldRefsInApplicationClassesOnly")) != false;
        this.arrayRefInApplicationClassesOnly = _p.contains("edu.ksu.cis.indus.toolkits.bandera.ArrayRefsInApplicationClassesOnly") && Boolean.valueOf(_p.getProperty("edu.ksu.cis.indus.toolkits.bandera.ArrayRefsInApplicationClassesOnly")) != false;
        this.lockAcqInApplicationClassesOnly = _p.contains("edu.ksu.cis.indus.toolkits.bandera.LockAcquisitionsInApplicationClassesOnly") && Boolean.valueOf(_p.getProperty("edu.ksu.cis.indus.toolkits.bandera.LockAcquisitionsInApplicationClassesOnly")) != false;
        this.useV2Calculator = _p.contains("edu.ksu.cis.indus.toolkits.bandera.DependenceAndMayFollowInfoCalculator") && _p.getProperty("edu.ksu.cis.indus.toolkits.bandera.DependenceAndMayFollowInfoCalculator").equals(DependenceAndMayFollowInfoCalculatorV2.class.getName());
    }

    public void setInputMap(Map arg) throws Exception {
        Scene _scene = (Scene)arg.get(SCENE);
        if (_scene == null) {
            LOGGER.error("A scene must be provided.");
            throw new IllegalArgumentException("A scene must be provided.");
        }
        this.env = new Environment(_scene);
        Collection _rootMethods = (Collection)arg.get(ROOT_METHODS);
        if (_rootMethods == null || _rootMethods.isEmpty()) {
            LOGGER.error("Atleast one method should be specified as the entry-point into the system.");
            throw new IllegalArgumentException("Atleast one method should be specified as the entry-point into the system.");
        }
        this.rootMethods = new ArrayList<SootMethod>();
        this.rootMethods.addAll(_rootMethods);
    }

    Collection<String> generateBIRRep(Pair<? extends Stmt, SootMethod> p, boolean getUnlocking) {
        String _sig;
        Stmt _stmt = (Stmt)p.getFirst();
        SootMethod _method = (SootMethod)p.getSecond();
        if (this.method2birsig.containsKey(_method)) {
            _sig = this.method2birsig.get(_method);
        } else {
            _sig = RelativeDependenceInfoTool.constructMethodName(_method);
            this.method2birsig.put(_method, _sig);
        }
        ArrayList _sl = new ArrayList(_method.retrieveActiveBody().getUnits());
        int _index = _sl.indexOf(_stmt);
        ArrayList<String> _result = new ArrayList<String>();
        if (_index != -1) {
            _result.add(String.valueOf(_sig) + " loc" + _index);
        } else if (_stmt == null) {
            _result.add(String.valueOf(_sig) + " sync");
            if (getUnlocking) {
                _result.add(String.valueOf(_sig) + " unsync");
                _result.add(String.valueOf(_sig) + " unsyncEx");
                _result.add(String.valueOf(_sig) + " throwEx");
            }
        } else {
            throw new IllegalStateException("Hmm");
        }
        return _result;
    }

    <T extends ITokens<T, Value>> void run(IEnvironment environment, Collection<SootMethod> entryPointMethods) {
        CompleteStmtGraphFactory _stmtGraphFactory = new CompleteStmtGraphFactory();
        IValueAnalyzer _aa = OFAnalyzer.getFSOSAnalyzer("RelativeDependenceInfoTool:FA", TokenUtil.getTokenManager(new SootValueTypeManager()), _stmtGraphFactory);
        if (this.abort) {
            return;
        }
        _aa.analyze(environment, entryPointMethods);
        BasicBlockGraphMgr _bbm = new BasicBlockGraphMgr();
        ValueAnalyzerBasedProcessingController _pc = new ValueAnalyzerBasedProcessingController();
        ArrayList<AbstractValueAnalyzerBasedProcessor> _processors = new ArrayList<AbstractValueAnalyzerBasedProcessor>();
        Pair.PairManager _pairManager = new Pair.PairManager(false, true);
        CallGraphInfo _cgi = new CallGraphInfo(_pairManager);
        CFGAnalysis _cfgAnalysis = new CFGAnalysis(_cgi, _bbm);
        ThreadGraph _tgi = new ThreadGraph(_cgi, _cfgAnalysis, _pairManager);
        ValueAnalyzerBasedProcessingController _cgipc = new ValueAnalyzerBasedProcessingController();
        OFABasedCallInfoCollector _callGraphInfoCollector = new OFABasedCallInfoCollector();
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        _bbm.setStmtGraphFactory((IStmtGraphFactory)_stmtGraphFactory);
        _ssr.setBbgFactory(_bbm);
        _pc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _pc.setAnalyzer(_aa);
        _pc.setProcessingFilter((IProcessingFilter)new TagBasedProcessingFilter("RelativeDependenceInfoTool:FA"));
        _cgipc.setAnalyzer(_aa);
        _cgipc.setProcessingFilter((IProcessingFilter)new CGBasedProcessingFilter(_cgi));
        _cgipc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        HashMap _info = new HashMap();
        _info.put(ICallGraphInfo.ID, (Object)((Object)_cgi));
        _info.put(IThreadGraphInfo.ID, _tgi);
        _info.put(Pair.PairManager.ID, _pairManager);
        _info.put(IEnvironment.ID, _aa.getEnvironment());
        _info.put(IValueAnalyzer.ID, _aa);
        if (this.abort) {
            return;
        }
        _callGraphInfoCollector.reset();
        _processors.clear();
        _processors.add(_callGraphInfoCollector);
        _pc.reset();
        _pc.driveProcessors(_processors);
        _cgi.createCallGraphInfo(_callGraphInfoCollector.getCallInfo());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Call Graph: \n" + _cgi.toString());
        }
        if (this.abort) {
            return;
        }
        _processors.clear();
        _tgi.reset();
        _processors.add(_tgi);
        _cgipc.reset();
        _cgipc.driveProcessors(_processors);
        EquivalenceClassBasedEscapeAnalysis _ecba = new EquivalenceClassBasedEscapeAnalysis(_cgi, _tgi, _bbm);
        _info.put(IEscapeInfo.ID, _ecba.getEscapeInfo());
        AnalysesController _ac = new AnalysesController(_info, _cgipc, _bbm);
        _ac.addAnalyses(EquivalenceClassBasedEscapeAnalysis.ID, (Collection<? extends IAnalysis>)Collections.singleton(_ecba));
        if (this.abort) {
            return;
        }
        InterferenceDAv3 _iDA = new InterferenceDAv3();
        _iDA.setUseOFA(true);
        _ac.addAnalyses((Comparable<?>)((Object)IDependencyAnalysis.DependenceSort.INTERFERENCE_DA), (Collection<? extends IAnalysis>)Collections.singleton(_iDA));
        _ac.initialize();
        _ac.execute();
        ProcessingController _pc2 = new ProcessingController();
        _pc2.setEnvironment(_aa.getEnvironment());
        _pc2.setProcessingFilter((IProcessingFilter)new CGBasedXMLizingProcessingFilter(_cgi));
        _pc2.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        if (this.abort) {
            return;
        }
        for (SootMethod _sm : _cgi.getReachableMethods()) {
            if (_ecba.isMethodAtomic(_sm)) {
                this.atomicMethodSignatures.add(RelativeDependenceInfoTool.constructMethodName(_sm));
                continue;
            }
            if (!_ecba.isMethodSealed(_sm)) continue;
            this.nonAtomicSealedMethodSignatures.add(RelativeDependenceInfoTool.constructMethodName(_sm));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Atomic methods : " + this.atomicMethodSignatures);
            LOGGER.debug("Non-atomic Sealed methods : " + this.nonAtomicSealedMethodSignatures);
        }
        LockAcquisitionBasedEquivalence _lbe = new LockAcquisitionBasedEquivalence(_ecba.getEscapeInfo(), _cgi);
        _lbe.hookup(_pc2);
        _pc2.process();
        _lbe.unhook(_pc2);
        if (this.abort) {
            return;
        }
        DependenceAndMayFollowInfoCalculator _proc = this.useV2Calculator ? new DependenceAndMayFollowInfoCalculatorV2(this, _iDA, _lbe, _cgi, _tgi, _cfgAnalysis, (IStmtGraphFactory<?>)_stmtGraphFactory) : new DependenceAndMayFollowInfoCalculator(this, _iDA, _lbe, _cgi, _tgi, _cfgAnalysis);
        _proc.setApplicationClassFiltering(this.lockAcqInApplicationClassesOnly, this.fieldRefInApplicationClassesOnly, this.arrayRefInApplicationClassesOnly);
        _proc.hookup(_pc2);
        _pc2.process();
        _proc.unhook(_pc2);
    }

    public static final class Constants {
        public static final String APPL_ARRAY_REFS_ONLY = "edu.ksu.cis.indus.toolkits.bandera.ArrayRefsInApplicationClassesOnly";
        public static final String APPL_FIELD_REFS_ONLY = "edu.ksu.cis.indus.toolkits.bandera.FieldRefsInApplicationClassesOnly";
        public static final String APPL_LOCK_ACQS_ONLY = "edu.ksu.cis.indus.toolkits.bandera.LockAcquisitionsInApplicationClassesOnly";
        public static final Object ARRAY_REFS = "edu.ksu.cis.projects.bogor.module.por.indus.DynamicRDPORSchedulingStrategist.arrayRefs";
        public static final String CALCULATOR_CLASS = "edu.ksu.cis.indus.toolkits.bandera.DependenceAndMayFollowInfoCalculator";
        public static final Object ATOMIC_METHODS = "edu.ksu.cis.projects.bogor.module.por.indus.RDPORSchedulingStrategist.atomicMethods";
        public static final Object NON_ATOMIC_SEALED_METHODS = "edu.ksu.cis.projects.bogor.module.por.indus.RDPORSchedulingStrategist.sealedMethods";
        public static final Object DEPENDENCE = "edu.ksu.cis.projects.bogor.module.por.indus.RDPORSchedulingStrategist.dependence";
        public static final Object FIELD_REFS = "edu.ksu.cis.projects.bogor.module.por.indus.DynamicRDPORSchedulingStrategist.fieldRefs";
        public static final Object KNOWN_TRANSITIONS = "edu.ksu.cis.projects.bogor.module.por.indus.RDPORSchedulingStrategist.knowntransitions";
        public static final Object LOCK_ACQUISITIONS = "edu.ksu.cis.projects.bogor.module.por.indus.DynamicRDPORSchedulingStrategist.lockAcquisitions";
        public static final Object MAY_FOLLOW_RELATION = "edu.ksu.cis.projects.bogor.module.por.indus.RDPORSchedulingStrategist.mayfollow";

        private Constants() {
        }
    }
}

