/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.toolkits.bandera;

import edu.ksu.cis.bandera.tool.ToolConfigurationView;
import edu.ksu.cis.bandera.tool.ToolIconView;
import edu.ksu.cis.indus.toolkits.bandera.OFATool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import soot.IntType;
import soot.Scene;
import soot.SootMethod;
import soot.Type;

public class OFAToolTest
extends TestCase {
    public void setNonEmptyConfigurations() {
        OFATool _cgt = new OFATool();
        String[] _configurationStrings = new String[]{"a", "1", "#", ".", "<configuration/>", "someConfigurationString"};
        int _i = 0;
        while (_i < _configurationStrings.length) {
            _cgt.setConfiguration(_configurationStrings[_i]);
            ++_i;
        }
    }

    public void testCreation() {
        try {
            new OFATool();
        }
        catch (Exception exception) {
            OFAToolTest.fail((String)"Could not create an instance of the tool");
        }
    }

    public void testGetConfiguration() {
        OFATool _cgt = new OFATool();
        String _configuration = _cgt.getConfiguration();
        OFAToolTest.assertNull((String)"The configuration String should be null.", (Object)_configuration);
    }

    public void testGetInputParameterList() {
        OFATool _cgt = new OFATool();
        List<String> _inputParameterList = _cgt.getInputParameterList();
        OFAToolTest.assertNotNull((String)"The input parameter list should not be null.", _inputParameterList);
        OFAToolTest.assertTrue((String)"The input parameter list is not big enough.", (_inputParameterList.size() >= 1 ? 1 : 0) != 0);
        OFAToolTest.assertTrue((String)"The input parameter list should contain the scene key.", (boolean)_inputParameterList.contains("scene"));
        OFAToolTest.assertTrue((String)"The input parameter list should contain the entry points key.", (boolean)_inputParameterList.contains("entryPoints"));
    }

    public void testGetOutputParameterList() {
        OFATool _cgt = new OFATool();
        List<String> _outputParameterList = _cgt.getOutputParameterList();
        OFAToolTest.assertNotNull((String)"The output parameter list should not be null.", _outputParameterList);
        OFAToolTest.assertTrue((String)"The output parameter list is not big enough.", (_outputParameterList.size() >= 1 ? 1 : 0) != 0);
        OFAToolTest.assertTrue((String)"The output parameter list should contain callgraph key.", (boolean)_outputParameterList.contains("callGraph"));
        OFAToolTest.assertTrue((String)"The output parameter list should contain the reachable class and fields key.", (boolean)_outputParameterList.contains("reachableClassesAndFields"));
    }

    public void testQuit() {
        OFATool _cgt = new OFATool();
        _cgt.quit();
    }

    public void testSetEmptyConfiguration() {
        OFATool _cgt = new OFATool();
        _cgt.setConfiguration("");
    }

    public void testSetEmptyInputMap() {
        OFATool _cgt = new OFATool();
        try {
            HashMap _inputMap = new HashMap(0);
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an empty Map should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an empty Map should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testSetNullConfiguration() {
        OFATool _cgt = new OFATool();
        _cgt.setConfiguration(null);
    }

    public void testSetNullInputMap() {
        OFATool _cgt = new OFATool();
        try {
            Map _inputMap = null;
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with a null Map should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception _e) {
            OFAToolTest.fail((String)("Calling setInputMap with a null Map should throw an IllegalArgumentException.  Got instead: " + _e.toString()));
        }
    }

    public void testToolConfigurationView() {
        OFATool _cgt = new OFATool();
        ToolConfigurationView _tcv = _cgt.getToolConfigurationView();
        OFAToolTest.assertNull((String)"The ToolConfigurationView should be null.", (Object)_tcv);
    }

    public void testToolIconView() {
        OFATool _cgt = new OFATool();
        ToolIconView _tiv = _cgt.getToolIconView();
        OFAToolTest.assertNull((String)"The ToolIconView should be null.", (Object)_tiv);
    }

    public void testsetInputMapWithEmptySceneAndEmptyEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap _inputMap = new HashMap(1);
            _inputMap.put("entryPoints", new HashSet(0));
            _inputMap.put("scene", Scene.v());
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (empty scene, empty entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (empty scene, empty entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithEmptySceneAndNoEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap<String, Scene> _inputMap = new HashMap<String, Scene>(1);
            _inputMap.put("scene", Scene.v());
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (empty scene, no entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (empty scene, no entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithEmptySceneAndNullEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap<String, Scene> _inputMap = new HashMap<String, Scene>(1);
            _inputMap.put("entryPoints", null);
            _inputMap.put("scene", Scene.v());
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (empty scene, null entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (empty scene, null entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithEmptySceneAndObjectEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap<String, Object> _inputMap = new HashMap<String, Object>(1);
            _inputMap.put("entryPoints", new Object());
            _inputMap.put("scene", Scene.v());
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (empty scene, Object entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (empty scene, Object entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithEmptySceneAndValidEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap _inputMap = new HashMap(1);
            HashSet<SootMethod> _entryPoints = new HashSet<SootMethod>(1);
            SootMethod _sm = new SootMethod("someMethod", new ArrayList(0), (Type)IntType.v());
            _entryPoints.add(_sm);
            _inputMap.put("entryPoints", _entryPoints);
            _inputMap.put("scene", Scene.v());
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (empty scene, valid entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (empty scene, valid entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithNoSceneAndEmptyEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap _inputMap = new HashMap(1);
            _inputMap.put("entryPoints", new HashSet(0));
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (no scene, empty entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (no scene, empty entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithNoSceneAndNullEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap<String, Object> _inputMap = new HashMap<String, Object>(1);
            _inputMap.put("entryPoints", null);
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (no scene, null entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (no scene, null entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithNoSceneAndObjectEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap<String, Object> _inputMap = new HashMap<String, Object>(1);
            _inputMap.put("entryPoints", new Object());
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (no scene, Object entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (no scene, Object entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithNoSceneAndValidEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap _inputMap = new HashMap(1);
            HashSet<SootMethod> _entryPoints = new HashSet<SootMethod>(1);
            SootMethod _sm = new SootMethod("someMethod", new ArrayList(0), (Type)IntType.v());
            _entryPoints.add(_sm);
            _inputMap.put("entryPoints", _entryPoints);
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (no scene, valid entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (no scene, valid entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithNullSceneAndEmptyEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap _inputMap = new HashMap(1);
            _inputMap.put("entryPoints", new HashSet(0));
            _inputMap.put("scene", null);
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (null scene, empty entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (null scene, empty entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithNullSceneAndNoEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap<String, Object> _inputMap = new HashMap<String, Object>(1);
            _inputMap.put("scene", null);
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (null scene, no entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (null scene, no entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithNullSceneAndNullEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap<String, Object> _inputMap = new HashMap<String, Object>(1);
            _inputMap.put("entryPoints", null);
            _inputMap.put("scene", null);
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (null scene, null entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (null scene, null entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithNullSceneAndObjectEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap<String, Object> _inputMap = new HashMap<String, Object>(1);
            _inputMap.put("entryPoints", new Object());
            _inputMap.put("scene", null);
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (null scene, Object entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (null scene, Object entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithNullSceneAndValidEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap _inputMap = new HashMap(1);
            HashSet<SootMethod> _entryPoints = new HashSet<SootMethod>(1);
            SootMethod _sm = new SootMethod("someMethod", new ArrayList(0), (Type)IntType.v());
            _entryPoints.add(_sm);
            _inputMap.put("entryPoints", _entryPoints);
            _inputMap.put("scene", null);
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (null scene, valid entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (null scene, valid entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithObjectSceneAndEmptyEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap<String, Object> _inputMap = new HashMap<String, Object>(1);
            _inputMap.put("entryPoints", new HashSet(0));
            _inputMap.put("scene", new Object());
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (Object scene, empty entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (Object scene, empty entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithObjectSceneAndNoEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap<String, Object> _inputMap = new HashMap<String, Object>(1);
            _inputMap.put("scene", new Object());
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (Object scene, no entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (Object scene, no entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithObjectSceneAndNullEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap<String, Object> _inputMap = new HashMap<String, Object>(1);
            _inputMap.put("entryPoints", null);
            _inputMap.put("scene", new Object());
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (Object scene, null entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (Object scene, null entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithObjectSceneAndObjectEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap<String, Object> _inputMap = new HashMap<String, Object>(1);
            _inputMap.put("entryPoints", new Object());
            _inputMap.put("scene", new Object());
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (Object scene, Object entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (Object scene, Object entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithObjectSceneAndValidEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap<String, Object> _inputMap = new HashMap<String, Object>(1);
            HashSet<SootMethod> _entryPoints = new HashSet<SootMethod>(1);
            SootMethod _sm = new SootMethod("someMethod", new ArrayList(0), (Type)IntType.v());
            _entryPoints.add(_sm);
            _inputMap.put("entryPoints", _entryPoints);
            _inputMap.put("scene", new Object());
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (Object scene, valid entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (Object scene, valid entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithValidSceneAndEmptyEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap _inputMap = new HashMap(1);
            _inputMap.put("entryPoints", new HashSet(0));
            _inputMap.put("scene", Scene.v());
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (valid scene, empty entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (valid scene, empty entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithValidSceneAndNoEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap<String, Scene> _inputMap = new HashMap<String, Scene>(1);
            _inputMap.put("scene", Scene.v());
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (valid scene, no entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (valid scene, no entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithValidSceneAndNullEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap<String, Scene> _inputMap = new HashMap<String, Scene>(1);
            _inputMap.put("entryPoints", null);
            _inputMap.put("scene", Scene.v());
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (valid scene, null entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (valid scene, null entry points) should throw an IllegalArgumentException.  Got instead: " + e.toString()));
        }
    }

    public void testsetInputMapWithValidSceneAndObjectEntryPoints() {
        OFATool _cgt = new OFATool();
        try {
            HashMap<String, Object> _inputMap = new HashMap<String, Object>(1);
            _inputMap.put("entryPoints", new Object());
            _inputMap.put("scene", Scene.v());
            _cgt.setInputMap(_inputMap);
            OFAToolTest.fail((String)"Calling setInputMap with an invalid Map (valid scene, Object entry points) should throw an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception _e) {
            OFAToolTest.fail((String)("Calling setInputMap with an invalid Map (valid scene, Object entry points) should throw an IllegalArgumentException.  Got instead: " + _e.toString()));
        }
    }
}

