/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.toolkits.bandera;

import edu.ksu.cis.bandera.tool.Tool;
import edu.ksu.cis.bandera.tool.ToolConfigurationView;
import edu.ksu.cis.bandera.tool.ToolIconView;
import edu.ksu.cis.bandera.util.BaseObservable;
import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.CompleteStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.IActivePart;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.Environment;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IStmtSequencesRetriever;
import edu.ksu.cis.indus.processing.OneAllStmtSequenceRetriever;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.callgraphs.OFABasedCallInfoCollector;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.ValueAnalyzerBasedProcessingController;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import edu.ksu.cis.indus.staticanalyses.tokens.TokenUtil;
import edu.ksu.cis.indus.staticanalyses.tokens.soot.SootValueTypeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Value;
import soot.util.Chain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OFATool
extends BaseObservable
implements Tool {
    public static final String BASIC_BLOCK_GRAPH_MGR_OUTPUT_KEY = "basicBlockGraphMgr";
    public static final String CALL_GRAPH_OUTPUT_KEY = "callGraph";
    public static final String ENTRY_POINTS_INPUT_KEY = "entryPoints";
    public static final String REACHABLE_CLASSES_AND_FIELDS_OUTPUT_KEY = "reachableClassesAndFields";
    public static final String SCENE_INPUT_KEY = "scene";
    private static List<String> inputParameterList;
    private static List<String> outputParameterList;
    IActivePart activePart;
    private BasicBlockGraphMgr basicBlockGraphMgr = new BasicBlockGraphMgr();
    private ICallGraphInfo callgraph;
    private Set<SootMethod> entryPoints;
    private final Map<SootClass, Collection<SootField>> reachableClass2Fields = new HashMap<SootClass, Collection<SootField>>();
    private Scene scene;

    static {
        OFATool.initInputParameters();
        OFATool.initOutputParameters();
    }

    private static void initInputParameters() {
        inputParameterList = new ArrayList<String>(2);
        inputParameterList.add(SCENE_INPUT_KEY);
        inputParameterList.add(ENTRY_POINTS_INPUT_KEY);
    }

    private static void initOutputParameters() {
        outputParameterList = new ArrayList<String>(1);
        outputParameterList.add(CALL_GRAPH_OUTPUT_KEY);
        outputParameterList.add(BASIC_BLOCK_GRAPH_MGR_OUTPUT_KEY);
        outputParameterList.add(REACHABLE_CLASSES_AND_FIELDS_OUTPUT_KEY);
    }

    public String getConfiguration() {
        return null;
    }

    public List<String> getInputParameterList() {
        return inputParameterList;
    }

    public Map<Object, Object> getOutputMap() {
        HashMap<Object, Object> _m = new HashMap<Object, Object>(3);
        _m.put(CALL_GRAPH_OUTPUT_KEY, this.callgraph);
        _m.put(REACHABLE_CLASSES_AND_FIELDS_OUTPUT_KEY, Collections.unmodifiableMap(this.reachableClass2Fields));
        _m.put(BASIC_BLOCK_GRAPH_MGR_OUTPUT_KEY, this.basicBlockGraphMgr);
        return _m;
    }

    public List<String> getOutputParameterList() {
        return outputParameterList;
    }

    public ToolConfigurationView getToolConfigurationView() {
        return null;
    }

    public ToolIconView getToolIconView() {
        return null;
    }

    public void quit() {
        this.activePart.deactivate();
    }

    public void run() throws IllegalStateException {
        this.execute();
    }

    @Empty
    public void setConfiguration(String configurationString) {
    }

    public void setInputMap(Map inputMap) throws Exception {
        if (inputMap == null) {
            throw new IllegalArgumentException("The input Map cannot be null.");
        }
        int _inputCount = inputMap.size();
        if (_inputCount < 2) {
            throw new IllegalArgumentException("The input Map must have at least two values.");
        }
        Object _sceneObject = inputMap.get(SCENE_INPUT_KEY);
        if (_sceneObject == null) {
            throw new IllegalArgumentException("A scene is required.");
        }
        if (!(_sceneObject instanceof Scene)) {
            throw new IllegalArgumentException("A scene of type soot.Scene is required.");
        }
        Scene _tempScene = (Scene)_sceneObject;
        Chain _c = _tempScene.getClasses();
        if (_c == null || _c.size() < 1) {
            throw new IllegalArgumentException("Cannot use an empty scene.");
        }
        Object _entryPointsObject = inputMap.get(ENTRY_POINTS_INPUT_KEY);
        if (_entryPointsObject == null) {
            throw new IllegalArgumentException("The set of entry points is required.");
        }
        if (!(_entryPointsObject instanceof Set)) {
            throw new IllegalArgumentException("The set of entry points must be of type Set.");
        }
        Set _tempEntryPoints = (Set)_entryPointsObject;
        if (_tempEntryPoints.size() < 1) {
            throw new IllegalArgumentException("The set of entry points must have at least one entry point");
        }
        this.scene = _tempScene;
        this.entryPoints = _tempEntryPoints;
    }

    private <T extends ITokens<T, Value>> void execute() {
        if (this.scene == null) {
            throw new IllegalStateException("Cannot run with a null Scene.");
        }
        if (this.entryPoints == null) {
            throw new IllegalStateException("Cannot run with a null Set of entry points.");
        }
        CompleteStmtGraphFactory _factory = new CompleteStmtGraphFactory();
        ITokenManager _tokenManager = TokenUtil.getTokenManager(new SootValueTypeManager());
        IValueAnalyzer _aa = OFAnalyzer.getFSOSAnalyzer("CallGraphXMLizer:FA", _tokenManager, _factory);
        ValueAnalyzerBasedProcessingController _pc = new ValueAnalyzerBasedProcessingController();
        ArrayList<OFABasedCallInfoCollector> _processors = new ArrayList<OFABasedCallInfoCollector>();
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        this.basicBlockGraphMgr.setStmtGraphFactory((IStmtGraphFactory)_factory);
        _ssr.setBbgFactory(this.basicBlockGraphMgr);
        _pc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _pc.setAnalyzer(_aa);
        _pc.setProcessingFilter((IProcessingFilter)new TagBasedProcessingFilter("CallGraphXMLizer:FA"));
        CallGraphInfo _cgi = new CallGraphInfo(new Pair.PairManager(false, true));
        OFABasedCallInfoCollector _callGraphInfoCollector = new OFABasedCallInfoCollector();
        HashMap<Comparable, ICallGraphInfo> _info = new HashMap<Comparable, ICallGraphInfo>();
        _info.put(ICallGraphInfo.ID, this.callgraph);
        this.activePart = _aa.getActivePart();
        _aa.reset();
        _aa.analyze((IEnvironment)new Environment(this.scene), this.entryPoints);
        _processors.clear();
        _processors.add(_callGraphInfoCollector);
        _pc.reset();
        _pc.driveProcessors(_processors);
        _processors.clear();
        _cgi.reset();
        _cgi.createCallGraphInfo(_callGraphInfoCollector.getCallInfo());
        this.callgraph = _cgi;
        this.retrieveReachableClassesAndFields(_aa, "CallGraphXMLizer:FA");
    }

    private void retrieveReachableClassesAndFields(IValueAnalyzer<Value> valueAnalyzer, String tagName) {
        for (SootClass _sc : valueAnalyzer.getEnvironment().getClasses()) {
            Chain _fields = _sc.getFields();
            Collection _temp = Util.getHostsWithTag((Collection)_fields, (String)tagName);
            this.reachableClass2Fields.put(_sc, _temp);
        }
    }
}

