/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.toolkits.bandera;

import edu.ksu.cis.indus.annotations.Experimental;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.collections.Stack;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.datastructures.LIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.LockAcquisitionBasedEquivalence;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv1;
import edu.ksu.cis.indus.toolkits.bandera.DependenceAndMayFollowInfoCalculator;
import edu.ksu.cis.indus.toolkits.bandera.RelativeDependenceInfoTool;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.SootMethod;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.toolkits.graph.UnitGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Experimental
class DependenceAndMayFollowInfoCalculatorV2
extends DependenceAndMayFollowInfoCalculator {
    private final Map<SootMethod, Collection<Pair<Stmt, SootMethod>>> entryPoint2reachableARef = new HashMap<SootMethod, Collection<Pair<Stmt, SootMethod>>>();
    private final Map<SootMethod, Collection<Pair<Stmt, SootMethod>>> entryPoint2reachableFRef = new HashMap<SootMethod, Collection<Pair<Stmt, SootMethod>>>();
    private final Map<SootMethod, Collection<Pair<Stmt, SootMethod>>> entryPoint2reachableLock = new HashMap<SootMethod, Collection<Pair<Stmt, SootMethod>>>();
    private final IStmtGraphFactory<?> stmtGraphFactory;

    DependenceAndMayFollowInfoCalculatorV2(RelativeDependenceInfoTool theTool, InterferenceDAv1 ida, LockAcquisitionBasedEquivalence lbe, ICallGraphInfo callGraph, IThreadGraphInfo threadGraph, CFGAnalysis cfgAnalysis, IStmtGraphFactory<?> graphFactory) {
        super(theTool, ida, lbe, callGraph, threadGraph, cfgAnalysis);
        this.stmtGraphFactory = graphFactory;
    }

    @Override
    protected void translateAndPopulateMayFollowRelation() {
        Iterator _i = this.tgi.getThreadEntryPoints().iterator();
        int _iEnd = this.tgi.getThreadEntryPoints().size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            SootMethod _sm = (SootMethod)_i.next();
            LIFOWorkBag _wb = new LIFOWorkBag();
            Info _t = new Info(_sm, null, (Stack<Pair<Stmt, SootMethod>>)new Stack(), new HashSet<Pair<Stmt, SootMethod>>(), new HashSet<Pair<Stmt, SootMethod>>(), new HashSet<Pair<Stmt, SootMethod>>(), _sm);
            _wb.addWork((Object)_t);
            while (_wb.hasWork()) {
                Pair _caller;
                Info _info = (Info)_wb.getWork();
                if (this.handleRecursion(_info, (IWorkBag<Info>)_wb)) continue;
                Stmt _stmt = _info.currStmt;
                if (_stmt == null) {
                    _info.currStmt = (Stmt)this.stmtGraphFactory.getStmtGraph(_info.method).getBody().getUnits().getFirst();
                    _wb.addWork((Object)_info);
                    continue;
                }
                Pair _pair = new Pair((Object)_stmt, (Object)_info.method);
                if (_stmt instanceof EnterMonitorStmt) {
                    this.recordMayFollow((Pair<Stmt, SootMethod>)_pair, _info.lacq);
                    this.processSuccs(_info, (Pair<Stmt, SootMethod>)_pair, (IWorkBag<Info>)_wb, SuccessorType.INTRAPROCEDURAL);
                    continue;
                }
                if (_stmt.containsArrayRef()) {
                    this.recordMayFollow((Pair<Stmt, SootMethod>)_pair, _info.aref);
                    this.processSuccs(_info, (Pair<Stmt, SootMethod>)_pair, (IWorkBag<Info>)_wb, SuccessorType.INTRAPROCEDURAL);
                    continue;
                }
                if (_stmt.containsFieldRef()) {
                    this.recordMayFollow((Pair<Stmt, SootMethod>)_pair, _info.fref);
                    this.processSuccs(_info, (Pair<Stmt, SootMethod>)_pair, (IWorkBag<Info>)_wb, SuccessorType.INTRAPROCEDURAL);
                    continue;
                }
                if (_stmt.containsInvokeExpr()) {
                    _info.lacq.add((Pair<Stmt, SootMethod>)_pair);
                    _info.aref.add((Pair<Stmt, SootMethod>)_pair);
                    _info.fref.add((Pair<Stmt, SootMethod>)_pair);
                    _info.currStmt = null;
                    Context _context = new Context();
                    _context.setStmt(_stmt);
                    _context.setRootMethod(_info.method);
                    Collection _callees = this.cgi.getCallees(_stmt.getInvokeExpr(), _context);
                    Iterator _j = _callees.iterator();
                    int _jEnd = _callees.size();
                    int _jIndex = 0;
                    while (_jIndex < _jEnd) {
                        Info _clone = _info.clone();
                        _clone.callstack.push((Object)_pair);
                        _info.method = (SootMethod)_j.next();
                        _wb.addWork((Object)_clone);
                        ++_jIndex;
                    }
                    continue;
                }
                if (_stmt instanceof ReturnVoidStmt || _stmt instanceof ReturnStmt) {
                    if (_info.callstack.isEmpty()) continue;
                    _caller = (Pair)_info.callstack.pop();
                    _info.currStmt = (Stmt)_caller.getFirst();
                    _info.method = (SootMethod)_caller.getSecond();
                    this.processSuccs(_info, (Pair<Stmt, SootMethod>)_pair, (IWorkBag<Info>)_wb, SuccessorType.NORMAL_RETURN);
                    continue;
                }
                if (!(_stmt instanceof ThrowStmt) || _info.callstack.isEmpty()) continue;
                _caller = (Pair)_info.callstack.pop();
                _info.currStmt = (Stmt)_caller.getFirst();
                _info.method = (SootMethod)_caller.getSecond();
                this.processSuccs(_info, (Pair<Stmt, SootMethod>)_pair, (IWorkBag<Info>)_wb, SuccessorType.EXCEPTIONAL_RETURN);
            }
            ++_iIndex;
        }
    }

    private boolean handleRecursion(Info info, IWorkBag<Info> wb) {
        Pair _pair = new Pair((Object)info.currStmt, (Object)info.method);
        boolean _result = info.callstack.contains((Object)_pair);
        if (_result) {
            Collection _aref = MapUtils.getCollectionFromMap(this.entryPoint2reachableARef, (Object)info.entryPoint);
            _aref.addAll(info.aref);
            info.aref = _aref;
            Collection _fref = MapUtils.getCollectionFromMap(this.entryPoint2reachableFRef, (Object)info.entryPoint);
            _fref.addAll(info.fref);
            info.fref = _fref;
            Collection _lacq = MapUtils.getCollectionFromMap(this.entryPoint2reachableLock, (Object)info.entryPoint);
            _lacq.addAll(info.lacq);
            info.lacq = _lacq;
            Pair _caller = (Pair)info.callstack.pop();
            info.currStmt = (Stmt)_caller.getFirst();
            info.method = (SootMethod)_caller.getSecond();
            this.processSuccs(info, (Pair<Stmt, SootMethod>)_pair, wb, SuccessorType.NORMAL_RETURN);
            this.processSuccs(info, (Pair<Stmt, SootMethod>)_pair, wb, SuccessorType.EXCEPTIONAL_RETURN);
        }
        return _result;
    }

    private void processSuccs(Info info, Pair<Stmt, SootMethod> pair, IWorkBag<Info> wb, SuccessorType retType) {
        info.lacq.add(pair);
        info.aref.add(pair);
        info.fref.add(pair);
        Stmt _stmt = info.currStmt;
        UnitGraph _graph = this.stmtGraphFactory.getStmtGraph(info.method);
        List _succsOf = _graph.getSuccsOf((Object)_stmt);
        Iterator _i = _succsOf.iterator();
        int _iEnd = _succsOf.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Stmt _succ = (Stmt)_i.next();
            if (retType == SuccessorType.INTRAPROCEDURAL || retType == SuccessorType.NORMAL_RETURN && (!(_succ instanceof DefinitionStmt) || !(((DefinitionStmt)_succ).getRightOp() instanceof CaughtExceptionRef)) || retType == SuccessorType.EXCEPTIONAL_RETURN && _succ instanceof DefinitionStmt && ((DefinitionStmt)_succ).getRightOp() instanceof CaughtExceptionRef) {
                Info _clone = info.clone();
                _clone.currStmt = _succ;
                wb.addWork((Object)_clone);
            }
            ++_iIndex;
        }
    }

    private void recordMayFollow(Pair<Stmt, SootMethod> pair, Collection<Pair<Stmt, SootMethod>> col) {
        Iterator<Pair<Stmt, SootMethod>> _i = col.iterator();
        int _iEnd = col.size();
        Collection<String> _birLocs = this.tool.generateBIRRep(pair, false);
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Collection<String> _pString = this.tool.generateBIRRep(_i.next(), false);
            for (String _birLoc : _pString) {
                MapUtils.putAllIntoCollectionInMap(this.tool.mayFollow, (Object)_birLoc, _birLocs);
            }
            ++_iIndex;
        }
        col.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Info
    implements Cloneable {
        Collection<Pair<Stmt, SootMethod>> aref;
        Stack<Pair<Stmt, SootMethod>> callstack;
        Stmt currStmt;
        final SootMethod entryPoint;
        Collection<Pair<Stmt, SootMethod>> fref;
        Collection<Pair<Stmt, SootMethod>> lacq;
        SootMethod method;

        public Info(SootMethod sm, Stmt stmt, Stack<Pair<Stmt, SootMethod>> callChain, Collection<Pair<Stmt, SootMethod>> lockCol, Collection<Pair<Stmt, SootMethod>> arefCol, Collection<Pair<Stmt, SootMethod>> frefCol, SootMethod entry) {
            this.method = sm;
            this.callstack = callChain;
            this.currStmt = stmt;
            this.lacq = lockCol;
            this.aref = arefCol;
            this.fref = frefCol;
            this.entryPoint = entry;
        }

        public Info clone() {
            Info _result;
            try {
                _result = (Info)super.clone();
                _result.aref = (Collection)((HashSet)this.aref).clone();
                _result.fref = (Collection)((HashSet)this.fref).clone();
                _result.lacq = (Collection)((HashSet)this.lacq).clone();
                _result.callstack = this.callstack.clone();
            }
            catch (CloneNotSupportedException _e) {
                IllegalStateException _r = new IllegalStateException();
                _r.initCause(_e);
                throw _r;
            }
            return _result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SuccessorType {
        EXCEPTIONAL_RETURN,
        INTRAPROCEDURAL,
        NORMAL_RETURN;

    }
}

