/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.toolkits.bandera;

import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.LockAcquisitionBasedEquivalence;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv1;
import edu.ksu.cis.indus.toolkits.bandera.RelativeDependenceInfoTool;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InvokeStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DependenceAndMayFollowInfoCalculator
extends AbstractProcessor {
    private static final IPredicate<Pair<?, SootMethod>> APPLICATION_CLASS_ONLY_PREDICATE = new IPredicate<Pair<?, SootMethod>>(){

        public boolean evaluate(Pair<?, SootMethod> object) {
            return ((SootMethod)object.getSecond()).getDeclaringClass().isApplicationClass();
        }
    };
    private static final Logger LOGGER = LoggerFactory.getLogger(DependenceAndMayFollowInfoCalculator.class);
    protected final IThreadGraphInfo tgi;
    protected final RelativeDependenceInfoTool tool;
    final ICallGraphInfo cgi;
    final InterferenceDAv1 interferenceDA;
    final LockAcquisitionBasedEquivalence locking;
    private boolean arrayRefInApplicationClassesOnly;
    private final CFGAnalysis cfg;
    private final Map<Pair<? extends Stmt, SootMethod>, Collection<Pair<? extends Stmt, SootMethod>>> dependenceCache = new HashMap<Pair<? extends Stmt, SootMethod>, Collection<Pair<? extends Stmt, SootMethod>>>();
    private final List<Pair<? extends Stmt, SootMethod>> knownTransitions = new ArrayList<Pair<? extends Stmt, SootMethod>>();
    private boolean fieldRefInApplicationClassesOnly;
    private boolean lockAcqInApplicationClassesOnly;

    public DependenceAndMayFollowInfoCalculator(RelativeDependenceInfoTool theTool, InterferenceDAv1 ida, LockAcquisitionBasedEquivalence lbe, ICallGraphInfo callGraph, IThreadGraphInfo threadGraph, CFGAnalysis cfgAnalysis) {
        this.tool = theTool;
        this.interferenceDA = ida;
        this.locking = lbe;
        this.tgi = threadGraph;
        this.cfg = cfgAnalysis;
        this.cgi = callGraph;
    }

    public final void callback(SootMethod method) {
        if (method.isSynchronized()) {
            Pair _p = new Pair(null, (Object)method);
            Collection<String> _birLocs = this.tool.generateBIRRep((Pair<? extends Stmt, SootMethod>)_p, false);
            Collection<Pair<? extends Stmt, SootMethod>> _c = this.locking.getLockAcquisitionsInEquivalenceClassOf((Pair<Stmt, SootMethod>)_p);
            this.addToDependenceCache((Pair<? extends Stmt, SootMethod>)_p, _c, this.tool.lockAcquisitions, _birLocs, this.lockAcqInApplicationClassesOnly);
            this.tool.seenStmts.addAll(this.tool.generateBIRRep((Pair<? extends Stmt, SootMethod>)_p, true));
        }
    }

    public final void callback(Stmt stmt, Context context) {
        SootMethod _currentMethod = context.getCurrentMethod();
        Pair _p = new Pair((Object)stmt, (Object)_currentMethod);
        Collection<String> _birLocs = this.tool.generateBIRRep((Pair<? extends Stmt, SootMethod>)_p, false);
        this.tool.seenStmts.addAll(_birLocs);
        if (stmt instanceof EnterMonitorStmt || stmt instanceof InvokeStmt && Util.isWaitInvocation((InvokeStmt)((InvokeStmt)stmt), (SootMethod)_currentMethod, (ICallGraphInfo)this.cgi)) {
            Collection<Pair<? extends Stmt, SootMethod>> _c = this.locking.getLockAcquisitionsInEquivalenceClassOf((Pair<Stmt, SootMethod>)_p);
            this.addToDependenceCache((Pair<? extends Stmt, SootMethod>)_p, _c, this.tool.lockAcquisitions, _birLocs, this.lockAcqInApplicationClassesOnly);
        }
        this.knownTransitions.add((Pair<? extends Stmt, SootMethod>)_p);
    }

    public final void callback(ValueBox vBox, Context context) {
        boolean _flag;
        Collection<String> _c;
        SootMethod _currentMethod = context.getCurrentMethod();
        Stmt _stmt = context.getStmt();
        Pair _pair = new Pair((Object)_stmt, (Object)_currentMethod);
        if (_stmt.containsArrayRef()) {
            _c = this.tool.arrayRefs;
            _flag = this.arrayRefInApplicationClassesOnly;
        } else if (_stmt.containsFieldRef()) {
            _c = this.tool.fieldRefs;
            _flag = this.fieldRefInApplicationClassesOnly;
        } else {
            _c = null;
            _flag = false;
        }
        if (_c != null) {
            Collection<String> _birLocs = this.tool.generateBIRRep((Pair<? extends Stmt, SootMethod>)_pair, false);
            Collection<Pair<AssignStmt, SootMethod>> _dependees = this.interferenceDA.getDependees((AssignStmt)_stmt, _currentMethod);
            this.addToDependenceCache((Pair<? extends Stmt, SootMethod>)_pair, _dependees, _c, _birLocs, _flag);
            Collection<Pair<AssignStmt, SootMethod>> _dependents = this.interferenceDA.getDependents((AssignStmt)_stmt, _currentMethod);
            this.addToDependenceCache((Pair<? extends Stmt, SootMethod>)_pair, _dependents, _c, _birLocs, _flag);
        }
    }

    public final void consolidate() {
        this.translateAndPopulateDependenceInfo();
        this.translateAndPopulateMayFollowRelation();
        this.dependenceCache.clear();
        if (LOGGER.isDebugEnabled()) {
            this.writeDataToFiles();
            LOGGER.debug("locking dependence info:" + (Object)((Object)this.locking));
        }
    }

    public final void hookup(ProcessingController ppc) {
        ppc.register((IProcessor)this);
        ppc.registerForAllStmts((IProcessor)this);
        ppc.register(ArrayRef.class, (IProcessor)this);
        ppc.register(InstanceFieldRef.class, (IProcessor)this);
        ppc.register(StaticFieldRef.class, (IProcessor)this);
    }

    public void setApplicationClassFiltering(boolean lockAcq, boolean fieldRef, boolean arrayRef) {
        this.lockAcqInApplicationClassesOnly = lockAcq;
        this.arrayRefInApplicationClassesOnly = arrayRef;
        this.fieldRefInApplicationClassesOnly = fieldRef;
    }

    public final void unhook(ProcessingController ppc) {
        ppc.unregister((IProcessor)this);
        ppc.unregisterForAllStmts((IProcessor)this);
        ppc.unregister(ArrayRef.class, (IProcessor)this);
        ppc.unregister(InstanceFieldRef.class, (IProcessor)this);
        ppc.unregister(StaticFieldRef.class, (IProcessor)this);
    }

    protected void translateAndPopulateMayFollowRelation() {
        Map<String, Collection<String>> _result = this.tool.mayFollow;
        _result.clear();
        ListIterator<Pair<? extends Stmt, SootMethod>> _i = this.knownTransitions.listIterator();
        int _iEnd = this.knownTransitions.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Pair<? extends Stmt, SootMethod> _pSrc = _i.next();
            Stmt _sSrc = (Stmt)_pSrc.getFirst();
            SootMethod _mSrc = (SootMethod)_pSrc.getSecond();
            Collection<String> _pSrcInBIR = this.tool.generateBIRRep(_pSrc, false);
            for (Pair<? extends Stmt, SootMethod> _pDest : this.dependenceCache.keySet()) {
                Stmt _sDest = (Stmt)_pDest.getFirst();
                SootMethod _mDest = (SootMethod)_pDest.getSecond();
                boolean _flag = _sSrc != null && _sDest != null ? this.cfg.isReachableViaInterProceduralControlFlow(_mSrc, _sSrc, _mDest, _sDest, null, false) : (_sSrc == null && _sDest == null ? this.cfg.doesControlPathExistFromTo(_mSrc, _mDest) : (_sSrc == null ? this.cfg.doesControlFlowPathExistBetween(_mDest, _sDest, _mSrc, false, true) : this.cfg.doesControlFlowPathExistBetween(_mSrc, _sSrc, _mDest, true, true)));
                if (_flag) {
                    Collection<String> _birLocs = this.tool.generateBIRRep(_pDest, false);
                    Iterator<String> _k = _pSrcInBIR.iterator();
                    int _kEnd = _pSrcInBIR.size();
                    int _kIndex = 0;
                    while (_kIndex < _kEnd) {
                        MapUtils.putAllIntoCollectionInMap(_result, (Object)_k.next(), _birLocs);
                        ++_kIndex;
                    }
                    continue;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug(_sDest + "@" + _mDest + " will not follow " + _sSrc + "@" + _mDest);
            }
            ++_iIndex;
        }
    }

    void writeDataToFiles() throws IllegalStateException {
        try {
            ObjectOutputStream _output1 = new ObjectOutputStream(new FileOutputStream("dependence"));
            _output1.writeObject(this.tool.dependence);
            _output1.close();
            ObjectInputStream _input1 = new ObjectInputStream(new FileInputStream("dependence"));
            Map _temp1 = (Map)_input1.readObject();
            _input1.close();
            ObjectOutputStream _output2 = new ObjectOutputStream(new FileOutputStream("knowntransitions"));
            _output2.writeObject(this.tool.seenStmts);
            _output2.close();
            ObjectInputStream _input2 = new ObjectInputStream(new FileInputStream("knowntransitions"));
            Collection _temp2 = (Collection)_input2.readObject();
            _input2.close();
            ObjectOutputStream _output3 = new ObjectOutputStream(new FileOutputStream("mayfollow"));
            _output3.writeObject(this.tool.mayFollow);
            _output3.close();
            ObjectInputStream _input3 = new ObjectInputStream(new FileInputStream("mayfollow"));
            Map _temp3 = (Map)_input3.readObject();
            _input3.close();
            ObjectOutputStream _output4 = new ObjectOutputStream(new FileOutputStream("lockAcquisitions"));
            _output4.writeObject(this.tool.lockAcquisitions);
            _output4.close();
            ObjectInputStream _input4 = new ObjectInputStream(new FileInputStream("lockAcquisitions"));
            Collection _temp4 = (Collection)_input4.readObject();
            _input4.close();
            ObjectOutputStream _output5 = new ObjectOutputStream(new FileOutputStream("arrayRefs"));
            _output5.writeObject(this.tool.arrayRefs);
            _output5.close();
            ObjectInputStream _input5 = new ObjectInputStream(new FileInputStream("arrayRefs"));
            Collection _temp5 = (Collection)_input5.readObject();
            _input5.close();
            ObjectOutputStream _output6 = new ObjectOutputStream(new FileOutputStream("fieldRefs"));
            _output6.writeObject(this.tool.fieldRefs);
            _output6.close();
            ObjectInputStream _input6 = new ObjectInputStream(new FileInputStream("fieldRefs"));
            Collection _temp6 = (Collection)_input6.readObject();
            _input6.close();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("consolidate() - Dependence Relation -" + MapUtils.verbosePrint((Map)_temp1) + "\n May Follow Relation - " + MapUtils.verbosePrint((Map)_temp3) + "\n" + "Known Transitions:\n" + CollectionUtils.prettyPrint((Collection)_temp2) + "\nLock Acquisitions:\n" + CollectionUtils.prettyPrint((Collection)_temp4) + "\nArray Refs:\n" + CollectionUtils.prettyPrint((Collection)_temp5) + "\nField Refs:\n" + CollectionUtils.prettyPrint((Collection)_temp6));
                LOGGER.debug("consolidate()" + this.tool.dependence.equals(_temp1) + " " + this.tool.seenStmts.equals(_temp2) + " " + this.tool.mayFollow.equals(_temp3) + " " + this.tool.lockAcquisitions.equals(_temp4) + " " + this.tool.arrayRefs.equals(_temp5) + " " + this.tool.fieldRefs.equals(_temp6));
            }
        }
        catch (FileNotFoundException _e) {
            IllegalStateException _r = new IllegalStateException();
            _r.initCause(_e);
            throw _r;
        }
        catch (IOException _e) {
            IllegalStateException _r = new IllegalStateException();
            _r.initCause(_e);
            throw _r;
        }
        catch (ClassNotFoundException _e) {
            IllegalStateException _r = new IllegalStateException();
            _r.initCause(_e);
            throw _r;
        }
    }

    private void addToDependenceCache(Pair<? extends Stmt, SootMethod> p, Collection<? extends Pair<? extends Stmt, SootMethod>> dependence, Collection<String> equivalents, Collection<String> birLocs, boolean applicationClassesOnly) {
        if (!(applicationClassesOnly && !((SootMethod)p.getSecond()).getDeclaringClass().isApplicationClass() || dependence.isEmpty())) {
            ArrayList<? extends Pair<? extends Stmt, SootMethod>> _t = new ArrayList<Pair<? extends Stmt, SootMethod>>(dependence);
            if (applicationClassesOnly) {
                CollectionUtils.filter(_t, APPLICATION_CLASS_ONLY_PREDICATE);
            }
            MapUtils.putAllIntoCollectionInMap(this.dependenceCache, p, _t);
            equivalents.addAll(birLocs);
        }
    }

    private void translateAndPopulateDependenceInfo() {
        Map<String, Collection<String>> _result = this.tool.dependence;
        _result.clear();
        Set<Map.Entry<Pair<? extends Stmt, SootMethod>, Collection<Pair<? extends Stmt, SootMethod>>>> _entrySet = this.dependenceCache.entrySet();
        Iterator<Map.Entry<Pair<? extends Stmt, SootMethod>, Collection<Pair<? extends Stmt, SootMethod>>>> _i = _entrySet.iterator();
        int _iEnd = _entrySet.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Map.Entry<Pair<? extends Stmt, SootMethod>, Collection<Pair<? extends Stmt, SootMethod>>> _entry = _i.next();
            Pair<? extends Stmt, SootMethod> _pair = _entry.getKey();
            Collection<Pair<? extends Stmt, SootMethod>> _depends = _entry.getValue();
            Collection<String> _t = this.tool.generateBIRRep(_pair, false);
            Iterator<Pair<? extends Stmt, SootMethod>> _j = _depends.iterator();
            int _jEnd = _depends.size();
            int _jIndex = 0;
            while (_jIndex < _jEnd) {
                Pair<? extends Stmt, SootMethod> _p = _j.next();
                Collection<String> _t2 = this.tool.generateBIRRep(_p, false);
                Iterator<String> _k = _t.iterator();
                int _kEnd = _t.size();
                int _kIndex = 0;
                while (_kIndex < _kEnd) {
                    MapUtils.putAllIntoCollectionInMap(_result, (Object)_k.next(), _t2);
                    ++_kIndex;
                }
                this.knownTransitions.add(_p);
                ++_jIndex;
            }
            ++_iIndex;
        }
    }
}

