/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.toolkits.bandera;

import edu.ksu.cis.bandera.tool.Tool;
import edu.ksu.cis.bandera.tool.ToolConfigurationView;
import edu.ksu.cis.bandera.tool.ToolIconView;
import edu.ksu.cis.bandera.util.BaseObservable;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.interfaces.IActivePart;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IConcurrentIndependenceInfo;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.Environment;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IStmtSequencesRetriever;
import edu.ksu.cis.indus.processing.OneAllStmtSequenceRetriever;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.independence.IndependentStmtDetectorv2;
import edu.ksu.cis.indus.staticanalyses.interfaces.IAnalysis;
import edu.ksu.cis.indus.staticanalyses.processing.AnalysesController;
import edu.ksu.cis.indus.staticanalyses.processing.CGBasedProcessingFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Scene;
import soot.util.Chain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcurrentIndependenceTool
extends BaseObservable
implements Tool {
    public static final String BASIC_BLOCK_GRAPH_MGR_INPUT_KEY = "basicBlockGraphMgr";
    public static final String CALL_GRAPH_INPUT_KEY = "callGraph";
    public static final String INDEPENDENCEE_OUTPUT_KEY = "concurrentIndependenceInfo";
    public static final String SCENE_INPUT_KEY = "scene";
    private static List<String> inputParameterList;
    private static List<String> outputParameterList;
    private IActivePart activePart;
    private BasicBlockGraphMgr basicBlockGraphMgr;
    private ICallGraphInfo callgraph;
    private IConcurrentIndependenceInfo independenceInfo;
    private Collection<String> independentClassNames;
    private Scene scene;

    static {
        ConcurrentIndependenceTool.initInputParameters();
        ConcurrentIndependenceTool.initOutputParameters();
    }

    private static void initInputParameters() {
        inputParameterList = new ArrayList<String>(3);
        inputParameterList.add(SCENE_INPUT_KEY);
        inputParameterList.add(CALL_GRAPH_INPUT_KEY);
        inputParameterList.add(BASIC_BLOCK_GRAPH_MGR_INPUT_KEY);
    }

    private static void initOutputParameters() {
        outputParameterList = new ArrayList<String>(1);
        outputParameterList.add(INDEPENDENCEE_OUTPUT_KEY);
    }

    public String getConfiguration() {
        if (this.independentClassNames == null) {
            return "";
        }
        StringBuffer _sb = new StringBuffer();
        Iterator<String> _i = this.independentClassNames.iterator();
        int _iEnd = this.independentClassNames.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            String _s = _i.next();
            _sb.append(_s);
            if (_iIndex != _iEnd - 1) {
                _sb.append(',');
            }
            ++_iIndex;
        }
        return _sb.toString();
    }

    public List<String> getInputParameterList() {
        return inputParameterList;
    }

    public Map getOutputMap() {
        HashMap<String, IConcurrentIndependenceInfo> _m = new HashMap<String, IConcurrentIndependenceInfo>(1);
        _m.put(INDEPENDENCEE_OUTPUT_KEY, this.independenceInfo);
        return _m;
    }

    public List<String> getOutputParameterList() {
        return outputParameterList;
    }

    public ToolConfigurationView getToolConfigurationView() {
        return null;
    }

    public ToolIconView getToolIconView() {
        return null;
    }

    public void quit() {
        this.activePart.deactivate();
    }

    public void run() throws IllegalStateException {
        ProcessingController _pc = new ProcessingController();
        EquivalenceClassBasedEscapeAnalysis _ecba = new EquivalenceClassBasedEscapeAnalysis(this.callgraph, null, this.basicBlockGraphMgr);
        HashMap _info = new HashMap();
        AnalysesController _ac = new AnalysesController(_info, _pc, this.basicBlockGraphMgr);
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        _ssr.setBbgFactory(this.basicBlockGraphMgr);
        _pc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _pc.setProcessingFilter((IProcessingFilter)new CGBasedProcessingFilter(this.callgraph));
        _pc.setEnvironment((IEnvironment)new Environment(this.scene));
        _info.put(ICallGraphInfo.ID, this.callgraph);
        _ac.addAnalyses(EquivalenceClassBasedEscapeAnalysis.ID, (Collection<? extends IAnalysis>)Collections.singleton(_ecba));
        _ac.initialize();
        _ac.execute();
        this.activePart = _ac.getActivePart();
        IndependentStmtDetectorv2 _independent = new IndependentStmtDetectorv2();
        if (this.independentClassNames != null) {
            _independent.setAtomicClassNames(this.independentClassNames);
        }
        _independent.setEscapeAnalysis(_ecba.getEscapeInfo());
        _independent.hookup(_pc);
        _pc.process();
        _independent.unhook(_pc);
        this.independenceInfo = _independent;
    }

    public void setConfiguration(String configurationString) {
        if (configurationString != null) {
            String[] _a = configurationString.split(",");
            this.independentClassNames = new ArrayList<String>();
            int _i = _a.length - 1;
            while (_i >= 0) {
                this.independentClassNames.add(_a[_i].trim());
                --_i;
            }
        }
    }

    public void setInputMap(Map inputMap) throws Exception {
        if (inputMap == null) {
            throw new IllegalArgumentException("The input Map cannot be null.");
        }
        int _inputCount = inputMap.size();
        if (_inputCount < 3) {
            throw new IllegalArgumentException("The input Map must have at least three values.");
        }
        Object _sceneObject = inputMap.get(SCENE_INPUT_KEY);
        if (_sceneObject == null) {
            throw new IllegalArgumentException("A scene is required.");
        }
        if (!(_sceneObject instanceof Scene)) {
            throw new IllegalArgumentException("A scene of type soot.Scene is required.");
        }
        Scene _tempScene = (Scene)_sceneObject;
        Chain _c = _tempScene.getClasses();
        if (_c == null) {
            throw new IllegalArgumentException("Cannot use an empty scene.");
        }
        if (_c.size() < 1) {
            throw new IllegalArgumentException("Cannot use an empty scene.");
        }
        Object _bbgMgr = inputMap.get(BASIC_BLOCK_GRAPH_MGR_INPUT_KEY);
        if (_bbgMgr == null) {
            throw new IllegalArgumentException("Basic block graph manager is required.");
        }
        if (!(_bbgMgr instanceof BasicBlockGraphMgr)) {
            throw new IllegalArgumentException("A basic block graph manager of type BasicBlockGraphMgr is required.");
        }
        Object _cgi = inputMap.get(CALL_GRAPH_INPUT_KEY);
        if (_cgi == null) {
            throw new IllegalArgumentException("call graph info is required.");
        }
        if (!(_cgi instanceof ICallGraphInfo)) {
            throw new IllegalArgumentException("A call graph info of type ICallGraphInfo is required.");
        }
        this.scene = _tempScene;
        this.basicBlockGraphMgr = (BasicBlockGraphMgr)_bbgMgr;
        this.callgraph = (ICallGraphInfo)_cgi;
    }
}

