/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.tokens.soot;

import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.InstanceOfPredicate;
import edu.ksu.cis.indus.common.soot.Constants;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.staticanalyses.tokens.IDynamicTokenTypeRelationDetector;
import edu.ksu.cis.indus.staticanalyses.tokens.IType;
import edu.ksu.cis.indus.staticanalyses.tokens.ITypeManager;
import edu.ksu.cis.indus.staticanalyses.tokens.soot.SootDynamicTokenTypeRelationDetector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import soot.ArrayType;
import soot.NullType;
import soot.RefLikeType;
import soot.RefType;
import soot.SootClass;
import soot.Type;
import soot.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SootValueTypeManager
extends Observable
implements ITypeManager<Type, Value> {
    private final IDynamicTokenTypeRelationDetector<Value> evaluator;
    private final Map<Type, IType> sootType2Type;
    private IType tokenTypeForObjectType;
    private final IPredicate<Type> typesForNullConstPredicate = new InstanceOfPredicate(RefLikeType.class);

    public SootValueTypeManager() {
        this.evaluator = new SootDynamicTokenTypeRelationDetector();
        this.sootType2Type = new HashMap<Type, IType>(Constants.getNumOfClassesInApplication());
    }

    @Override
    public Collection<IType> getAllTypes(Value value) {
        IType _t;
        Value _theValue = value;
        Type _type = _theValue.getType();
        ArrayList<IType> _result = new ArrayList<IType>();
        _result.add(this.getTokenTypeForRepType(_type));
        if (_type instanceof RefType) {
            Iterator _i = Util.getAncestors((SootClass)((RefType)_type).getSootClass()).iterator();
            while (_i.hasNext()) {
                _result.add(this.getTokenTypeForRepType((Type)((SootClass)_i.next()).getType()));
            }
        }
        if (_type instanceof NullType) {
            Collection _s = CollectionUtils.collect((Collection)this.sootType2Type.keySet(), this.typesForNullConstPredicate);
            for (Type _t2 : _s) {
                _result.add(this.sootType2Type.get(_t2));
            }
        } else if (_type instanceof ArrayType && (_t = this.getTokenTypeForObjectType()) != null) {
            _result.add(_t);
        }
        return _result;
    }

    @Override
    public IDynamicTokenTypeRelationDetector<Value> getDynamicTokenTypeRelationEvaluator() {
        return this.evaluator;
    }

    @Override
    public IType getExactType(Value value) {
        return this.getTokenTypeForRepType(value.getType());
    }

    @Override
    public IType getTokenTypeForRepType(Type sootType) {
        IType _result = this.sootType2Type.get(sootType);
        if (_result == null) {
            _result = new DummyType(sootType);
            this.sootType2Type.put(sootType, _result);
            this.setChanged();
            this.notifyObservers(new ITypeManager.NewTypeCreated(_result));
        }
        return _result;
    }

    @Override
    public void reset() {
        this.sootType2Type.clear();
        this.evaluator.reset();
        this.tokenTypeForObjectType = null;
    }

    private IType getTokenTypeForObjectType() {
        if (this.tokenTypeForObjectType == null) {
            Set<Map.Entry<Type, IType>> _entrySet = this.sootType2Type.entrySet();
            Iterator<Map.Entry<Type, IType>> _i = _entrySet.iterator();
            int _iEnd = _entrySet.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                SootClass _sc;
                Map.Entry<Type, IType> _entry = _i.next();
                Type _sootType = _entry.getKey();
                if (_sootType instanceof RefType && (_sc = ((RefType)_sootType).getSootClass()).getName().equals("java.lang.Object")) {
                    this.tokenTypeForObjectType = _entry.getValue();
                    break;
                }
                ++_iIndex;
            }
        }
        return this.tokenTypeForObjectType;
    }

    static class DummyType
    implements IType {
        final Type sootType;

        public DummyType(Type sType) {
            this.sootType = sType;
        }
    }
}

