/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.tokens.soot;

import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.soot.SootPredicatesAndTransformers;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.staticanalyses.tokens.IDynamicTokenTypeRelationDetector;
import edu.ksu.cis.indus.staticanalyses.tokens.IType;
import edu.ksu.cis.indus.staticanalyses.tokens.soot.SootValueTypeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import soot.ArrayType;
import soot.RefType;
import soot.Type;
import soot.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SootDynamicTokenTypeRelationDetector
implements IDynamicTokenTypeRelationDetector<Value> {
    private boolean nullConstSeen;
    private boolean objectTypeSeen;
    private final Collection<IType> typesForNullConst = new ArrayList<IType>();

    SootDynamicTokenTypeRelationDetector() {
    }

    @Override
    public Collection<Value> getValuesConformingTo(Collection<Value> values, IType type) {
        HashSet<Value> _result = new HashSet<Value>();
        this.processForNullConstAndRefTypeRelation(values, type, _result);
        this.processForArrayAndObjectTypeRelation(values, type, _result);
        return _result;
    }

    @Override
    public void reset() {
        this.nullConstSeen = false;
        this.objectTypeSeen = false;
        this.typesForNullConst.clear();
    }

    private void processForArrayAndObjectTypeRelation(Collection<Value> values, IType type, Collection<Value> result) {
        SootValueTypeManager.DummyType _dType = (SootValueTypeManager.DummyType)type;
        Type _sootType = _dType.sootType;
        if (!this.objectTypeSeen && _sootType instanceof RefType && ((RefType)_sootType).getSootClass().getName().equals("java.lang.Object")) {
            Iterator<Value> _i = values.iterator();
            int _iEnd = values.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                Value _value = _i.next();
                if (_value.getType() instanceof ArrayType) {
                    result.add(_value);
                }
                ++_iIndex;
            }
            this.objectTypeSeen = true;
        }
    }

    private void processForNullConstAndRefTypeRelation(Collection<Value> values, IType type, Collection<Value> result) {
        boolean bl = this.nullConstSeen = this.nullConstSeen || CollectionUtils.exists(values, (IPredicate)SootPredicatesAndTransformers.NULL_PREDICATE);
        if (this.nullConstSeen && Util.isReferenceType((Type)((SootValueTypeManager.DummyType)type).sootType) && !this.typesForNullConst.contains(type)) {
            this.typesForNullConst.add(type);
            result.add((Value)CollectionUtils.find(values, (IPredicate)SootPredicatesAndTransformers.NULL_PREDICATE));
        }
    }
}

