/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.tokens;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.staticanalyses.Constants;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import edu.ksu.cis.indus.staticanalyses.tokens.ITypeManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenUtil.class);

    @Empty
    private TokenUtil() {
    }

    public static <T extends ITokens<T, V>, V, R> ITokenManager<T, V, R> getTokenManager(ITypeManager<R, V> typeMgr) {
        ITokenManager _tokenMgr = null;
        String _tmType = Constants.getTokenManagerType();
        try {
            Class<?> _class = TokenUtil.class.getClassLoader().loadClass(_tmType);
            Constructor<?> _ctstr = _class.getConstructor(ITypeManager.class);
            if (_ctstr != null) {
                _tokenMgr = (ITokenManager)_ctstr.newInstance(typeMgr);
            }
        }
        catch (InstantiationException _e) {
            LOGGER.error("getTokenManager() - Unable to creat an instance of the given token manager class. : _tmType = " + _tmType, (Throwable)_e);
            InstantiationError _t = new InstantiationError();
            _t.initCause(_e);
            throw _t;
        }
        catch (IllegalAccessException _e) {
            LOGGER.error("getTokenManager() - Unable to access the contructor of the given token manager class. : _tmType = " + _tmType, (Throwable)_e);
            IllegalAccessError _t = new IllegalAccessError();
            _t.initCause(_e);
            throw _t;
        }
        catch (ClassNotFoundException _e) {
            LOGGER.error("getTokenManager() - Unable to find the given token manager class. : _tmType = " + _tmType, (Throwable)_e);
            NoClassDefFoundError _t = new NoClassDefFoundError();
            _t.initCause(_e);
            throw _t;
        }
        catch (NoSuchMethodException _e) {
            LOGGER.error("getTokenManager() - security exception. : _tmType = " + _tmType, (Throwable)_e);
            NoSuchMethodError _t = new NoSuchMethodError();
            _t.initCause(_e);
            throw _t;
        }
        catch (InvocationTargetException _e) {
            LOGGER.error("getTokenManager() - the constructor threw an exception. : _tmType = " + _tmType, (Throwable)_e);
            NoSuchMethodError _t = new NoSuchMethodError();
            _t.initCause(_e);
            throw _t;
        }
        return _tokenMgr;
    }
}

