/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.tokens;

import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.soot.Constants;
import edu.ksu.cis.indus.interfaces.AbstractPrototype;
import edu.ksu.cis.indus.staticanalyses.tokens.AbstractTokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenFilter;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import edu.ksu.cis.indus.staticanalyses.tokens.IType;
import edu.ksu.cis.indus.staticanalyses.tokens.ITypeManager;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerTokenManager<V, R>
extends AbstractTokenManager<IntegerTokens, V, R> {
    static final int NO_OF_BITS_IN_AN_INTEGER = 31;
    final List<V> valueList = new ArrayList<V>();
    final TObjectIntHashMap type2tokens = new TObjectIntHashMap(Constants.getNumOfClassesInApplication());

    public IntegerTokenManager(ITypeManager<R, V> typeManager) {
        super(typeManager);
        typeManager.addObserver(this);
    }

    @Override
    public IntegerTokens getNewTokenSet() {
        return new IntegerTokens(this);
    }

    @Override
    public IntegerTokens getTokens(Collection<V> values) {
        IntegerTokens _result = new IntegerTokens(this);
        if (!values.isEmpty()) {
            Collection _commons = SetUtils.intersection(this.valueList, values);
            Iterator _i = _commons.iterator();
            while (_i.hasNext()) {
                _result.integer |= 1 << this.valueList.indexOf(_i.next());
            }
            Collection _diff = SetUtils.difference(values, (Collection)_commons);
            int _index = 1 << this.valueList.size();
            Iterator _i2 = _diff.iterator();
            while (_i2.hasNext()) {
                if (this.valueList.size() == 31) {
                    throw new IllegalStateException("This token manager cannot handle a type system instance with more than 31 values.");
                }
                Object _value = _i2.next();
                this.valueList.add(_value);
                _result.integer |= _index;
                Collection<IType> _types = this.typeMgr.getAllTypes(_value);
                for (IType _type : _types) {
                    int _t = this.type2tokens.get((Object)_type);
                    this.type2tokens.put((Object)_type, _t | _index);
                }
                _index <<= 1;
            }
        }
        return _result;
    }

    @Override
    public void reset() {
        super.reset();
        this.type2tokens.clear();
        this.valueList.clear();
    }

    @Override
    protected ITokenFilter<IntegerTokens, V> getNewFilterForType(IType type) {
        return new IntegerTokenFilter(type);
    }

    @Override
    protected Collection<V> getValues() {
        return this.valueList;
    }

    @Override
    protected void recordNewTokenTypeRelations(Collection<V> values, IType type) {
        int _t = this.type2tokens.get((Object)type);
        Iterator<V> _i = values.iterator();
        int _iEnd = values.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            _t |= this.valueList.indexOf(_i.next());
            ++_iIndex;
        }
        this.type2tokens.put((Object)type, _t);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IntegerTokens
    extends AbstractPrototype<IntegerTokens>
    implements ITokens<IntegerTokens, V> {
        int integer;
        private IntegerTokenManager<V, R> tokenMgr;

        IntegerTokens(IntegerTokenManager<V, R> tokenManager) {
            this.tokenMgr = tokenManager;
        }

        public IntegerTokens getClone(Object ... o) {
            IntegerTokens _result = new IntegerTokens(this.tokenMgr);
            _result.integer = this.integer;
            return _result;
        }

        @Override
        public boolean isEmpty() {
            return this.integer == 0;
        }

        @Override
        public Collection<V> getValues() {
            ArrayList _result = new ArrayList();
            int _i = 0;
            while (_i < 31) {
                if ((this.integer & 1 << _i) > 0) {
                    _result.add(this.tokenMgr.valueList.get(_i));
                }
                ++_i;
            }
            return _result;
        }

        @Override
        public void addTokens(IntegerTokens newTokens) {
            this.integer |= newTokens.integer;
        }

        @Override
        public void clear() {
            this.integer = 0;
        }

        @Override
        public IntegerTokens diffTokens(IntegerTokens tokens) {
            IntegerTokens _result = new IntegerTokens(this.tokenMgr);
            _result.integer = this.integer & ~tokens.integer;
            return _result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IntegerTokenFilter
    implements ITokenFilter<IntegerTokens, V> {
        final Object filterType;

        IntegerTokenFilter(Object type) {
            this.filterType = type;
        }

        @Override
        public IntegerTokens filter(IntegerTokens tokens) {
            IntegerTokenManager _l = IntegerTokenManager.this;
            IntegerTokens _result = new IntegerTokens(_l);
            _result.integer |= tokens.integer;
            _result.integer &= IntegerTokenManager.this.type2tokens.get(this.filterType);
            return _result;
        }
    }
}

