/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.tokens;

import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.interfaces.AbstractPrototype;
import edu.ksu.cis.indus.staticanalyses.tokens.AbstractTokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenFilter;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import edu.ksu.cis.indus.staticanalyses.tokens.IType;
import edu.ksu.cis.indus.staticanalyses.tokens.ITypeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionTokenManager<V, R>
extends AbstractTokenManager<CollectionTokens, V, R> {
    static final Logger LOGGER = LoggerFactory.getLogger(CollectionTokenManager.class);

    public CollectionTokenManager(ITypeManager<R, V> typeManager) {
        super(typeManager);
    }

    @Override
    public CollectionTokens getNewTokenSet() {
        return new CollectionTokens();
    }

    @Override
    public CollectionTokens getTokens(Collection<V> values) {
        return new CollectionTokens(values);
    }

    protected CollectionTokenFilter getNewFilterForType(IType type) {
        return new CollectionTokenFilter(type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CollectionTokenFilter
    implements ITokenFilter<CollectionTokens, V> {
        private final IType filterType;

        CollectionTokenFilter(IType type) {
            this.filterType = type;
        }

        @Override
        public CollectionTokens filter(CollectionTokens tokens) {
            ArrayList _filterate = new ArrayList();
            for (Object _value : tokens.getValues()) {
                if (!CollectionTokenManager.this.typeMgr.getAllTypes(_value).contains(this.filterType)) continue;
                _filterate.add(_value);
            }
            return CollectionTokenManager.this.getTokens((Collection)_filterate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CollectionTokens
    extends AbstractPrototype<CollectionTokens>
    implements ITokens<CollectionTokens, V> {
        private Collection<V> values;

        CollectionTokens(Collection<V> initValues) {
            this.values = new HashSet(initValues);
        }

        CollectionTokens() {
            this.values = new HashSet();
        }

        public CollectionTokens getClone(Object ... o) {
            return new CollectionTokens(this.values);
        }

        @Override
        public boolean isEmpty() {
            return this.values.isEmpty();
        }

        @Override
        public Collection<V> getValues() {
            return Collections.unmodifiableCollection(this.values);
        }

        @Override
        public void addTokens(CollectionTokens newTokens) {
            this.values.addAll(newTokens.values);
        }

        @Override
        public void clear() {
            this.values.clear();
        }

        @Override
        public CollectionTokens diffTokens(CollectionTokens tokens) {
            return new CollectionTokens(SetUtils.difference(this.values, tokens.values));
        }
    }
}

