/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.tokens;

import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.IFactory;
import edu.ksu.cis.indus.common.collections.ListOrderedSet;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.soot.Constants;
import edu.ksu.cis.indus.interfaces.AbstractPrototype;
import edu.ksu.cis.indus.staticanalyses.tokens.AbstractTokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenFilter;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import edu.ksu.cis.indus.staticanalyses.tokens.IType;
import edu.ksu.cis.indus.staticanalyses.tokens.ITypeManager;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BitSetTokenManager<V, R>
extends AbstractTokenManager<BitSetTokens, V, R> {
    static final Logger LOGGER = LoggerFactory.getLogger(BitSetTokenManager.class);
    final ListOrderedSet<V> valueList = new ListOrderedSet();
    private final Map<IType, BitSet> type2tokens = new HashMap<IType, BitSet>(Constants.getNumOfClassesInApplication());
    private final Map<IType, BitSetTokenFilter> type2tokenfilters = new HashMap<IType, BitSetTokenFilter>(Constants.getNumOfClassesInApplication());

    public BitSetTokenManager(ITypeManager<R, V> typeManager) {
        super(typeManager);
        typeManager.addObserver(this);
    }

    @Override
    public BitSetTokens getNewTokenSet() {
        return new BitSetTokens();
    }

    @Override
    public BitSetTokens getTokens(Collection<V> values) {
        BitSetTokens _result = new BitSetTokens(values.size());
        if (!values.isEmpty()) {
            Collection _commons = SetUtils.intersection(this.valueList, values);
            for (Object _o : _commons) {
                _result.bitset.set(this.valueList.indexOf(_o));
            }
            Collection _diff = SetUtils.difference(values, (Collection)_commons);
            int _index = this.valueList.size();
            for (Object _value : _diff) {
                this.valueList.add(_value);
                _result.bitset.set(_index);
                Collection<IType> _types = this.typeMgr.getAllTypes(_value);
                for (IType _type : _types) {
                    BitSet _tokens = (BitSet)MapUtils.getFromMapUsingFactory(this.type2tokens, (Object)_type, (IFactory)CollectionUtils.BITSET_FACTORY);
                    _tokens.set(_index);
                }
                ++_index;
            }
        }
        return _result;
    }

    @Override
    public void reset() {
        super.reset();
        this.valueList.clear();
        this.type2tokens.clear();
        this.type2tokenfilters.clear();
    }

    protected BitSetTokenFilter getNewFilterForType(IType type) {
        BitSetTokenFilter _result;
        if (this.type2tokenfilters.containsKey(type)) {
            _result = this.type2tokenfilters.get(type);
        } else {
            BitSet _mask = (BitSet)MapUtils.getFromMapUsingFactory(this.type2tokens, (Object)type, (IFactory)CollectionUtils.BITSET_FACTORY);
            _result = new BitSetTokenFilter(_mask);
            this.type2tokenfilters.put(type, _result);
        }
        return _result;
    }

    @Override
    protected void recordNewTokenTypeRelations(Collection<V> values, IType type) {
        BitSet _b = (BitSet)MapUtils.getFromMapUsingFactory(this.type2tokens, (Object)type, (IFactory)CollectionUtils.BITSET_FACTORY);
        Iterator<V> _i = values.iterator();
        int _iEnd = values.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            _b.set(this.valueList.indexOf(_i.next()));
            ++_iIndex;
        }
    }

    @Override
    protected Collection<V> getValues() {
        return this.valueList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BitSetTokenFilter
    implements ITokenFilter<BitSetTokens, V> {
        private final BitSet bitmask;

        BitSetTokenFilter(BitSet mask) {
            this.bitmask = mask;
        }

        @Override
        public BitSetTokens filter(BitSetTokens tokens) {
            BitSetTokens _result = new BitSetTokens(this.bitmask.size());
            BitSet _temp = _result.bitset;
            _temp.or(this.bitmask);
            _temp.and(tokens.bitset);
            return _result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BitSetTokens
    extends AbstractPrototype<BitSetTokens>
    implements ITokens<BitSetTokens, V> {
        final BitSet bitset;

        BitSetTokens() {
            this(8);
        }

        BitSetTokens(int initLength) {
            assert (initLength >= 0);
            this.bitset = new BitSet(initLength);
        }

        public BitSetTokens getClone(Object ... o) {
            BitSetTokens _result = new BitSetTokens(this.bitset.size());
            _result.bitset.or(this.bitset);
            return _result;
        }

        @Override
        public boolean isEmpty() {
            return this.bitset.cardinality() == 0;
        }

        @Override
        public Collection<V> getValues() {
            ArrayList<Object> _result = new ArrayList<Object>(this.bitset.cardinality());
            int _i = this.bitset.nextSetBit(0);
            while (_i >= 0) {
                _result.add(BitSetTokenManager.this.valueList.get(_i));
                _i = this.bitset.nextSetBit(_i + 1);
            }
            return _result;
        }

        @Override
        public void addTokens(BitSetTokens newTokens) {
            this.bitset.or(newTokens.bitset);
        }

        @Override
        public void clear() {
            this.bitset.clear();
        }

        @Override
        public BitSetTokens diffTokens(BitSetTokens tokens) {
            BitSetTokens _result = new BitSetTokens(this.bitset.size());
            _result.bitset.or(this.bitset);
            if (this.bitset.intersects(tokens.bitset)) {
                _result.bitset.andNot(tokens.bitset);
            }
            return _result;
        }
    }
}

