/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.tokens;

import edu.ksu.cis.indus.IndusTestCase;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenFilter;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.ITypeManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import soot.Type;
import soot.Value;
import soot.jimple.IntConstant;
import soot.jimple.NullConstant;
import soot.jimple.StringConstant;

public abstract class AbstractTokenManagerTest
extends IndusTestCase {
    protected Collection values = new HashSet();
    protected ITokenManager tokenManager;

    public void testGetTokens() {
        Object _tokens = this.tokenManager.getTokens(this.values);
        AbstractTokenManagerTest.assertNotNull(_tokens);
        AbstractTokenManagerTest.assertTrue((boolean)_tokens.getValues().containsAll(this.values));
        AbstractTokenManagerTest.assertTrue((boolean)this.values.containsAll(_tokens.getValues()));
    }

    public final void testGetTypeBasedFilter() {
        ITypeManager _typeMgr = this.tokenManager.getTypeManager();
        Type _type = ((Value)this.values.iterator().next()).getType();
        ITokenFilter _filter = this.tokenManager.getTypeBasedFilter(_typeMgr.getTokenTypeForRepType(_type));
        AbstractTokenManagerTest.assertNotNull(_filter);
        Object _falseTokens = this.tokenManager.getTokens((Collection)Collections.singleton(IntConstant.v((int)1)));
        AbstractTokenManagerTest.assertFalse((boolean)_falseTokens.isEmpty());
        AbstractTokenManagerTest.assertTrue((boolean)_filter.filter(_falseTokens).isEmpty());
        this.values.add(NullConstant.v());
        Object _trueTokens = this.tokenManager.getTokens(this.values);
        Object _filtrate = _filter.filter(_trueTokens);
        AbstractTokenManagerTest.assertFalse((boolean)_filtrate.isEmpty());
        AbstractTokenManagerTest.assertTrue((boolean)_filtrate.getValues().contains(NullConstant.v()));
    }

    public final void testGetTypeManager() {
        ITypeManager _typeMgr = this.tokenManager.getTypeManager();
        AbstractTokenManagerTest.assertNotNull(_typeMgr);
        for (Object _val : this.values) {
            AbstractTokenManagerTest.assertNotNull((Object)_typeMgr.getTokenTypeForRepType(((Value)_val).getType()));
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.values.add(StringConstant.v((String)"Hi"));
        this.values.add(StringConstant.v((String)"Bye"));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.values.clear();
        this.values = null;
    }
}

